/* This file is part of the KMPlayer project
 *
 * Copyright (C) 2005 Koos Vriezen <koos.vriezen@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * until boost gets common, a more or less compatable one ..
 */

#ifndef _KMPLAYER_CONTROL_H_
#define _KMPLAYER_CONTROL_H_

#include "kmplayerplaylist.h"
#include "kmplayerprocess.h"

#ifndef MAEMO_NO_EXPORT
# define MAEMO_NO_EXPORT __attribute__ ((visibility("hidden")))
#endif

typedef struct _Application Application;
typedef struct _GtkWidget GtkWidget;

namespace KMPlayer {

class ActorAgent;
class ViewArea;

struct MAEMO_NO_EXPORT PlayListData {
    PlayListData (short id, PlayListData * n = 0L);
    NodePtr document;
    NodePtrW current;
    GdkPixbuf * icon;
    Document *updated_document;
    unsigned int updated_document_version;
    short id;
    bool show_all;
    bool edit_mode;
    PlayListData * next;
};


class MAEMO_NO_EXPORT Control : public PlayListNotify, public ProcessNotify {
    Process * m_process;
    Rect video_rect;
    int m_doc_timer;
    GtkWidget *progress_banner;
public:
    Control (Application * a);
    ~Control ();
    void init ();
    void deinit ();
    void play ();
    void stop (bool keep_fullscreen=false);
    void openDocument (NodePtr doc, NodePtr cur);
    void playCurrent ();
    String currentMrl ();
    void updatePlaylistView (bool force=false);
    ViewArea *viewArea () const;
    unsigned long videoOutput () const;
    void addRecent (const String &url);
    void setCurrentSelected (NodePtr node);
    /**
     * PlayListNotify implementation
     */
    ActorAgent *actorAgent () const;
    bool requestPlayURL (NodePtr mrl);
    bool setCurrent (NodePtr);
    bool applyBackRequest();
    void stateElementChanged (Node * n, Node::State os, Node::State ns);
    void updateViewAreaSizes ();
    void bitRates (int & prefered, int & maximal);
    void setTimeout (int ms);
    void openUrl (const URL &, const String &target, const String &srv);
    void addRepaintUpdater (Node *node);
    void removeRepaintUpdater (Node *node);
    void enableRepaintUpdaters (bool enable, unsigned int off_time);

    void setProcess (Process * p) { m_process = p; }
    bool setProcess (const char *pname);
    bool setProcess (Mrl *mrl);
    Process * process () { return m_process; }
    bool docTimerEvent ();

    // ProcessNotify
    void stateChanged (Process * p, Process::State os, Process::State ns);
    void errorMsg (const String & msg);
    void setLoading (int perc);
    void setPosition (int pos) ;
    void setLength (int len);
    void setAspect (float aspect);
    void setUseXVideo (bool b);

    Process *media_server;
    Process *mplayer;
#ifdef __ARMEL__
    Process *npp;
#endif
    Process *downloader;

    NodePtr playlists;
    NodePtr recents;

    String copyPasteUrl;
    NodePtr copyPasteNode;

    PlayListData *playlist_data;
    NodePtrW back_request;
    NodePtrW current_selected;
    String cur_url;
    Config * m_config;
    Application * m_app;
    int paint_timer;
    int update_tree_timer;
    int blanking_timer;
    int width, height;
    float aspect;
    Rect paint_rect;
    bool in_progress_update;
    bool request_download;
    bool use_xvideo;
private:
    ActorAgent *actor_agent;
    NodeList extra_playlists;
};

class MAEMO_NO_EXPORT SourceDocument : public Document {
public:
    SourceDocument (Control *c, const String &url);

    void *message (MessageType msg, void *data=NULL);

    Control *m_control;
};

void updateTree (Application *app, short id) MAEMO_NO_EXPORT;
void updatePlayTree (Application *app) MAEMO_NO_EXPORT;
void rowSelected (Application *app) MAEMO_NO_EXPORT;
void nextSelected (Application *app) MAEMO_NO_EXPORT;
void previousSelected (Application *app) MAEMO_NO_EXPORT;
short addTree (Application *a, KMPlayer::NodePtr doc, GdkPixbuf *ico) MAEMO_NO_EXPORT;
void jump (KMPlayer::Node *n, Control *ctr) MAEMO_NO_EXPORT;

} // namespace

#endif // _KMPLAYER_CONTROL_H_
