/* gcc -o appviewmenu appviewmenu.c `pkg-config hildon-lgpl --cflags`  `pkg-config hildon-libs --libs` `pkg-config hildon-fm --cflags --libs` `pkg-config dbus-1 --cflags --libs`
*/

#include <config.h>
#include <locale.h>
#include <errno.h>
#include <libintl.h>
#include <stdlib.h>
#include <libgen.h>
#include <string.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <pango/pango-font.h>
#include <libgnomevfs/gnome-vfs-init.h>
#include <gtkhtml/gtkhtml.h>
#define DBUS_API_SUBJECT_TO_CHANGE
#include <dbus/dbus.h>
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>
#ifdef BUILD_BORA
# include <hildon-widgets/hildon-program.h>
# include <hildon-widgets/gtk-infoprint.h>
# include <hildon-widgets/hildon-window.h>
# include <hildon-widgets/hildon-seekbar.h>
# include <hildon-widgets/hildon-file-chooser-dialog.h>
#else
# include <hildon/hildon-defines.h>
# include <hildon/hildon-program.h>
# include <hildon/hildon-window.h>
# include <hildon/hildon-note.h>
# include <hildon/hildon-seekbar.h>
# include <hildon/hildon-file-chooser-dialog.h>
# include <hildon/hildon-banner.h>
#endif

#define bool char
#define true 1
#define false 0
#include "kmplayer.h"
/*#define noname www_xpm
//#include "www.xpm"
#undef noname*/
#define MAEMO_NO_EXPORT __attribute__ ((visibility("hidden")))

gint dbus_req_handler (const gchar *interface, const gchar *method,
        GArray *arguments, gpointer data, osso_rpc_t *retval);
void exit_event_handler (gboolean die_now, gpointer data);

gchar *app_file_chooser (Application *app, const char *title, GtkFileChooserAction act) {
    GtkWidget *dialog;
    gchar *filename = NULL;
    dialog = hildon_file_chooser_dialog_new (app->window, act);
    if (app->save_folder)
        gtk_file_chooser_set_current_folder (
                GTK_FILE_CHOOSER (dialog), app->save_folder);
    if (title)
        gtk_file_chooser_set_current_name (GTK_FILE_CHOOSER (dialog), title);
    gtk_file_chooser_set_do_overwrite_confirmation (GTK_FILE_CHOOSER (dialog), TRUE);
    gtk_widget_show_all (GTK_WIDGET (dialog));
    if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK) {
        filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
        if (filename && filename[0]) {
            if (app->save_folder)
                g_free (app->save_folder);
            app->save_folder = dirname (g_strdup (filename));
        }
    }
    gtk_widget_destroy (dialog);
    return filename;
}

void app_set_title (const char *title, Application *app) {
    gtk_window_set_title (app->window, title);
}

void app_insert_location (Application *app, const char *loc) {
    GtkTreeIter it, it2;
    int count = 1;
    bool b;
    GtkTreeModel * model = GTK_TREE_MODEL (gtk_combo_box_get_model (
                GTK_COMBO_BOX (app->location_bar)));
    if (gtk_tree_model_get_iter_first (model, &it2))
        gtk_list_store_insert_before (GTK_LIST_STORE (model), &it, &it2);
    else
        gtk_list_store_append (GTK_LIST_STORE (model), &it);
    gtk_list_store_set (GTK_LIST_STORE (model), &it, 0, loc, -1);
    for (b = gtk_tree_model_iter_next (model, &it); b; ) {
        GValue value = { 0 , };
        const gchar *val;
        gtk_tree_model_get_value (model, &it, 0, &value);
        val = g_value_get_string (&value);
        if (!val || !val[0]) {
            b = gtk_list_store_remove (GTK_LIST_STORE (model), &it);
        } else {
            if (!strcmp (val, loc) || count > 6) {
                b = gtk_list_store_remove (GTK_LIST_STORE (model), &it);
            } else {
                b = gtk_tree_model_iter_next (model, &it);
                count++;
            }
        }
        g_value_unset (&value);
    }
    if (gtk_tree_model_get_iter_first (model, &it))
        gtk_combo_box_set_active_iter (GTK_COMBO_BOX (app->location_bar), &it);
    gtk_widget_grab_focus (app->playlist_view);
}

void app_open_location (const char *filename, Application *app) {
    gtk_window_set_title (app->window, filename);
    openFile (app, filename);
    app_insert_location (app, filename);
}

typedef struct _OpenLocation {
    Application *app;
    const char *filename;
} OpenLocation;

static gboolean delayed_open_location (OpenLocation *ol) {
    app_open_location (ol->filename, ol->app);
    g_free (ol->filename);
    free (ol);
    return FALSE;
}

void app_set_playing (Application *app, int p) {
    app->playing = p;
    if (PLAYING == p) {
        gtk_widget_hide (GTK_WIDGET (app->tb_play));
        gtk_widget_show (GTK_WIDGET (app->tb_pause));
        gtk_widget_hide (GTK_WIDGET (app->tb_save));
        gtk_widget_show (GTK_WIDGET (app->tb_stop));
    } else {
        gtk_widget_hide (GTK_WIDGET (app->tb_pause));
        gtk_widget_show (GTK_WIDGET (app->tb_play));
        if (NOT_PLAYING == p) {
            gtk_widget_hide (GTK_WIDGET (app->tb_stop));
            gtk_widget_show (GTK_WIDGET (app->tb_save));
        } else {
            gtk_widget_hide (GTK_WIDGET (app->tb_save));
            gtk_widget_show (GTK_WIDGET (app->tb_stop));
        }
    }
}

static void _app_setup_window (GtkWidget * w, Application *app) {
    gtk_widget_add_events (w,
            GDK_EXPOSURE_MASK | GDK_VISIBILITY_NOTIFY_MASK |
            GDK_BUTTON_PRESS_MASK | GDK_KEY_PRESS_MASK |
            GDK_STRUCTURE_MASK);
    g_signal_connect (G_OBJECT (w), "realize",
        GTK_SIGNAL_FUNC (cb_view_area_realized), app);
    g_signal_connect (G_OBJECT (w), "expose-event",
        GTK_SIGNAL_FUNC (cb_view_area_expose), app);
    g_signal_connect (G_OBJECT (w), "button-press-event",
        GTK_SIGNAL_FUNC (cb_view_area_button_press), app);
    g_signal_connect (G_OBJECT (w), "configure-event",
            GTK_SIGNAL_FUNC (cb_view_area_configure), app);
}

void app_full_screen (Application *app) {
    if (!app->fullscreen) {
        if (!app->window_fullscreen) {
            HildonWindow *win = HILDON_WINDOW (hildon_window_new ());
            app->window_fullscreen = GTK_WINDOW (win);
            app->view_area_fullscreen = gtk_drawing_area_new ();
            gtk_container_add (GTK_CONTAINER (win),
                    app->view_area_fullscreen);
            _app_setup_window (app->view_area_fullscreen, app);
            hildon_program_add_window (HILDON_PROGRAM (app->program), win);
            g_signal_connect (G_OBJECT (win), "map-event",
                    GTK_SIGNAL_FUNC (cbViewAreaFullscreenMapped), app);
            g_signal_connect (G_OBJECT (win), "unmap",
                    GTK_SIGNAL_FUNC (cbViewAreaFullscreenUnmapped), app);
            g_signal_connect (G_OBJECT (win), "destroy",
                    GTK_SIGNAL_FUNC (cb_fullscreen_destoyed), app);
            g_signal_connect (G_OBJECT (win), "key-press-event",
                    GTK_SIGNAL_FUNC (cb_keyPressed), (void *)app);
        }
        gtk_widget_show_all (GTK_WIDGET (app->window_fullscreen));
        app->fullscreen = true;
    }
}

void app_normal_screen (Application *app) {
    if (app->fullscreen) {
        gtk_widget_hide (GTK_WIDGET (app->window_fullscreen));
        app->fullscreen = false;
    }
}

static void callback_file_open (GtkButton * button, Application * app) {
    gchar *filename = NULL;
    filename = app_file_chooser(app, NULL, GTK_FILE_CHOOSER_ACTION_OPEN);
    if (filename) {
        app_open_location (filename, app);
        g_free (filename);
    }
}

static void callback_file_go (GtkButton *button, Application *app) {
    const gchar *val = gtk_combo_box_get_active_text (
                GTK_COMBO_BOX (app->location_bar));
    (void)button;
    if (val && val[0]) {
        gtk_window_set_title (app->window, val);
        openFile (app, val);
        app_insert_location (app, val);
    }
}

static void callback_file_save_as (GtkButton * button, Application * app) {
    gchar *filename = NULL;
    filename = app_file_chooser (app, NULL, GTK_FILE_CHOOSER_ACTION_SAVE);
    if (filename) {
        gchar * info;
        if (saveFile (app->control, filename)) {
            info = g_strdup_printf ("Saved as %s", filename);
            gtk_window_set_title (app->window, filename);
            app_insert_location (app, filename);
        } else
            info = g_strdup_printf ("Saving as %s failed (%s)", filename, strerror (errno));
        hildon_banner_show_information (GTK_WIDGET (app->window), NULL, info);
        g_free (info);
        g_free (filename);
    }
}

static void callback_file_save (GtkButton * button, Application * app) {
    const char * fn = saveFile (app->control, NULL);
    gchar *info;
    if (fn && fn [0]) {
        info = g_strdup_printf ("Saved as %s", fn);
    } else {
        info = g_strdup_printf ("Saving failed (%s)", strerror (errno));
        hildon_banner_show_information (GTK_WIDGET (app->window), NULL, info);
        callback_file_save_as (0L, app);
    }
    g_free (info);
}

static void callback_file_new (GtkButton * button, Application * app) {
    newFile (app);
    gtk_window_set_title (app->window, "");
}

static gboolean
locationbarLostFocus (GtkWidget *gw, GdkEventFocus *gef, Application *app) {
    int n = gtk_toolbar_get_n_items (GTK_TOOLBAR (app->main_toolbar));
    int i;
    (void)gw; (void)gef;
    for (i = 5; i < n; i++)
        gtk_widget_show (GTK_WIDGET (gtk_toolbar_get_nth_item (GTK_TOOLBAR (app->main_toolbar), i)));
    app_set_playing (app, app->playing);
    gtk_editable_select_region (GTK_EDITABLE (GTK_BIN (app->location_bar)->child), 0, 0);
    return false;
}

gboolean locationbarKeyEvent (GtkWidget *w, GdkEventKey *e, Application *app) {
    (void)w;
    switch (e->keyval) {
        case GDK_Return:
        case GDK_KP_Enter:
            callback_file_go (NULL, app);
            return true;
    }
    return false;
}

static bool first_time_exposed;

static
bool cb_window_expose (GtkWidget *w, GdkEventExpose *ev, Application *app) {
    if (!first_time_exposed) {
        first_time_exposed = true;
        gtk_paned_set_position (app->hsplit_view, HSPLIT);
        gtk_paned_set_position (app->vsplit_view, VSPLIT);
        gtk_widget_hide (GTK_WIDGET (app->tb_progress));
        gtk_widget_hide (GTK_WIDGET (app->tb_item_playlist_commit));
    }
    return false;
}

static void windowTopMost (GObject * self, GParamSpec *gps, Application * app) {
    (void)gps;
    if (app->fullscreen && hildon_window_get_is_topmost (HILDON_WINDOW (app->window)))
        app_normal_screen (app);
}

/* Create the menu items needed for the main view */
static void create_toolbar (Application * app) {
    /* Create needed variables */
    GtkToolItem *tb_open;
    GtkToolItem *tb_prev;
    GtkToolItem *tb_next;
    GtkToolItem *tb_go;
    GtkToolItem *tb_separator;

    /* Create toolbar */
    app->main_toolbar = gtk_toolbar_new();

    /* Create toolbar button items */
    tb_open = gtk_tool_button_new_from_stock (GTK_STOCK_OPEN);
    tb_prev = gtk_tool_button_new_from_stock (GTK_STOCK_MEDIA_PREVIOUS);
    app->tb_play = gtk_tool_button_new_from_stock (GTK_STOCK_MEDIA_PLAY);
    app->tb_pause = gtk_tool_button_new_from_stock (GTK_STOCK_MEDIA_PAUSE);
    tb_next = gtk_tool_button_new_from_stock (GTK_STOCK_MEDIA_NEXT);
    app->tb_stop = gtk_tool_button_new_from_stock (GTK_STOCK_MEDIA_STOP);
    app->tb_save = gtk_tool_button_new_from_stock (GTK_STOCK_SAVE);
    tb_go = gtk_tool_button_new (gtk_image_new_from_icon_name(
                "qgn_toolb_browser_gobutton", HILDON_ICON_SIZE_TOOLBAR), NULL);
    app->tb_item_playlist_commit = GTK_WIDGET (gtk_tool_button_new (
                gtk_image_new_from_icon_name(
                    "qgn_toolb_gene_refresh", HILDON_ICON_SIZE_TOOLBAR), NULL));
    /* Create toolbar combobox item */
    app->tb_location = gtk_tool_item_new();
    app->tb_progress = gtk_tool_item_new();
    GtkListStore * model = gtk_list_store_new (1, G_TYPE_STRING);
    GtkTreeIter iterator;
    gtk_list_store_append (model, &iterator);
    gtk_list_store_set (model, &iterator, 0, "", -1);
    app->location_bar = gtk_combo_box_entry_new_with_model (
            GTK_TREE_MODEL (model), 0);
    app->progress_bar = hildon_seekbar_new ();
    /* Make combobox to use all available toolbar space */
    gtk_tool_item_set_expand (app->tb_location, TRUE);
    gtk_tool_item_set_expand (app->tb_progress, TRUE);
    /* Add combobox inside toolitem */
    gtk_container_add (GTK_CONTAINER (app->tb_location), app->location_bar);
    gtk_container_add (GTK_CONTAINER (app->tb_progress), app->progress_bar);

    /* Create separator */
    tb_separator = gtk_separator_tool_item_new();

    /* Add all items to toolbar */
    gtk_toolbar_insert(GTK_TOOLBAR(app->main_toolbar), app->tb_location, -1);
    gtk_toolbar_insert(GTK_TOOLBAR(app->main_toolbar), app->tb_progress, -1);
    gtk_toolbar_insert(GTK_TOOLBAR(app->main_toolbar), tb_go, -1);
    gtk_toolbar_insert(GTK_TOOLBAR(app->main_toolbar), tb_open, -1);
    gtk_toolbar_insert(GTK_TOOLBAR(app->main_toolbar), GTK_TOOL_ITEM (app->tb_item_playlist_commit), -1);
    gtk_toolbar_insert(GTK_TOOLBAR(app->main_toolbar), tb_separator, -1);
    gtk_toolbar_insert(GTK_TOOLBAR(app->main_toolbar), tb_prev, -1);
    gtk_toolbar_insert(GTK_TOOLBAR(app->main_toolbar), app->tb_play, -1);
    gtk_toolbar_insert(GTK_TOOLBAR(app->main_toolbar), app->tb_pause, -1);
    gtk_toolbar_insert(GTK_TOOLBAR(app->main_toolbar), tb_next, -1);
    gtk_toolbar_insert(GTK_TOOLBAR(app->main_toolbar), app->tb_stop, -1);
    gtk_toolbar_insert(GTK_TOOLBAR(app->main_toolbar), app->tb_save, -1);

    /* Add signal lister to "Close" button */
    g_signal_connect (G_OBJECT (tb_go), "clicked",
        G_CALLBACK (callback_file_go), app);
    g_signal_connect (G_OBJECT (tb_open), "clicked",
        G_CALLBACK(callback_file_open), app);
    g_signal_connect (G_OBJECT (tb_prev), "clicked",
        G_CALLBACK (cb_playlist_prev), app->control);
    g_signal_connect (G_OBJECT (app->tb_play), "clicked",
        G_CALLBACK (cb_playlist_play), app->control);
    g_signal_connect (G_OBJECT (app->tb_pause), "clicked",
        G_CALLBACK (cb_playlist_play), app->control);
    g_signal_connect (G_OBJECT (tb_next), "clicked",
        G_CALLBACK (cb_playlist_next), app->control);
    g_signal_connect (G_OBJECT (app->tb_stop), "clicked",
        G_CALLBACK (cb_playlist_stop), app->control);
    g_signal_connect (G_OBJECT (app->tb_save), "clicked",
        G_CALLBACK (cb_playlist_stop), app->control);
    g_signal_connect (G_OBJECT (app->tb_item_playlist_commit), "clicked",
        G_CALLBACK (cb_playlist_edit_commit), app);
    g_signal_connect (G_OBJECT (app->progress_bar), "value-changed",
        G_CALLBACK (progressValueChanged), app);

    /* Add toolbar to 'vbox' of HildonAppView */
    gtk_widget_show_all (GTK_WIDGET (app->main_toolbar));
    gtk_widget_hide (GTK_WIDGET (app->tb_progress));
    gtk_widget_hide (GTK_WIDGET (app->tb_pause));
    gtk_widget_hide (GTK_WIDGET (app->tb_stop));
    hildon_window_add_toolbar (HILDON_WINDOW (app->window),
            GTK_TOOLBAR(app->main_toolbar));
}

static void mainMenuShow (GtkWidget *w, Application *app) {
    (void)w;
    app_set_suspend (app, true);
}

static void mainMenuHide (GtkWidget *w, Application *app) {
    (void)w;
    app_set_suspend (app, false);
}

/* Create the menu items needed for the main view */
static void create_menu (Application * app) {
    /* Create needed variables */
    GtkMenu *main_menu;
    GtkWidget *item_new;
    GtkWidget *item_open;
    GtkWidget *item_save;
    GtkWidget *item_save_as;
    GtkWidget *menu_playlist;
    GtkWidget *menu_players;
    GtkWidget *item_close;
    GtkWidget *item_separator;
    GtkWidget *item_playlist;
    GtkWidget *item_playlist_show;
    GtkWidget *item_players;

    /* Get the menu from view */
    main_menu = GTK_MENU (gtk_menu_new ());

    /* Create new submenu for "Others" */
    menu_playlist = gtk_menu_new ();
    menu_players = gtk_menu_new ();

    /* Create menu items */
    item_new = gtk_menu_item_new_with_label ("New");
    item_open = gtk_menu_item_new_with_label ("Open");
    item_save = gtk_menu_item_new_with_label ("Save");
    item_save_as = gtk_menu_item_new_with_label ("Save As");
    /* item_check = gtk_check_menu_item_new_with_label ("Check");*/
    item_playlist = gtk_menu_item_new_with_label ("Playlist");
    item_playlist_show = gtk_check_menu_item_new_with_label ("Show");
    app->menu_item_playlist_copy = gtk_menu_item_new_with_label("Copy");
    app->menu_item_playlist_paste = gtk_menu_item_new_with_label("Paste");
    app->menu_item_playlist_paste_in_group = gtk_menu_item_new_with_label ("Paste in new Group");
    app->menu_item_playlist_cut = gtk_menu_item_new_with_label("Cut");
    app->menu_item_playlist_showall = gtk_check_menu_item_new_with_label ("Show All");
    app->menu_item_playlist_edit = gtk_check_menu_item_new_with_label ("Edit");
    item_close = gtk_menu_item_new_with_label ("Close");
    item_separator = gtk_separator_menu_item_new ();
    item_players = gtk_menu_item_new_with_label ("Player");
    app->menu_item_media_server = gtk_radio_menu_item_new_with_label (NULL, "Osso Media Server");
    app->menu_item_mplayer = gtk_radio_menu_item_new_with_label_from_widget(
            GTK_RADIO_MENU_ITEM (app->menu_item_media_server), "MPlayer");
    app->menu_item_npp = gtk_radio_menu_item_new_with_label_from_widget(
            GTK_RADIO_MENU_ITEM (app->menu_item_media_server), "Flash");
    
    /* Add menu items to right menus */
    gtk_menu_append (main_menu, item_new);
    gtk_menu_append (main_menu, item_open);
    gtk_menu_append (main_menu, item_save);
    gtk_menu_append (main_menu, item_save_as);
    gtk_menu_append (main_menu, item_playlist);
    gtk_menu_append (main_menu, item_players);
    gtk_menu_append (menu_playlist, app->menu_item_playlist_copy);
    gtk_menu_append (menu_playlist, app->menu_item_playlist_paste);
    gtk_menu_append (menu_playlist, app->menu_item_playlist_paste_in_group);
    gtk_menu_append (menu_playlist, app->menu_item_playlist_cut);
    gtk_menu_append (menu_playlist, item_separator);
    gtk_menu_append (menu_playlist, app->menu_item_playlist_showall);
    gtk_menu_append (menu_playlist, app->menu_item_playlist_edit);
    gtk_menu_append (menu_players, app->menu_item_media_server);
    gtk_menu_append (menu_players, app->menu_item_mplayer);
    gtk_menu_append (menu_players, app->menu_item_npp);
    gtk_menu_append( main_menu, item_close );

    /* Add others submenu to the "Others" item */
    gtk_menu_item_set_submenu (GTK_MENU_ITEM (item_playlist), menu_playlist);
    gtk_menu_item_set_submenu (GTK_MENU_ITEM (item_players), menu_players);

    /* Attach the callback functions to the activate signal */
    g_signal_connect (G_OBJECT (item_new), "activate",
        G_CALLBACK (callback_file_new), app);
    g_signal_connect( G_OBJECT( item_close ), "activate",
        GTK_SIGNAL_FUNC (cb_mainview_close), app);
    g_signal_connect (G_OBJECT (item_open), "activate",
        GTK_SIGNAL_FUNC (callback_file_open), app);
    g_signal_connect (G_OBJECT (item_save), "activate",
        GTK_SIGNAL_FUNC (callback_file_save), app);
    g_signal_connect (G_OBJECT (item_save_as), "activate",
        GTK_SIGNAL_FUNC (callback_file_save_as), app);
    g_signal_connect (G_OBJECT (item_playlist), "activate",
        GTK_SIGNAL_FUNC (cb_playlistMenuActivate), app);
    g_signal_connect (G_OBJECT (app->menu_item_playlist_copy), "activate",
        GTK_SIGNAL_FUNC (cb_playlistCopy), app);
    g_signal_connect (G_OBJECT (app->menu_item_playlist_paste), "activate",
        GTK_SIGNAL_FUNC (cb_playlistPaste), app);
    g_signal_connect (G_OBJECT (app->menu_item_playlist_paste_in_group), "activate",
        GTK_SIGNAL_FUNC (cb_playlistPasteInNewGroup), app);
    g_signal_connect (G_OBJECT (app->menu_item_playlist_cut), "activate",
        GTK_SIGNAL_FUNC (cb_playlistCut), app);
    g_signal_connect (G_OBJECT (item_playlist_show), "toggled",
        GTK_SIGNAL_FUNC (togglePlaylistShow), app);
    g_signal_connect (G_OBJECT (app->menu_item_playlist_showall), "toggled",
        GTK_SIGNAL_FUNC (togglePlaylistShowAll), app);
    g_signal_connect (G_OBJECT (app->menu_item_playlist_edit), "toggled",
        GTK_SIGNAL_FUNC (togglePlaylistEdit), app);
    g_signal_connect (G_OBJECT (app->menu_item_media_server), "toggled",
        GTK_SIGNAL_FUNC (toggleMediaServer), app);
    g_signal_connect (G_OBJECT (app->menu_item_mplayer), "toggled",
        GTK_SIGNAL_FUNC (toggleMediaServer), app);
    g_signal_connect (G_OBJECT (app->menu_item_npp), "toggled",
        GTK_SIGNAL_FUNC (toggleMediaServer), app);

    g_signal_connect (G_OBJECT (main_menu), "show",
        GTK_SIGNAL_FUNC (mainMenuShow), app);
    g_signal_connect (G_OBJECT (main_menu), "hide",
        GTK_SIGNAL_FUNC (mainMenuHide), app);
    /* Make all menu widgets visible */
    gtk_widget_show_all (GTK_WIDGET (main_menu));
    hildon_program_set_common_menu (HILDON_PROGRAM (app->program), main_menu);
}

/* Callback for normal D-BUS messages */
gint dbus_req_handler( const gchar *interface, const gchar *method,
        GArray *arguments, gpointer data, osso_rpc_t *retval ) {
    Application *appdata = (Application *) data;
    int i;

    if (!strcmp (method, "top_application"))
        gtk_window_present (appdata->window);
    else if (!strcmp (method, "mime_open") || !strcmp (method, "load_url")) {
        for (i = 0; i < arguments->len; ++i) {
            osso_rpc_t val = g_array_index (arguments, osso_rpc_t, i);
            if (val.type == DBUS_TYPE_STRING && val.value.s != NULL) {
                OpenLocation *ol = (OpenLocation *)malloc (sizeof (OpenLocation));
                ol->filename = g_strdup(val.value.s);
                ol->app = appdata;
                g_idle_add (delayed_open_location, (gpointer)ol);
            }
        }
    } else
        g_print("Unknown DBUS method: %s\n", method);
    if (retval)
        retval->type = DBUS_TYPE_INVALID;
    return OSSO_OK;
}

static void programTopMost (GObject *self, GParamSpec *spec, Application *app) {
    HildonProgram *program = HILDON_PROGRAM (self);
    (void)spec;
    app_set_suspend (app, !hildon_program_get_is_topmost (program));
}

#include <execinfo.h>
#include <signal.h>
#include <unistd.h>
static void sig_abort(int i) {
    void* trace[256];
    int n = backtrace(trace, 256);
    (void)i;
    if (!n)
        return;
    backtrace_symbols_fd (trace, n, 2);
    exit(0);
}

/* Callback for exit D-BUS event */
/*void exit_event_handler (gboolean die_now, gpointer data) {
//    Application * app = (Application *) data;
//    / * Do whatever application needs to do before exiting * /
//    / *application_exit (data);* /
//    g_print("exit_event_handler\n");
//    g_main_loop_quit (NULL);
//}
//
//void osso_application_top_cb (const gchar *arguments, void * app) {
//    gtk_infoprint (GTK_WINDOW (((Application *) app)->app), "KMPlayer");
//}*/

/* Main application */
int main (int argc, char* argv[]) {
    HildonProgram *program;
    HildonWindow *main_window;
    GtkScrolledWindow *scroll_window;
    PangoContext *pango_cxt;
    PangoFontDescription *pfd;
    Application *app;
    int i;

    gnome_vfs_init ();  /* calls g_thread_init(NULL);*/
    /* Create needed variables */
    signal(SIGABRT, sig_abort);
    signal(SIGINT, sig_abort);
    signal(SIGSEGV, sig_abort);
#ifdef KMPLAYER_DEBUG
    signal(SIGUSR1, sig_usr1);
#endif

    app = app_new ();

       /* Initialise the locale stuff */
    setlocale(LC_ALL, "");
    bindtextdomain(GETTEXT_PACKAGE, LOCALEDIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    textdomain(GETTEXT_PACKAGE);

    /* Initialize the GTK. */
    app->osso_context = osso_initialize ("com.nokia.kmplayer", "0.8", FALSE, NULL);
    if (!app->osso_context) {
        /*gtk_infoprint (GTK_WINDOW (app->window), "Failed to initialize");*/
        return 1;
    }
    gtk_init (&argc, &argv);

    /* Create the hildon application and setup the title */
#ifdef BUILD_BORA
    program = HILDON_PROGRAM (hildon_program_new());
#else
    program = HILDON_PROGRAM (hildon_program_get_instance());
#endif
    app->program = G_OBJECT (program);

    /*app->osso_context = osso_initialize ("kmplayer", "0.1", FALSE, NULL);
    if (!app->osso_context) {
        gtk_infoprint (GTK_WINDOW (app->app), "Failed to initialize");
        return 1;
    }*/
    /* Create HildonAppView and set it to HildonApp */
    main_window = HILDON_WINDOW (hildon_window_new ());
    app->window = GTK_WINDOW (main_window);

    /* Add example label to appview */
    app->hsplit_view = GTK_PANED (gtk_hpaned_new ());
    scroll_window = GTK_SCROLLED_WINDOW (gtk_scrolled_window_new (0L, 0l));
    gtk_scrolled_window_set_policy (scroll_window,
            GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    app->playlist_view = createTreeView (app);
    gtk_scrolled_window_add_with_viewport (scroll_window, app->playlist_view);
    app->vsplit_view = GTK_PANED (gtk_vpaned_new ());
    app->isplit_view = gtk_vbox_new (false, 0);
    gtk_paned_add1 (app->hsplit_view, GTK_WIDGET (scroll_window));
    gtk_paned_add2 (app->hsplit_view, GTK_WIDGET (app->vsplit_view));
    app->view_area = gtk_drawing_area_new ();
    _app_setup_window (app->view_area, app);
    g_signal_connect (app->program, "notify::is-topmost",
        GTK_SIGNAL_FUNC (programTopMost), app);
    g_signal_connect (G_OBJECT (main_window), "delete-event",
        GTK_SIGNAL_FUNC (cb_mainview_delete), app);
    g_signal_connect (G_OBJECT (main_window), "expose-event",
        GTK_SIGNAL_FUNC (cb_window_expose), app);
    g_signal_connect (G_OBJECT (main_window), "notify::is-topmost",
        GTK_SIGNAL_FUNC (windowTopMost), app);
    gtk_paned_add1 (app->vsplit_view, app->view_area);
    app->infopanel_view = gtk_text_view_new ();
    app->info_viewport = gtk_scrolled_window_new (0L, 0l);
    app->html_viewport = gtk_scrolled_window_new (0L, 0l);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (app->info_viewport),
            GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (app->html_viewport),
            GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    gtk_scrolled_window_add_with_viewport
        (GTK_SCROLLED_WINDOW (app->info_viewport), app->infopanel_view);
    g_object_set (G_OBJECT (app->infopanel_view),
            "cursor-visible", FALSE, "editable", FALSE,
            "wrap-mode", GTK_WRAP_WORD, 0L);
    pango_cxt = gtk_widget_get_pango_context (app->infopanel_view);
    pfd = pango_font_description_from_string ("Sans 12");
    gtk_widget_modify_font (app->infopanel_view, pfd);
    app->html_infopanel_view = gtk_html_new ();
    gtk_container_add (GTK_CONTAINER (app->html_viewport),
            app->html_infopanel_view);
    gtk_container_add (GTK_CONTAINER (app->isplit_view), app->info_viewport);
    gtk_container_add (GTK_CONTAINER (app->isplit_view), app->html_viewport);
    g_object_ref (app->info_viewport);
    g_object_ref (app->html_viewport);
    gtk_paned_add2 (app->vsplit_view, GTK_WIDGET (app->isplit_view));
    /*g_object_set (G_OBJECT (split_view->child1),
            "resize", TRUE, "shrink", TRUE, 0L);
    g_object_set (G_OBJECT (split_view->child2),
            "resize", TRUE, "shrink", TRUE, 0L);*/
    gtk_container_add (GTK_CONTAINER (main_window), GTK_WIDGET (app->hsplit_view));
    /* Create menu for view */
    create_menu (app);
    create_toolbar (app);
    hildon_program_add_window (program, main_window);

    g_signal_connect (G_OBJECT (gtk_bin_get_child (GTK_BIN(app->location_bar))),
            "focus-in-event", GTK_SIGNAL_FUNC (locationbarGainFocus), app);
    g_signal_connect (G_OBJECT (gtk_bin_get_child (GTK_BIN(app->location_bar))),
            "key-press-event", GTK_SIGNAL_FUNC (locationbarKeyEvent), app);
    g_signal_connect (G_OBJECT (app->playlist_view), "focus-in-event",
            GTK_SIGNAL_FUNC (locationbarLostFocus), app);
    g_signal_connect (G_OBJECT (app->infopanel_view), "focus-in-event",
            GTK_SIGNAL_FUNC (locationbarLostFocus), app);
    g_signal_connect (G_OBJECT (app->html_infopanel_view), "focus-in-event",
            GTK_SIGNAL_FUNC (locationbarLostFocus), app);
    g_signal_connect (G_OBJECT (main_window), "key-press-event",
            GTK_SIGNAL_FUNC (cb_keyPressed), (void *)app);
    /* Begin the main application */
    gtk_paned_set_position (app->hsplit_view, HSPLIT);
    gtk_paned_set_position (app->vsplit_view, VSPLIT);
    gtk_widget_show_all (GTK_WIDGET (main_window));

    osso_mime_set_cb (app->osso_context, cb_openUrls, app);
    if (osso_rpc_set_cb_f (app->osso_context,
                "com.nokia.kmplayer",
                "/com/nokia/kmplayer",
                "com.nokia.kmplayer",
                dbus_req_handler, app) !=
            OSSO_OK) {
        hildon_banner_show_information (GTK_WIDGET (app->window),
                NULL, "Failed to set dbus_req_handler");
    }
    app_init_control (app);
    g_object_ref (G_OBJECT (app->location_bar));

    if (argc > 1) {
        OpenLocation *ol = (OpenLocation *)malloc (sizeof (OpenLocation));
        ol->filename = g_strdup (argv[1]);
        ol->app = app;
        g_idle_add (delayed_open_location, (gpointer)ol);
    }
    gtk_main ();
    save_locationbar (app);
    g_object_unref (G_OBJECT (app->location_bar));

    osso_mime_unset_cb (app->osso_context);
    osso_deinitialize (app->osso_context);
    app_destroy (app);
    gnome_vfs_shutdown ();

    /* Exit */
    return 0;
}
