#!/bin/sh
set -f

DEST=com.nokia.gstmjpg
OBJPATH=/com/nokia/gstmjpg

# get the DBus session bus address
source /tmp/session_bus_address.user

message () {
    echo Content-type: text/plain
    echo
    echo $1
}

if [ "$QUERY_STRING" == "start" ]; then
    echo Content-type: text/plain
    echo
    dbus-send --session --print-reply --dest="$DEST" "$OBJPATH" "$DEST".start
    if [ "$?" -ne 0 ]; then
        echo "Could not start mjpg server."
        echo "Check the syslog to see what is the problem."
        exit 1
    fi
    echo
    echo "mjpg server started." 
    exit 0
fi

if [ "$QUERY_STRING" == "start_with_motion_detection" ]; then
    echo Content-type: text/plain
    echo
    dbus-send --session --print-reply --dest="$DEST" "$OBJPATH" "$DEST".start_with_motion_detection
    if [ "$?" -ne 0 ]; then
        echo "Could not start mjpg server (with motion detection)."
        echo "Check the syslog to see what is the problem."
        exit 1
    fi
    echo
    echo "mjpg server started (with motion detection)." 
    exit 0
fi

if [ "$QUERY_STRING" == "stop" ]; then
    echo Content-type: text/plain
    echo
    dbus-send --session --print-reply --dest="$DEST" "$OBJPATH" "$DEST".stop
    if [ "$?" -ne 0 ]; then
        echo "Could not stop mjpg server."
        exit 1
    fi
    echo
    echo "mjpg server stopped."
    exit 0
fi

message "Unknown action. Must be 'start' or 'stop' or 'start_with_motion_detection'" 
exit 1

