/*
   Reads motion JPEG data from a file and writes it to stdout
   Copyright (C) 2008  Seppo Yliklaavu <seppo.yliklaavu@gmail.com>

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
   */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>
#include <time.h>
#include <getopt.h>

/* max JPEG length */
#define BUFFER_LENGTH 40000

static char garbage1[80] = "";
static char garbage2[30] = "";
static char buffer[BUFFER_LENGTH] = "";

static char *file_name = NULL;
static unsigned int fps = 10;

static const char header[] =
"Pragma: no-cache\r\n"
"Cache-Control: no-store, no-cache\r\n"
"Connection: close\r\n"
"Content-Type: multipart/x-mixed-replace; boundary=--MyBoundary\r\n";

int main(int argc, char *argv[])
{

    FILE *file = NULL;
    int jpglength ;
    unsigned int interval_usec;
    unsigned int elapsed_usec;
    struct timeval time1[1];
    struct timeval time2[1];
    int c;
    int option_index = 0;
    static struct option long_options[] =
    {
        {"fps",  required_argument, 0, 'f'},
        {"in",   required_argument, 0, 'i'},
        {0, 0, 0, 0}
    };

    while ((c = getopt_long(argc,
                            argv,
                            "f:i:",
                            long_options,
                            &option_index)) != -1)
    {
        switch (c)
        {
            case 'f':
                fps = atoi(optarg); 
                break;
            case 'i':
                file_name = optarg; 
                break;
            case '?':
                break;
            default:
                abort();
        }
    }


    if (fps < 1 || fps > 15)
    {
        fprintf(stderr, "Error, give reasonable integer fps value (1...15)\n");
        exit(EXIT_FAILURE);
    }
    if (file_name == NULL)
    {
        fprintf(stderr, "Error, no input file name given\n");
        exit(EXIT_FAILURE);
    }
    file = fopen(file_name, "r");
    if (file == NULL)
    {
        fprintf(stderr, "Could not open file: %s\n", file_name);
        exit(EXIT_FAILURE);
    }

    /* set the sleep interval to 1/fps */
    interval_usec = 1000000 / fps;

    printf("%s", header);

    while(!feof(file))
    {
        gettimeofday(time1, NULL);
        while(strncmp(garbage1,"Content-Length:",15)!=0)
        {
            fgets(garbage1, 70, file);
            if (feof(file))
            {
                fclose(file);
                return (0);
            }
        }
        if (jpglength > BUFFER_LENGTH)
        {
            fprintf(stderr, "Too big jpeg pictures: %d bytes\n", jpglength);
            fclose(file);
            exit(EXIT_FAILURE);
        }

        sscanf(garbage1, "%s%d", garbage2, &jpglength);

        printf("\r\n--MyBoundary\r\n"
               "Content-Type: image/jpeg\r\n"
               "Content-Length: %d\r\n"
               "\r\n", jpglength);

        fgets(garbage1, 70, file);

        fread(buffer, 1, jpglength, file);

        gettimeofday(time2, NULL);
        elapsed_usec = 1000000 * (time2->tv_sec - time1->tv_sec);
        elapsed_usec += time2->tv_usec - time1->tv_usec;
        if (interval_usec > elapsed_usec)
        {
            /*fprintf(stderr, "%u\n", interval_usec - elapsed_usec);*/
            usleep(interval_usec - elapsed_usec);
        }

        fwrite(buffer, 1, jpglength, stdout);
        fflush(stdout);
    }

    fclose(file);

    return (0);

}
