#!/bin/sh
set -f

DEST=com.nokia.gstmjpg
OBJPATH=/com/nokia/gstmjpg

ACTION_START=start
ACTION_START_WITH_MOTION_DETECTION=start_with_motion_detection
ACTION_STOP=stop

message () {
    echo Content-type: text/plain
    echo
    echo $1
}

dbus_send () {
    dbus-send --session --print-reply --dest="$DEST" "$OBJPATH" "$DEST"."$1"
    return $?
}

# get the DBus session bus address
source /tmp/session_bus_address.user
if [ "$?" -ne 0 ]; then
    message "Could not get session bus address. Aborting."
    exit 1
fi

if [ "$QUERY_STRING" = "$ACTION_START" ]; then
    dbus_send "$ACTION_START"
    if [ "$?" -ne 0 ]; then
        message "Could not start mjpg server. Check the syslog to see what is the problem."
        exit 1
    fi
    message "mjpg server started." 

elif [ "$QUERY_STRING" = "$ACTION_START_WITH_MOTION_DETECTION" ]; then
    dbus_send "$ACTION_START_WITH_MOTION_DETECTION"
    if [ "$?" -ne 0 ]; then
        message "Could not start mjpg server (with motion detection). Check the syslog to see what is the problem."
        exit 1
    fi
    message "mjpg server started (with motion detection)." 

elif [ "$QUERY_STRING" = "$ACTION_STOP" ]; then
    dbus_send "$ACTION_STOP"
    if [ "$?" -ne 0 ]; then
        message "Could not stop mjpg server."
        exit 1
    fi
    message "mjpg server stopped."
else
    message "Unknown action: $QUERY_STRING. Aborting."
    exit 1
fi

#all ok
exit 0

