/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "interface.h"
#include "support.h"

#ifdef MAEMO2
	#include "hildon/hildon-program.h"
	#include "hildon/hildon-window.h"
	#include "libosso.h"
	#include "callbacks.h"
#endif

gchar *argv_session;
gboolean cmdline_session, cmdline_execute;
#ifdef MAEMO2
HildonProgram *program = NULL;
HildonWindow *main_window = NULL;
osso_context_t *osso_context = NULL;
#else
GtkWidget *main_window;
#endif

int main (int argc, char *argv[]) {

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  gtk_set_locale ();
  gtk_init (&argc, &argv);

//  add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps");
  add_pixmap_directory (PACKAGE_DATA_DIR "/pixmaps");

	gint i = 1;
	while (i < argc && argv[i] != NULL) {
		if (argv[i][0] == '-') {
			if (argv[i][1] == 'e') cmdline_execute = TRUE;
		} else {
			argv_session = g_strconcat(argv[i], NULL);
			cmdline_session = TRUE;
		}
		i++;
	}
	if (!cmdline_session) argv_session = g_strconcat("default", NULL);

  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
#ifdef MAEMO2
  program = HILDON_PROGRAM(hildon_program_get_instance());
  osso_context = osso_initialize("it.opbyte." PACKAGE, VERSION, FALSE, NULL);
  g_assert(osso_context);
  main_window = HILDON_WINDOW(create_main ());
  hildon_program_add_window(program, main_window);
  g_set_application_name(_("Grsync"));
  gtk_widget_show_all (GTK_WIDGET(main_window));
  g_signal_connect(G_OBJECT(main_window), "delete_event",
  		 G_CALLBACK(gtk_main_quit), NULL);
  g_signal_connect(G_OBJECT(main_window), "key_press_event",
    		 G_CALLBACK(hardware_key_press_cb), NULL);
#else
  main_window = create_main ();
  gtk_widget_show (main_window);
#endif

  gtk_main();
#ifdef MAEMO2
  osso_deinitialize(osso_context);
#endif
  g_free(argv_session);
  return 0;
}

