#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gconf/gconf-client.h>
#include "interface.h"
#include "support.h"
#include "main.h"
#include "callbacks.h"

#include <libosso.h>

#include <libintl.h>
#include <locale.h>
#define _(String) gettext(String)

void
rcm_clear_connections_window (UIComponents *uic)
{
	gtk_entry_set_text (GTK_ENTRY (uic->ConnectionNameEntry), "");

	gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (uic->ConnectionTypeCombo)->entry), "");

	gtk_entry_set_text (GTK_ENTRY (uic->ConnectionHostnameEntry), "");

	gtk_entry_set_text (GTK_ENTRY (uic->ConnectionUsernameEntry), "");

	gtk_entry_set_text (GTK_ENTRY (uic->ConnectionArgumentsEntry), "");
}

void
rcm_update_connections_window_list (UIComponents *uic)
{
	gint i = 0;
	Connection *connection = NULL;
	GtkTreeIter iter;
	GtkListStore *store = NULL;
	GtkWidget *list;
	GtkWidget *combo;
	ConnectionType *type;
	GList *items = NULL;
	gint len = g_slist_length (ConnectionsSList);
	gchar *tmp;

	list = uic->ConnectionsList;
	g_return_if_fail (list != NULL);
	store = GTK_LIST_STORE (gtk_tree_view_get_model
				(GTK_TREE_VIEW (list)));
	g_return_if_fail (store != NULL);
	gtk_list_store_clear (GTK_LIST_STORE (store));

	for (i = 0; i < len; i++)
	{
		connection = g_slist_nth_data (ConnectionsSList, i);
		type = g_slist_nth_data (ConnectionTypesSList,
					 connection->Type);
		gtk_list_store_append (store, &iter);
		gtk_list_store_set (store, &iter,
				    CONNECTION_NAME_COLUMN, connection->Name,
				    CONNECTION_HOSTNAME_COLUMN,
				    connection->Hostname,
				    CONNECTION_TYPE_COLUMN, type, -1);
	}
	len = g_slist_length (ConnectionTypesSList);
	for (i = 0; i < len; i++)
	{
		type = g_slist_nth_data (ConnectionTypesSList, i);
		items = g_list_append (items, g_strdup (type->Name));
	}
	combo = uic->ConnectionTypeCombo;
	g_return_if_fail (combo != NULL);
	if (g_list_length (items) > 0)
		gtk_combo_set_popdown_strings (GTK_COMBO (combo), items);
	for (i = 0; i < len; i++)
	{
		tmp = g_list_nth_data (items, i);
		g_free (tmp);
	}
	g_list_free (items);
}

gboolean
rcm_save_connection (const Connection connection, UIComponents *uic)
{
	Connection *newconnection = NULL;
	ConnectionsSListIsDirty = TRUE;
	if ((newconnection =
	     rcm_find_connection_by_name_in_list (connection.Name,
						  ConnectionsSList)) != NULL)
	{
		memcpy (newconnection, &connection,
			sizeof (struct Connection));
	}
	else
	{
		newconnection =
			(Connection *) malloc (sizeof (struct Connection));
		g_return_val_if_fail (newconnection != NULL, FALSE);
		memcpy (newconnection, &connection,
			sizeof (struct Connection));
		ConnectionsSList =
			g_slist_append (ConnectionsSList, newconnection);
	}
	if (SortOption == SORT_ASCENDING)
		rcm_ascending_sort (uic);
	else if (SortOption == SORT_DESCENDING)
		rcm_descending_sort (uic);
	else if (SortOption == SORT_TYPE)
		rcm_type_sort (uic);
	ConnectionsSListIsDirty = TRUE;
	return TRUE;
}

Connection *
rcm_remove_connection_from_list_by_name (const gchar * name, GSList * list)
{
	gint i = 0;
	Connection *connection = NULL;
	gint len = g_slist_length (list);

	for (i = 0; i < len; i++)
	{
		connection = g_slist_nth_data (list, i);
		if (strncmp (name, connection->Name, NAMELEN) == 0)
		{
			ConnectionsSList =
				g_slist_remove (ConnectionsSList, connection);
			return connection;
		}
	}
	return NULL;
}

Connection *
rcm_find_connection_by_name_in_list (const gchar * name, GSList * list)
{
	gint i = 0;
	Connection *connection = NULL;
	gint len = g_slist_length (list);

	for (i = 0; i < len; i++)
	{
		connection = g_slist_nth_data (list, i);
		if (strncmp (name, connection->Name, NAMELEN) == 0)
			return connection;
	}
	return NULL;
}

gboolean
rcm_save_connections_to_disk ()
{
	GConfClient *gconf_client = NULL;
	gint i, len;
	Connection *connection;
	gchar key[MAX_BUFFER_LENGTH];

	rcm_remove_all_connections_from_disk ();
	len = g_slist_length (ConnectionsSList);
	if (len == 0)
		return TRUE;
	gconf_client = gconf_client_get_default ();

	for (i = 0; i < len; i++)
	{
		connection = g_slist_nth_data (ConnectionsSList, i);
		snprintf (key, MAX_BUFFER_LENGTH, "%s/%d/Name",
			  GCONF_CONNECTIONS_DIR, i);
		gconf_client_set_string (gconf_client, key, connection->Name,
					 NULL);

		snprintf (key, MAX_BUFFER_LENGTH, "%s/%d/Type",
			  GCONF_CONNECTIONS_DIR, i);
		gconf_client_set_int (gconf_client, key, connection->Type,
				      NULL);

		snprintf (key, MAX_BUFFER_LENGTH, "%s/%d/Hostname",
			  GCONF_CONNECTIONS_DIR, i);
		gconf_client_set_string (gconf_client, key,
					 connection->Hostname, NULL);

		snprintf (key, MAX_BUFFER_LENGTH, "%s/%d/Username",
			  GCONF_CONNECTIONS_DIR, i);
		gconf_client_set_string (gconf_client, key,
					 connection->Username, NULL);

		snprintf (key, MAX_BUFFER_LENGTH, "%s/%d/Arguments",
			  GCONF_CONNECTIONS_DIR, i);
		gconf_client_set_string (gconf_client, key,
					 connection->Arguments, NULL);
	}

	ConnectionsSListIsDirty = FALSE;
	gconf_client_suggest_sync (gconf_client, NULL);
	g_object_unref (gconf_client);
	return TRUE;
}

gboolean
rcm_load_connections_from_disk ()
{
	GConfClient *gconf_client = NULL;
	gint i = 0;
	gchar key[MAX_BUFFER_LENGTH];
	gchar *tmp;
	Connection *connection;

	gconf_client = gconf_client_get_default ();
	g_slist_free (ConnectionsSList);
	ConnectionsSList = NULL;

	if (!gconf_client_dir_exists
	    (gconf_client, GCONF_CONNECTIONS_DIR, NULL))
	{
		g_object_unref (gconf_client);
		ConnectionsSListIsDirty = FALSE;
		return TRUE;
	}
	if (rcm_gconf_client_all_connections_dirs (NULL) == 0)
	{
		g_object_unref (gconf_client);
		ConnectionsSListIsDirty = FALSE;
		return TRUE;
	}

	do
	{
		snprintf (key, MAX_BUFFER_LENGTH, "%s/%d",
			  GCONF_CONNECTIONS_DIR, i);
		if (!gconf_client_dir_exists (gconf_client, key, NULL))
		{
			g_object_unref (gconf_client);
			ConnectionsSListIsDirty = FALSE;
			return TRUE;
		}
		connection = (Connection *)
			malloc (sizeof (struct Connection));
		if (!connection)
		{
			g_object_unref (gconf_client);
			ConnectionsSListIsDirty = TRUE;
			return FALSE;
		}
		memset (connection, 0, sizeof (struct Connection));

		snprintf (key, MAX_BUFFER_LENGTH, "%s/%d/Name",
			  GCONF_CONNECTIONS_DIR, i);
		tmp = gconf_client_get_string (gconf_client, key, NULL);
		if (!tmp)
		{
			/*
			rcm_error (_
			         ("There was an error loading your connections, some or all may not be available."),
			         MainWindow);
			*/
			free (connection);
			g_object_unref (gconf_client);
			ConnectionsSListIsDirty = FALSE;
			return TRUE;
		}
		strncat (connection->Name, tmp, MAX_BUFFER_LENGTH);
		tmp = NULL;

		snprintf (key, MAX_BUFFER_LENGTH, "%s/%d/Type",
			  GCONF_CONNECTIONS_DIR, i);
		connection->Type =
			gconf_client_get_int (gconf_client, key, NULL);

		snprintf (key, MAX_BUFFER_LENGTH, "%s/%d/Hostname",
			  GCONF_CONNECTIONS_DIR, i);
		tmp = gconf_client_get_string (gconf_client, key, NULL);
		if (!tmp)
		{
			rcm_error (_
				   ("There was an error loading your connections, some or all may not be available."),
				   MainWindow);
			free (connection);
			g_object_unref (gconf_client);
			ConnectionsSListIsDirty = FALSE;
			return FALSE;
		}
		strncat (connection->Hostname, tmp, MAX_BUFFER_LENGTH);
		tmp = NULL;

		snprintf (key, MAX_BUFFER_LENGTH, "%s/%d/Username",
			  GCONF_CONNECTIONS_DIR, i);
		tmp = gconf_client_get_string (gconf_client, key, NULL);
		if (!tmp)
		{
			rcm_error (_
				   ("There was an error loading your connections, some or all may not be available."),
				   MainWindow);
			free (connection);
			g_object_unref (gconf_client);
			ConnectionsSListIsDirty = FALSE;
			return FALSE;
		}
		strncat (connection->Username, tmp, MAX_BUFFER_LENGTH);
		tmp = NULL;

		snprintf (key, MAX_BUFFER_LENGTH, "%s/%d/Arguments",
			  GCONF_CONNECTIONS_DIR, i);
		tmp = gconf_client_get_string (gconf_client, key, NULL);
		if (!tmp)
		{
			rcm_error (_
				   ("There was an error loading your connections, some or all may not be available."),
				   MainWindow);
			free (connection);
			g_object_unref (gconf_client);
			ConnectionsSListIsDirty = FALSE;
			return FALSE;
		}
		strncat (connection->Arguments, tmp, MAX_BUFFER_LENGTH);
		tmp = NULL;

		ConnectionsSList =
			g_slist_append (ConnectionsSList, connection);
		i++;
	}
	while (TRUE);
	g_object_unref (gconf_client);
	ConnectionsSListIsDirty = FALSE;
	return TRUE;
}

void
rcm_remove_all_connections_from_disk (void)
{
	GConfClient *gconf_client = NULL;
	gint i, len;
	gchar key[MAX_BUFFER_LENGTH];
	gboolean ret;

	gconf_client = gconf_client_get_default ();

	len = rcm_gconf_client_all_connections_dirs (NULL);

	for (i = 0; i < len; i++)
	{
		snprintf (key, MAX_BUFFER_LENGTH, "%s/%d/Name",
			  GCONF_CONNECTIONS_DIR, i);
		ret = gconf_client_unset (gconf_client, key, NULL);
		snprintf (key, MAX_BUFFER_LENGTH, "%s/%d/Type",
			  GCONF_CONNECTIONS_DIR, i);
		ret = gconf_client_unset (gconf_client, key, NULL);

		snprintf (key, MAX_BUFFER_LENGTH, "%s/%d/Hostname",
			  GCONF_CONNECTIONS_DIR, i);
		ret = gconf_client_unset (gconf_client, key, NULL);
	}

	ConnectionsSListIsDirty = FALSE;
	gconf_client_suggest_sync (gconf_client, NULL);
	g_object_unref (gconf_client);
	return;
}

gint
rcm_gconf_client_all_connections_dirs (GError ** err)
{
	GConfClient *gconf_client;
	gint i = 0;
	gchar key[MAX_BUFFER_LENGTH];

	gconf_client = gconf_client_get_default ();
	snprintf (key, MAX_BUFFER_LENGTH, "%s/0", GCONF_CONNECTIONS_DIR);
	for (i = 0; i < INT_MAX; i++)
	{
		snprintf (key, MAX_BUFFER_LENGTH, "%s/%d",
			  GCONF_CONNECTIONS_DIR, i);
		if (!gconf_client_dir_exists (gconf_client, key, err))
			break;
	}
	g_object_unref (gconf_client);
	return i;
}

gint rcm_get_index_by_connection(Connection *connection) {
	gint index = 0;
	GSList *entry;
	
	for (entry = ConnectionsSList; entry; entry=g_slist_next(entry)) {
		if (connection == (Connection *) (entry->data)) {
			break;
		}
		index++;
	}
	if (entry) {
		return index;
	} else {
		return -1;
	}
}

void
rcm_select_connection_by_index (Connection *connection, UIComponents *uic)
{
	GtkTreeIter iter;
	GtkListStore *store = NULL;
	GtkWidget *list;
	GtkTreeSelection *select;
	gchar path[10];
	gint num;

	list = uic->ConnectionsList;
	g_return_if_fail (list != NULL);
	
	num = rcm_get_index_by_connection(connection);
	g_return_if_fail (num > -1);

	store = GTK_LIST_STORE (gtk_tree_view_get_model
				(GTK_TREE_VIEW (list)));
	g_return_if_fail (store != NULL);

	snprintf (path, 10, "%d", num);
	gtk_tree_model_get_iter_from_string (GTK_TREE_MODEL (store), &iter,
					     path);
	select = gtk_tree_view_get_selection (GTK_TREE_VIEW (list));
	g_return_if_fail (select != NULL);
	gtk_tree_selection_select_iter (select, &iter);
	return;
}

void
rcm_select_connection_by_name (gchar * name, UIComponents *uic)
{
	GtkTreeIter iter;
	GtkListStore *store = NULL;
	GtkWidget *list;
	const gchar *name1;
	GtkTreeSelection *select;
	gchar path[10];
	gint i = 0;

	list = uic->ConnectionsList;
	g_return_if_fail (list != NULL);

	store = GTK_LIST_STORE (gtk_tree_view_get_model
				(GTK_TREE_VIEW (list)));
	g_return_if_fail (store != NULL);

	snprintf (path, 10, "%d", i);
	while (gtk_tree_model_get_iter_from_string
	       (GTK_TREE_MODEL (store), &iter, path))
	{
		gtk_tree_model_get (GTK_TREE_MODEL (store), &iter,
				    CONNECTION_TYPE_NAME_COLUMN, &name1, -1);
		if (strcmp (name, name1) == 0)
		{
			select = gtk_tree_view_get_selection (GTK_TREE_VIEW
							      (list));
			g_return_if_fail (select != NULL);
			gtk_tree_selection_select_iter (select, &iter);
			return;
		}
		i++;
		snprintf (path, 10, "%d", i);
	}
}

gboolean
rcm_launch_connection_by_name (gchar * name)
{
	gchar buff[MAX_BUFFER_LENGTH];
	gchar cmd[MAX_BUFFER_LENGTH];
	gchar msg[MAX_BUFFER_LENGTH];
	Connection *connection;
	ConnectionType *type;
	GError *error=NULL;
	gchar * tmpFileName=NULL;
	gchar *temp;

	connection =
		rcm_find_connection_by_name_in_list (name, ConnectionsSList);
	g_return_if_fail (connection != NULL);

	type = g_slist_nth_data (ConnectionTypesSList, connection->Type);
	g_return_if_fail (type != NULL);

/*
	if (type->Terminal)
	{
		if(strnlen(TerminalProgram,1024) == 0)
		{
			rcm_warn(_("You haven't set the terminal program.\nOpen the Preferences dialog and set the terminal program to use."),NULL);
			return FALSE;
		}
		memset (buff, 0, MAX_BUFFER_LENGTH);

		strncat (buff, TerminalProgram, MAX_BUFFER_LENGTH);
		strncat (buff, " ", MAX_BUFFER_LENGTH);
		strncat (buff, TerminalProgramOptions, MAX_BUFFER_LENGTH);
		strncat (buff, " ", MAX_BUFFER_LENGTH);
		tmpFileName = g_strconcat(g_get_tmp_dir (), "/", PACKAGE, ".tmp", NULL);
		strncat (buff, "\"/bin/sh ", MAX_BUFFER_LENGTH);
		strncat (buff, tmpFileName, MAX_BUFFER_LENGTH);
		strncat (buff, "\"", MAX_BUFFER_LENGTH);
	}
*/		

	memset (cmd, 0, MAX_BUFFER_LENGTH);

	strncat (cmd, type->Command, MAX_BUFFER_LENGTH);
	strncat (cmd, " ", MAX_BUFFER_LENGTH);

	strncat (cmd, connection->Arguments, MAX_BUFFER_LENGTH);
	strncat (cmd, " ", MAX_BUFFER_LENGTH);

	rcm_translate_arg (cmd, connection->Hostname, "%h",
			   MAX_BUFFER_LENGTH);
	rcm_translate_arg (cmd, connection->Username, "%u",
			   MAX_BUFFER_LENGTH);

	if (type->Terminal) {
/*
		temp = g_strconcat("#!/bin/sh\n", cmd, "\nread -p \"Press ENTER to continue ...\" foo", NULL);
		if (!g_file_set_contents(tmpFileName, temp, -1, &error)) {
			snprintf (msg, MAX_BUFFER_LENGTH, "%s%s\n%s",
			  _("There was a problem writing to the temp file:\n"),
			  temp, error->message);
			rcm_error (msg, MainWindow);
			return FALSE;
		}
		g_free(temp);
*/
		DBusConnection *session_bus = dbus_bus_get(DBUS_BUS_SESSION, NULL);
		if (!session_bus) {
			return FALSE;
		}
		DBusMessage *dbusmsg = dbus_message_new_method_call("com.nokia.xterm",
		"/com/nokia/xterm",
		"com.nokia.xterm",
		"run_command");
		if (!dbusmsg) {
			g_debug ("exit failure");
			return FALSE;
		}
		if (cmd) {
			gchar * cmd2 = g_strdup(cmd);
			dbus_message_append_args(dbusmsg,
			DBUS_TYPE_STRING, &cmd2,
			DBUS_TYPE_INVALID);
		}
		dbus_message_set_no_reply(dbusmsg, TRUE);
		dbus_connection_send(session_bus, dbusmsg, NULL);
		dbus_connection_flush(session_bus);
	} else {
		strncpy(cmd, buff, MAX_BUFFER_LENGTH);
		if (!g_spawn_command_line_async(cmd, &error)) {
			snprintf (msg, MAX_BUFFER_LENGTH, "%s%s\n%s",
				  _("There was a problem launching the connection. I suggest you try and run it from the command line:\n"),
				  cmd, error->message);
			rcm_error (msg, MainWindow);
		}
	}


/*	
	if (tmpFileName) {
		g_free(tmpFileName);
	}
*/
	return TRUE;
}
