#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>
#include <gtk/gtk.h>
#include <gconf/gconf-client.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "main.h"

#include <libintl.h>
#include <locale.h>
#define _(String) gettext(String)


void setIcon(GtkButton *button, gchar *icon) {
	GtkImage *image;
	if (icon) {
		image = gtk_image_new_from_file(icon);
	} else {
		image = gtk_image_new_from_stock(GTK_STOCK_FILE, GTK_ICON_SIZE_BUTTON);
	}
	gtk_button_set_image(button, image);
}

void
on_file_new_type_menu_activate (GtkMenuItem * menuitem, UIComponents *uic)
{
	rcm_show_ConnectionTypesWindow(uic);
}


void
on_edit_delete_menu_activate (GtkMenuItem * menuitem, UIComponents *uic)
{
	GList *l;
	Connection *connection = NULL;
	GtkWidget *yes_no_dialog;
	int ret;
	gchar buff[MAX_BUFFER_LENGTH];
	GtkTreePath *path = NULL;
	GtkTreeModel *model;
	GtkTreeIter iter;

	g_return_if_fail (uic->MainList != NULL);
	l = gtk_icon_view_get_selected_items (GTK_ICON_VIEW (uic->MainList));

	if (l)
	{
		path = (GtkTreePath *) (l->data);
		model = gtk_icon_view_get_model(GTK_ICON_VIEW (uic->MainList));
		if (gtk_tree_model_get_iter(model, &iter, path)) {
			gtk_tree_model_get(model, &iter, CONNECTION_COLUMN, connection, -1);
			g_return_if_fail (connection != NULL);
			snprintf (buff, MAX_BUFFER_LENGTH,
				  _("Are you sure you want to delete %s?"),
				  connection->Name);
			yes_no_dialog =
				gtk_message_dialog_new  (GTK_WINDOW(uic->MainWindow), GTK_DIALOG_MODAL,
						   GTK_MESSAGE_QUESTION,
						   GTK_BUTTONS_YES_NO,
						   buff);
			ret = gtk_dialog_run (GTK_DIALOG (yes_no_dialog));
			gtk_widget_destroy (yes_no_dialog);

			if (ret != GTK_RESPONSE_YES)
				return;
			connection =
				rcm_remove_connection_from_list_by_name (connection->
									 Name,
									 ConnectionsSList);
			if (connection)
				free (connection);
			rcm_update_main_window (uic);	/* causing assertion */
			rcm_save_connections_to_disk ();
			}
	}
}

void
on_help_help_menu_activate (GtkMenuItem * menuitem, UIComponents *uic)
{
	GtkWidget *dialog = create_AboutWindow ();
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
}


void
on_about_activate (GtkMenuItem * menuitem, UIComponents *uic)
{
	GtkWidget *AboutWindow = create_AboutWindow ();
	gtk_dialog_run (GTK_DIALOG (AboutWindow));
	gtk_widget_destroy (AboutWindow);
}


void
on_TbTypesBtn_clicked (GtkButton * button, UIComponents *uic)
{
	rcm_show_ConnectionTypesWindow(uic);
}


void
on_TbConnectionBtn_clicked (GtkButton * button, UIComponents *uic)
{
	rcm_show_ConnectionsWindow(uic);
}


gboolean
on_ConnectionsWindow_delete_event (GtkWidget * widget,
				   GdkEvent * event, UIComponents *uic)
{
	GtkWidget *yes_no_dialog;
	gint ret;

	if (ConnectionsSListIsDirty)
	{
		yes_no_dialog = gtk_message_dialog_new  (GTK_WINDOW(uic->MainWindow), GTK_DIALOG_MODAL,
						   GTK_MESSAGE_QUESTION,
						   GTK_BUTTONS_YES_NO,
						   _("Do you want to save your changes?"));
		ret = gtk_dialog_run (GTK_DIALOG (yes_no_dialog));
		gtk_widget_destroy (yes_no_dialog);
		if (ret == GTK_RESPONSE_YES)
		{
			if (!rcm_save_connections_to_disk ())
				rcm_error
					(_("There was a problem saving."),
					 ConnectionsWindow);
			gtk_widget_hide (ConnectionsWindow);
			return FALSE;
		}
		else
		{
			if (!rcm_load_connections_from_disk ())
				rcm_error
					(_("A serious error has occured."),
					 ConnectionsWindow);
			rcm_update_connections_window_list (uic);
			gtk_widget_hide (GTK_WIDGET (ConnectionsWindow));
			return FALSE;
		}
	}
	rcm_update_main_window (uic);
	gtk_widget_hide (GTK_WIDGET (ConnectionsWindow));
	return TRUE;
}

gboolean
on_ConnectionTypesWindow_delete_event (GtkWidget * widget,
				       GdkEvent * event, UIComponents *uic)
{
	GtkWidget *yes_no_dialog;
	gint ret;

	if (ConnectionTypesSListIsDirty)
	{
		yes_no_dialog = gtk_message_dialog_new  (GTK_WINDOW(uic->MainWindow), GTK_DIALOG_MODAL,
						   GTK_MESSAGE_QUESTION,
						   GTK_BUTTONS_YES_NO,
						   _("Do you want to save your changes?"));
		ret = gtk_dialog_run (GTK_DIALOG (yes_no_dialog));
		gtk_widget_destroy (yes_no_dialog);
		if (ret == GTK_RESPONSE_YES)
		{
			if (!rcm_save_types_to_disk ())
				rcm_error
					(_("There was a problem saving."),
					 ConnectionTypesWindow);
			gtk_widget_hide (ConnectionTypesWindow);
			return FALSE;
		}
		else
		{
			if (!rcm_load_types_from_disk ())
				rcm_error
					(_("A serious error has occured."),
					 ConnectionTypesWindow);
			rcm_update_connectiontypes_window_list (uic);
			gtk_widget_hide (ConnectionTypesWindow);
			return FALSE;
		}
	}
	rcm_update_main_window (uic);
	gtk_widget_hide (GTK_WIDGET (ConnectionTypesWindow));
	return TRUE;
}

void
on_ConnectionTypesClearBtn_clicked (GtkButton * button, UIComponents *uic)
{
	rcm_clear_types_window (uic);
}


void
on_ConnectionTypesSaveBtn_clicked (GtkButton * button, UIComponents *uic)
{
	GtkWidget *widget = NULL;
	gchar *name = NULL;
	gchar *command = NULL;
	gchar* arguments = NULL;
	gchar *icon = NULL;
	ConnectionType type;

	widget = uic->ConnectionTypesNameEntry;
	g_return_if_fail (widget != NULL);
	name = gtk_editable_get_chars (GTK_EDITABLE (widget), 0, -1);
	if (strnlen (name,NAMELEN) == 0)
	{
		g_free (name);
		rcm_warn (_("Connection Type name is not set."),
			  ConnectionTypesWindow);
		return;
	}
	strncpy (type.Name, name, NAMELEN);
	/* need this below g_free (name); */

	widget = uic->ConnectionTypesCommandEntry;
	g_return_if_fail (widget != NULL);
	command = gtk_editable_get_chars (GTK_EDITABLE (widget), 0, -1);
	if (strnlen (command,COMMANDLEN) == 0)
	{
		g_free (command);
		rcm_warn (_("Conenction Type command is not set."),
			  ConnectionTypesWindow);
		return;
	}
	strncpy (type.Command, command, COMMANDLEN);
	g_free (command);

	widget = uic->ConnectionTypesArgumentsEntry;
	g_return_if_fail (widget != NULL);
	arguments = gtk_editable_get_chars (GTK_EDITABLE (widget), 0, -1);
	if (strnlen (arguments,ARGUMENTSLEN) == 0)
		strncpy (type.Arguments, "", ARGUMENTSLEN);	
	else
		strncpy (type.Arguments, arguments, ARGUMENTSLEN);
	g_free (arguments);
	
	widget = uic->ConnectionTypesTerminalChkBox;
	g_return_if_fail (widget != NULL);
	type.Terminal =
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget));

	widget = uic->fileChooserDialog;
	g_return_if_fail (widget != NULL);
	icon =  gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (widget));
	if (icon == NULL)
	{
		type.Icon[0] = '\0';
	}
	else
	{
		strncpy (type.Icon, icon, ICONLEN);
		g_free (icon);
	}

	rcm_save_type (type);
	rcm_update_connectiontypes_window_list (uic);
	rcm_select_type_by_name (name, uic);
	rcm_clear_types_window (uic);
	rcm_update_main_window(uic);
	g_free (name);
}


void
on_ConnectionTypesOkBtn_clicked (GtkButton * button, UIComponents *uic)
{
	if (!rcm_save_types_to_disk ())
		rcm_error (_("There was a problem saving."),
			   ConnectionTypesWindow);
	rcm_update_main_window (uic);
	gtk_widget_hide (ConnectionTypesWindow);
}


void
on_ConnectionTypesCancelBtn_clicked (GtkButton * button, UIComponents *uic)
{
	if (!rcm_load_types_from_disk ())
		rcm_error (_("A serious error has occured."),
			   ConnectionTypesWindow);
	rcm_update_main_window (uic);
	gtk_widget_hide (ConnectionTypesWindow);
}


void
on_ConnectionTypesDeleteBtn_clicked (GtkButton * button, UIComponents *uic)
{
	GtkTreeIter iter;
	GtkTreeModel *model;
	GtkTreeSelection *select;
	gchar *name;

	select = gtk_tree_view_get_selection (GTK_TREE_VIEW
					      (uic->ConnectionTypesList));
	if (gtk_tree_selection_get_selected (select, &model, &iter))
	{
		gtk_tree_model_get (model, &iter, CONNECTION_TYPE_NAME_COLUMN,
				    &name, -1);
		rcm_remove_type_from_list_by_name (name);
		rcm_update_connectiontypes_window_list (uic);
		rcm_clear_types_window (uic);
	}
	else
	{
		rcm_warn (_("You must select a type from the list first."),
			  ConnectionTypesWindow);
	}
}

void 
on_ConnectionTypesIconEntry_clicked(GtkButton *button, UIComponents *uic)
{
	gint ret;
	GtkWidget *image;
	ret = gtk_dialog_run (GTK_DIALOG (uic->fileChooserDialog));
	if (ret == -5) {
		setIcon(button, gtk_file_chooser_get_filename(uic->fileChooserDialog));
	}
	gtk_widget_hide(uic->fileChooserDialog);
}

void
on_ConnectionsList_selection_changed_cb (GtkTreeSelection * selection,
					 UIComponents *uic)
{
	GtkWidget *widget;
	GtkTreeIter iter;
	GtkTreeModel *model;
	GtkTreeSelection *select;
	gchar *name;
	Connection *connection;
	ConnectionType *type;

	select = gtk_tree_view_get_selection (GTK_TREE_VIEW
					      (uic->ConnectionsList));
	if (gtk_tree_selection_get_selected (select, &model, &iter))
	{
		gtk_tree_model_get (model, &iter, CONNECTION_NAME_COLUMN,
				    &name, -1);
		connection = rcm_find_connection_by_name_in_list (name,
								  ConnectionsSList);
		g_return_if_fail (connection != NULL);
		widget = uic->ConnectionNameEntry;
		g_return_if_fail (widget != NULL);
		gtk_entry_set_text (GTK_ENTRY (widget), connection->Name);

		widget = uic->ConnectionHostnameEntry;
		g_return_if_fail (widget != NULL);
		gtk_entry_set_text (GTK_ENTRY (widget), connection->Hostname);

		type = g_slist_nth_data (ConnectionTypesSList,
					 connection->Type);
		widget = uic->ConnectionTypeCombo;
		g_return_if_fail (widget != NULL);
		gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (widget)->entry),
				    type->Name);

		widget = uic->ConnectionUsernameEntry;
		g_return_if_fail (widget != NULL);
		gtk_entry_set_text (GTK_ENTRY (widget), connection->Username);

		widget = uic->ConnectionArgumentsEntry;
		g_return_if_fail (widget != NULL);
		gtk_entry_set_text (GTK_ENTRY (widget),
				    connection->Arguments);
	}
}

void
on_ConnectionTypesList_selection_changed_cb (GtkTreeSelection * selection,
					     UIComponents *uic)
{
	GtkWidget *widget;
	GtkTreeIter iter;
	GtkTreeModel *model;
	GtkTreeSelection *select;
	gchar *name;
	ConnectionType *type;

	select = gtk_tree_view_get_selection (GTK_TREE_VIEW
					      (uic->ConnectionTypesList));
	if (gtk_tree_selection_get_selected (select, &model, &iter))
	{
		gtk_tree_model_get (model, &iter, CONNECTION_TYPE_NAME_COLUMN,
				    &name, -1);
		type = rcm_find_type_by_name_in_list (name, ConnectionTypesSList);
		g_return_if_fail (type != NULL);
		widget = uic->ConnectionTypesNameEntry;
		g_return_if_fail (widget != NULL);
		gtk_entry_set_text (GTK_ENTRY (widget), type->Name);

		widget = uic->ConnectionTypesCommandEntry;
		g_return_if_fail (widget != NULL);
		gtk_entry_set_text (GTK_ENTRY (widget), type->Command);

		widget = uic->ConnectionTypesArgumentsEntry;
		g_return_if_fail (widget != NULL);
		gtk_entry_set_text (GTK_ENTRY (widget), type->Arguments);
		
		widget = uic->ConnectionTypesTerminalChkBox;
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget),
					      type->Terminal);

		widget = uic->fileChooserDialog;
		g_return_if_fail (widget != NULL);
		if (type->Icon && strlen(type->Icon)>0) {
			gtk_file_chooser_set_filename(GTK_FILE_CHOOSER (widget),
					       type->Icon);
			setIcon(GTK_BUTTON(uic->iconButton), type->Icon);
		} else {
			gtk_file_chooser_unselect_all(GTK_FILE_CHOOSER (widget));
			setIcon(GTK_BUTTON(uic->iconButton), NULL);
		}
	}
}

gboolean
on_MainWindow_delete_event (GtkWidget * widget,
			    GdkEvent * event, UIComponents *uic)
{
	rcm_quit ();
	return FALSE;
}


void
on_file_new_connection_activate (GtkMenuItem * menuitem, UIComponents *uic)
{
	rcm_show_ConnectionsWindow(uic);
}


void
on_edit_preferences_activate (GtkMenuItem * menuitem, UIComponents *uic)
{
	GtkWidget* ascchk;
	GtkWidget* deschk;
	GtkWidget* typchk;
	GtkWidget* nonchk;
	GtkWidget* terminal;
	GtkWidget* arguments;
	GtkWidget* usernames;
	
	ascchk = uic->PropertyAscendingSort;
	deschk = uic->PropertyDescendingSort;
	typchk = uic->PropertyTypeSort;
	nonchk = uic->PropertyNoneSort;
	terminal = uic->PropertyTerminalEntry;
	arguments = uic->PropertyTerminalArgumentsEntry;
	usernames = uic->PropertyShowUserNames;
	
	g_return_if_fail(ascchk != NULL || deschk != NULL || typchk != NULL || nonchk != NULL || arguments != NULL || arguments != NULL);
	
	if(SortOption == SORT_ASCENDING)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ascchk),TRUE);
	else if(SortOption == SORT_DESCENDING)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(deschk),TRUE);
	else if(SortOption == SORT_TYPE)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(typchk),TRUE);
	else if(SortOption == SORT_NONE)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(nonchk),TRUE);
	
	gtk_entry_set_text(GTK_ENTRY(terminal),TerminalProgram);
	gtk_entry_set_text(GTK_ENTRY(arguments),TerminalProgramOptions);
	
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(usernames),DisplayUsernameInMainWindow);
	
	gtk_widget_show(PropertiesDialog);
}


void
on_edit_properties_activate (GtkMenuItem * menuitem, UIComponents *uic)
{
	GtkIconView *icon_list;
	GtkTreeModel *model;
	GtkTreePath *path;
	GtkTreeIter iter;
	GList *l;
	Connection *connection;

	g_return_if_fail (ConnectionsWindow != NULL);
	rcm_update_connections_window_list (uic);

	icon_list = GTK_ICON_VIEW (uic->MainList);
	g_return_if_fail (icon_list != NULL);
	l = gtk_icon_view_get_selected_items (icon_list);

	if (l)
	{
		path = (GtkTreePath *)  (l->data);
		model = gtk_icon_view_get_model(icon_list);
		if (gtk_tree_model_get_iter(model, &iter, path)) {
			gtk_tree_model_get(model, &iter, CONNECTION_COLUMN, &connection, -1);
			rcm_select_connection_by_index (connection, uic);
		}
		gtk_widget_show (ConnectionsWindow);
	}
}


void
on_ConnectionsSaveBtn_clicked (GtkButton * button, UIComponents *uic)
{
	GtkWidget *widget = NULL;
	gchar *name = NULL;
	gchar *tmp = NULL;
	gchar *hostname = NULL;
	gchar *username = NULL;
	gchar *arguments = NULL;
	Connection connection;

	widget = uic->ConnectionNameEntry;
	g_return_if_fail (widget != NULL);
	name = gtk_editable_get_chars (GTK_EDITABLE (widget), 0, -1);
	if (strnlen (name,NAMELEN) == 0)
	{
		g_free (name);
		rcm_warn (_("Conenction name is not set."),
			  ConnectionsWindow);
		return;
	}
	strncpy (connection.Name, name, NAMELEN);
	/* need this below g_free (name); */

	widget = uic->ConnectionTypeCombo;
	g_return_if_fail (widget != NULL);
	tmp = gtk_editable_get_chars (GTK_EDITABLE
				      (GTK_COMBO (widget)->entry), 0, -1);
	if (tmp == NULL || strnlen (tmp,NAMELEN) == 0)
	{
		g_free (tmp);
		rcm_warn (_("Conenction Type is not set."),
			  ConnectionsWindow);
		return;
	}
	connection.Type = rcm_lookup_type_by_name (tmp);
	widget = uic->ConnectionHostnameEntry;
	g_return_if_fail (widget != NULL);
	hostname = gtk_editable_get_chars (GTK_EDITABLE (widget), 0, -1);
	if (strnlen (hostname,HOSTNAMELEN) == 0)
	{
		g_free (hostname);
		rcm_warn (_("Conenction hostname is not set."),
			  ConnectionsWindow);
		return;
	}
	strncpy (connection.Hostname, hostname, HOSTNAMELEN);

	widget = uic->ConnectionUsernameEntry;
	g_return_if_fail (widget != NULL);
	username = gtk_editable_get_chars (GTK_EDITABLE (widget), 0, -1);
	if (strnlen (username,USERNAMELEN) != 0)
		strncpy (connection.Username, username, USERNAMELEN);

	widget = uic->ConnectionArgumentsEntry;
	g_return_if_fail (widget != NULL);
	arguments = gtk_editable_get_chars (GTK_EDITABLE (widget), 0, -1);
	if (strnlen (arguments,ARGUMENTSLEN) != 0)
		strncpy (connection.Arguments, arguments, ARGUMENTSLEN);

	rcm_save_connection (connection, uic);
	rcm_update_connections_window_list (uic);
	rcm_select_connection_by_name (name, uic);
	rcm_clear_connections_window (uic);
	g_free (name);

}


void
on_ConnectionsDeleteBtn_clicked (GtkButton * button, UIComponents *uic)
{
	GtkTreeIter iter;
	GtkTreeModel *model;
	GtkTreeSelection *select;
	gchar *name;
	Connection* connection = NULL;

	GtkWidget *ConnectionsList =uic->ConnectionsList;

	select = gtk_tree_view_get_selection (GTK_TREE_VIEW
					      (ConnectionsList));
	if (gtk_tree_selection_get_selected (select, &model, &iter))
	{
		gtk_tree_model_get (model, &iter, CONNECTION_NAME_COLUMN,
				    &name, -1);
		connection = rcm_remove_connection_from_list_by_name (name,
							 ConnectionsSList);
		if(connection != NULL)
			free(connection);
		rcm_update_connections_window_list (uic);
		rcm_update_main_window(uic);
		rcm_clear_connections_window (uic);
	}
	else
	{
		rcm_warn (_
			  ("You must select a connection from the list first."),
			  ConnectionsWindow);
	}
}


void
on_ConnectionsClearBtn_clicked (GtkButton * button, UIComponents *uic)
{
	rcm_clear_connections_window (uic);
}


void
on_ConnectionsOkBtn_clicked (GtkButton * button, UIComponents *uic)
{
	if (!rcm_save_connections_to_disk ())
		rcm_error (_("There was a problem saving."),
			   ConnectionsWindow);
	rcm_update_main_window (uic);
	gtk_widget_hide (ConnectionsWindow);
}


void
on_TbPropertiesBtn_clicked (GtkButton * button, UIComponents *uic)
{
	GtkIconView *icon_list;
	GtkTreeModel *model;
	GtkTreePath *path;
	GtkTreeIter iter;
	GList *l;
	Connection *connection;

	g_return_if_fail (ConnectionsWindow != NULL);
	rcm_update_connections_window_list (uic);

	icon_list = GTK_ICON_VIEW (uic->MainList);
	g_return_if_fail (icon_list != NULL);
	l = gtk_icon_view_get_selected_items (icon_list);

	if (l)
	{
		path = (GtkTreePath *)  (l->data);
		model = gtk_icon_view_get_model(icon_list);
		if (gtk_tree_model_get_iter(model, &iter, path)) {
			gtk_tree_model_get(model, &iter, CONNECTION_COLUMN, &connection, -1);
			rcm_select_connection_by_index (connection, uic);
		}
		gtk_widget_show (ConnectionsWindow);
	}
}


void
on_TbDeleteBtn_clicked (GtkButton * button, UIComponents *uic)
{
	GtkIconView *icon_list;
	GtkTreeModel *model;
	GtkTreePath *path;
	GtkTreeIter iter;
	GList *l;
	Connection *connection;
	GtkWidget *yes_no_dialog;
	int ret;
	gchar buff[MAX_BUFFER_LENGTH];

	icon_list = GTK_ICON_VIEW (uic->MainList);
	g_return_if_fail (icon_list != NULL);
	l = gtk_icon_view_get_selected_items (icon_list);

	if (l)
	{
		path = (GtkTreePath *)  (l->data);
		model = gtk_icon_view_get_model(icon_list);
		if (gtk_tree_model_get_iter(model, &iter, path)) {
			gtk_tree_model_get(model, &iter, CONNECTION_COLUMN, &connection, -1);
			g_return_if_fail (connection != NULL);
			snprintf (buff, MAX_BUFFER_LENGTH,
				  _("Are you sure you want to delete %s?"),
				  connection->Name);
			yes_no_dialog = gtk_message_dialog_new  (GTK_WINDOW(uic->MainWindow), GTK_DIALOG_MODAL,
						   GTK_MESSAGE_QUESTION,
						   GTK_BUTTONS_YES_NO,
						   buff);
			ret = gtk_dialog_run (GTK_DIALOG (yes_no_dialog));
			gtk_widget_destroy (yes_no_dialog);
			if (ret != GTK_RESPONSE_YES)
				return;
			connection =
				rcm_remove_connection_from_list_by_name (connection->
									 Name,
									 ConnectionsSList);
			if (connection)
				free (connection);
			rcm_update_main_window (uic);	/* causing assertion */
			rcm_save_connections_to_disk ();
		}
	}
}

void
on_ConnectionsCancelBtn_clicked (GtkButton * button, UIComponents *uic)
{
	if (!rcm_load_connections_from_disk ())
		rcm_error (_("A serious error has occured."),
			   ConnectionsWindow);
	rcm_update_main_window (uic);
	gtk_widget_hide (ConnectionsWindow);
}


void
on_file_quit_activate (GtkMenuItem * menuitem, UIComponents *uic)
{
	rcm_quit ();
}


gboolean
on_MainList_button_press_event (GtkWidget * widget,
				GdkEventButton * event, UIComponents *uic)
{
	GtkWidget *icon_list;
	GtkWidget* popupmenu;
	GtkTreeModel *model;
	GtkTreePath *path;
	GtkTreeIter iter;
	GList *l;
	Connection *connection;

	if (event->type == GDK_2BUTTON_PRESS && event->button == 1)
	{
		icon_list = uic->MainList;
		g_return_if_fail (icon_list != NULL);
		l = gtk_icon_view_get_selected_items (GTK_ICON_VIEW(icon_list));

		if (l)
		{
			path = (GtkTreePath *)  (l->data);
			model = gtk_icon_view_get_model(GTK_ICON_VIEW(icon_list));
			if (gtk_tree_model_get_iter(model, &iter, path)) {
				gtk_tree_model_get(model, &iter, CONNECTION_COLUMN, &connection, -1);
				g_return_if_fail (connection != NULL);
				rcm_launch_connection_by_name (connection->Name);
			}
		}
	}
	else if(event->button == 3)
	{
		icon_list = uic->MainList;
		g_return_if_fail (icon_list != NULL);
		l = gtk_icon_view_get_selected_items (GTK_ICON_VIEW(icon_list));
		popupmenu = create_MainWindowPopupMenu(uic, l!=NULL);
		gtk_menu_popup(GTK_MENU(popupmenu),NULL,NULL,NULL,NULL,event->button,event->time);
	}
	return FALSE;
}

void
on_TbExecuteBtn_clicked (GtkButton * button, UIComponents *uic)
{
	GtkWidget *icon_list;
	GtkTreeModel *model;
	GtkTreePath *path;
	GtkTreeIter iter;
	GList *l;
	Connection *connection;

	icon_list = uic->MainList;
	g_return_if_fail (icon_list != NULL);
	l = gtk_icon_view_get_selected_items (GTK_ICON_VIEW(icon_list));

	if (l)
	{
		path = (GtkTreePath *)  (l->data);
		model = gtk_icon_view_get_model(GTK_ICON_VIEW(icon_list));
		if (gtk_tree_model_get_iter(model, &iter, path)) {
			gtk_tree_model_get(model, &iter, CONNECTION_COLUMN, &connection, -1);
			g_return_if_fail (connection != NULL);
			rcm_launch_connection_by_name (connection->Name);
		}
	}
}

void
on_ConnectionTypeCombo_changed         (GtkEditable     *editable,  UIComponents *uic)
{
	GtkWidget* widget = NULL;
	gchar* type_name;
	ConnectionType* type = NULL;
	gint index;
	
	widget = uic->ConnectionTypeCombo;
	g_return_if_fail(widget != NULL);
	
	type_name = gtk_editable_get_chars (GTK_EDITABLE (GTK_COMBO(widget)->entry), 0, -1);
	g_return_if_fail(type_name != NULL);
	
	index = rcm_lookup_type_by_name(type_name);
	type = g_slist_nth_data(ConnectionTypesSList,index);
	if(type == NULL)
		return;
	
	widget = uic->ConnectionArgumentsEntry;
	g_return_if_fail(widget != NULL);
	
	gtk_entry_set_text(GTK_ENTRY(widget),type->Arguments);
}

void
on_PropertyNoneSort_toggled            (GtkToggleButton *togglebutton, UIComponents *uic)
{
	GtkWidget* ascchk;
	GtkWidget* deschk;
	GtkWidget* typchk;
	GtkWidget* nonchk;
	
	ascchk = uic->PropertyAscendingSort;
	deschk = uic->PropertyDescendingSort;
	typchk = uic->PropertyTypeSort;
	nonchk = uic->PropertyNoneSort;
	
	g_return_if_fail(ascchk != NULL || deschk != NULL || typchk != NULL || nonchk != NULL);
	
	if(!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(nonchk)))
		return;
	
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ascchk),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(deschk),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(typchk),FALSE);
}


void
on_PropertyTypeSort_toggled            (GtkToggleButton *togglebutton, UIComponents *uic)
{
	GtkWidget* ascchk;
	GtkWidget* deschk;
	GtkWidget* typchk;
	GtkWidget* nonchk;
	
	ascchk = uic->PropertyAscendingSort;
	deschk = uic->PropertyDescendingSort;
	typchk = uic->PropertyTypeSort;
	nonchk = uic->PropertyNoneSort;

	g_return_if_fail(ascchk != NULL || deschk != NULL || typchk != NULL || nonchk != NULL);
	
	if(!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(typchk)))
		return;

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ascchk),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(deschk),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(nonchk),FALSE);
}


void
on_PropertyDescendingSort_toggled      (GtkToggleButton *togglebutton, UIComponents *uic)
{
	GtkWidget* ascchk;
	GtkWidget* deschk;
	GtkWidget* typchk;
	GtkWidget* nonchk;
	
	ascchk = uic->PropertyAscendingSort;
	deschk = uic->PropertyDescendingSort;
	typchk = uic->PropertyTypeSort;
	nonchk = uic->PropertyNoneSort;
	
	g_return_if_fail(ascchk != NULL || deschk != NULL || typchk != NULL || nonchk != NULL);
	
	if(!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(deschk)))
		return;

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ascchk),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(nonchk),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(typchk),FALSE);
}


void
on_PropertyAscendingSort_toggled       (GtkToggleButton *togglebutton, UIComponents *uic)
{
	GtkWidget* ascchk;
	GtkWidget* deschk;
	GtkWidget* typchk;
	GtkWidget* nonchk;
	
	ascchk = uic->PropertyAscendingSort;
	deschk = uic->PropertyDescendingSort;
	typchk = uic->PropertyTypeSort;
	nonchk = uic->PropertyNoneSort;
	
	g_return_if_fail(ascchk != NULL || deschk != NULL || typchk != NULL || nonchk != NULL);
	
	if(!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ascchk)))
		return;
	
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(nonchk),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(deschk),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(typchk),FALSE);
}

void
on_PropertyCloseBtn_clicked            (GtkButton       *button, UIComponents *uic)
{
	GtkWidget* ascchk;
	GtkWidget* deschk;
	GtkWidget* typchk;
	GtkWidget* nonchk;
	GtkWidget* terminal;
	GtkWidget* arguments;
	GtkWidget* usernames;
	GConfClient *gconf_client = NULL;
	
	gtk_widget_hide(PropertiesDialog);
	
	ascchk = uic->PropertyAscendingSort;
	deschk = uic->PropertyDescendingSort;
	typchk = uic->PropertyTypeSort;
	nonchk = uic->PropertyNoneSort;
	terminal = uic->PropertyTerminalEntry;
	arguments = uic->PropertyTerminalArgumentsEntry;
	usernames = uic->PropertyShowUserNames;
	
	TerminalProgram = (gchar*)gtk_entry_get_text(GTK_ENTRY(terminal));
	TerminalProgramOptions = (gchar*)gtk_entry_get_text(GTK_ENTRY(arguments));
	
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ascchk)))
	{
		if(SortOption != SORT_ASCENDING)
		{
			rcm_ascending_sort(uic);
			SortOption = SORT_ASCENDING;
		}
	}
	else if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(deschk)))
	{
		if(SortOption != SORT_DESCENDING)
		{
			rcm_descending_sort(uic);
			SortOption = SORT_DESCENDING;
		}
	}
	else if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(typchk)))
	{
		if(SortOption != SORT_TYPE)
		{
			rcm_type_sort(uic);
			SortOption = SORT_TYPE;
		}
	}
	else if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(nonchk)))
	{
		if(SortOption != SORT_ASCENDING)
		{
			SortOption = SORT_ASCENDING;
		}
	}
	DisplayUsernameInMainWindow = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(usernames));
	rcm_update_main_window(uic);
	gconf_client = gconf_client_get_default ();
	gconf_client_set_int(gconf_client,GCONF_RCM_SORTING_OPTION,SortOption,NULL);
	g_object_unref (gconf_client);
}


void
on_PropertyCancelBtn_clicked           (GtkButton       *button, UIComponents *uic)
{
	gtk_widget_hide(PropertiesDialog);
}


void
on_popup_execute_activated             (GtkMenuItem     *menuitem, UIComponents *uic)
{
	on_TbExecuteBtn_clicked(NULL,uic);
}


void
on_popup_edit_activated                (GtkMenuItem     *menuitem, UIComponents *uic)
{
	on_TbPropertiesBtn_clicked(NULL,uic);
}


void
on_popup_delete_activated              (GtkMenuItem     *menuitem, UIComponents *uic)
{
	on_TbDeleteBtn_clicked(NULL,uic);
}


