#ifndef MAIN_H
#define MAIN_H

#include <limits.h>
#include <gtk/gtk.h>

#define MAX_BUFFER_LENGTH 255

#define PATH_MAX 1024
#define NAME_MAX 255
#define ARG_MAX 255

#define NAMELEN     MAX_BUFFER_LENGTH
#define HOSTNAMELEN MAX_BUFFER_LENGTH
#define COMMANDLEN  (PATH_MAX + NAME_MAX)
#define ICONLEN     (PATH_MAX + NAME_MAX)
#define ARGUMENTSLEN     ARG_MAX
#define USERNAMELEN	MAX_BUFFER_LENGTH

#define GCONF_RCM_VERSION "/apps/grcm/Version"
#define GCONF_RCM_SORTING_OPTION "/apps/grcm/SortingOption"
#define GCONF_RCM_DISPLAY_USERNAMES "/apps/grcm/DisplayUserNames"
#define GCONF_RCM_TERMINAL_OPTION "/apps/grcm/TerminalProgram"
#define GCONF_RCM_TERMINAL_ARGUMENTS_OPTION "/apps/grcm/TerminalProgramArguments"
#define GCONF_CONNECTION_TYPES_DIR "/apps/grcm/connection_types"
#define GCONF_CONNECTIONS_DIR "/apps/grcm/connections"
#define GCONF_MAIN_VIEW_AS_ICONVIEW "/apps/grcm/MainViewAsIconView"

extern GtkWidget *MainWindow;
extern GtkWidget *ConnectionTypesWindow;
extern GtkWidget *ConnectionsWindow;
extern GtkWidget *PropertiesDialog;

extern GSList *ConnectionsSList;
extern gboolean ConnectionsSListIsDirty;

extern GSList *ConnectionTypesSList;
extern gboolean ConnectionTypesSListIsDirty;

extern gchar* TerminalProgram;
extern gchar* TerminalProgramOptions;

typedef enum 
{
	SORT_NONE = 0,
	SORT_ASCENDING,
	SORT_DESCENDING,
	SORT_TYPE
}SORT_OPTION;

extern SORT_OPTION SortOption;
extern gboolean DisplayUsernameInMainWindow;

enum
{
	CONNECTION_NAME_COLUMN,
	CONNECTION_HOSTNAME_COLUMN,
	CONNECTION_TYPE_COLUMN,
	CONNECTION_N_COLUMNS
};

typedef struct Connection
{
	gchar Name[NAMELEN];
	gchar Hostname[HOSTNAMELEN];
	gint Type;
	gchar Username[USERNAMELEN];
	gchar Arguments[ARGUMENTSLEN];
	gboolean Dirty;
}
Connection;

enum
{
	CONNECTION_TYPE_NAME_COLUMN,
	CONNECTION_TYPE_COMMAND_COLUMN,
	CONNECTION_TYPE_ARGS_COLUMN,
	CONNECTION_TYPE_TERMINAL_COLUMN,
	CONNECTION_TYPE_ICON_COLUMN,
	CONNECTION_TYPE_N_COLUMNS
};

typedef struct ConnectionType
{
	gchar Name[NAMELEN];
	gchar Command[COMMANDLEN];
	gchar Arguments[ARGUMENTSLEN];
	gboolean Terminal;
	gchar Icon[ICONLEN];
	gboolean Dirty;
}
ConnectionType;

/* Description des colonnes*/
enum
{
	ICON_COLUMN,
	LABEL_COLUMN,
	CONNECTION_COLUMN,
	N_COLUMNS
};

struct UICStruct {
	GtkWidget *MainWindow;
	GtkWidget *ConnectionTypesList;
	GtkWidget *ConnectionsList;
	GtkWidget *ConnectionTypeCombo;
	GtkWidget *MainList;
	GtkWidget *ConnectionTypesNameEntry;
	GtkWidget *ConnectionTypesCommandEntry;
	GtkWidget *ConnectionTypesArgumentsEntry;
	GtkWidget *ConnectionTypesTerminalChkBox;
	GtkWidget *ConnectionNameEntry;
	GtkWidget *ConnectionHostnameEntry;
	GtkWidget *ConnectionUsernameEntry;
	GtkWidget *ConnectionArgumentsEntry;
	GtkWidget *PropertyAscendingSort;
	GtkWidget *PropertyDescendingSort;
	GtkWidget *PropertyTypeSort;
	GtkWidget *PropertyNoneSort;
	GtkWidget *PropertyTerminalEntry;
	GtkWidget *PropertyTerminalArgumentsEntry;
	GtkWidget *PropertyShowUserNames;
	GtkWidget *fileChooserDialog;
	GtkWidget *iconButton;

};
typedef struct UICStruct UIComponents;


void rcm_quit (void);
void rcm_update_main_window (UIComponents *uic);
void rcm_warn (const gchar * msg, GtkWidget * parent);
void rcm_error (const gchar * msg, GtkWidget * parent);
void rcm_first_run (UIComponents *uic);
void rcm_upgrade (gchar * version);

GtkWidget *CreateConnectionTypesWindow (UIComponents *uic);
void rcm_clear_types_window (UIComponents *uic);
gboolean rcm_save_type (const ConnectionType type);
ConnectionType *rcm_find_type_by_name_in_list (const gchar * name, GSList * list);
void rcm_remove_all_types_from_disk ();
void rcm_update_connectiontypes_window_list ();
gboolean rcm_save_types_to_disk ();
gboolean rcm_load_types_from_disk ();
gint rcm_gconf_client_all_types_dirs (GError ** err);
void rcm_select_type_by_name (gchar * name, UIComponents *uic);
void rcm_remove_type_from_list_by_name (const gchar * name);
gint rcm_lookup_type_by_name (gchar * name);
void rcm_show_ConnectionTypesWindow(UIComponents *uic);
void rcm_show_ConnectionsWindow(UIComponents *uic);

GtkWidget *CreateConnectionsWindow (UIComponents *uic);
void rcm_clear_connections_window (UIComponents *uic);
void rcm_update_connections_window_list (UIComponents *uic);
gboolean rcm_save_connections_to_disk ();
gboolean rcm_load_connections_from_disk ();
Connection *rcm_remove_connection_from_list_by_name (const gchar * name, GSList * list);
Connection *rcm_find_connection_by_name_in_list (const gchar * name, GSList * list);
gboolean rcm_save_connection (const Connection connection, UIComponents *uic);
void rcm_select_connection_by_name (gchar * name, UIComponents *uic);
void rcm_remove_all_connections_from_disk (void);
gint rcm_gconf_client_all_connections_dirs (GError ** err);
void rcm_select_connection_by_index (Connection *connection, UIComponents *uic);
gboolean rcm_launch_connection_by_name (gchar * name);
void rcm_translate_arg(gchar* args, const gchar* arg, const gchar* fspec, guint length);

gint rcm_compare_Ascending(gconstpointer a, gconstpointer b);
gint rcm_compare_Descending(gconstpointer a, gconstpointer b);
gint rcm_compare_Types(gconstpointer a, gconstpointer b);
void rcm_ascending_sort(UIComponents *uic);
void rcm_descending_sort(UIComponents *uic);
void rcm_type_sort(UIComponents *uic);

#endif
