#ifdef HAVE_CONFIG_H
#  include <config.h> 
#endif

#include <string.h>
#include <gtk/gtk.h>
#include <gconf/gconf-client.h>
#include "interface.h"
#include "support.h"
#include "main.h"
#include "callbacks.h"

#if HILDON == 1
#include <hildon/hildon.h>
#else
#include <hildon-widgets/hildon-program.h>
#include <hildon-widgets/hildon-banner.h>
#endif

#include <libintl.h>
#include <locale.h>
#include <libosso.h>

#define _(String) gettext(String)



GtkWidget *MainWindow;
GtkWidget *ConnectionTypesWindow;
GtkWidget *ConnectionsWindow;
GtkWidget *PropertiesDialog;

GSList *ConnectionsSList;
gboolean ConnectionsSListIsDirty;

GSList *ConnectionTypesSList;
gboolean ConnectionTypesSListIsDirty;

gchar* TerminalProgram;
gchar* TerminalProgramOptions;

SORT_OPTION SortOption = SORT_NONE;
gboolean DisplayUsernameInMainWindow = FALSE;

int
main (int argc, char *argv[])
{
	GConfClient *gconf_client = NULL;
	gchar *version = NULL;
	HildonProgram *app;
	UIComponents *uic;
	
#ifdef ENABLE_NLS
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#endif

	/* This is called in all GTK applications. Arguments are parsed
	 * from the command line and are returned to the application. */
	gtk_init (&argc, &argv);

	/* Create a new window */
        app = HILDON_PROGRAM( hildon_program_get_instance() );
        g_set_application_name(_("Remote Connection Manager" ));

	if (!g_thread_supported()) {
		g_thread_init(NULL);
	}

	uic = g_new0(UIComponents, 1);
	
        /* Create HildonAppView and set it to HildonApp */
        uic->MainWindow = hildon_window_new();
        hildon_program_add_window( app, HILDON_WINDOW( uic->MainWindow) );

	g_type_init ();

	gconf_init (argc, argv, NULL);

	gconf_client = gconf_client_get_default ();
	version =
		gconf_client_get_string (gconf_client, GCONF_RCM_VERSION,
					 NULL);
	if (version == NULL)
		rcm_first_run (uic);
	else if (strcmp (VERSION, version) != 0)
		rcm_upgrade (version);
	
	SortOption = gconf_client_get_int(gconf_client, GCONF_RCM_SORTING_OPTION, NULL);
	TerminalProgram = gconf_client_get_string(gconf_client, GCONF_RCM_TERMINAL_OPTION, NULL);
	if(!TerminalProgram)
		TerminalProgram = "osso-xterm";
	TerminalProgramOptions = gconf_client_get_string(gconf_client, GCONF_RCM_TERMINAL_ARGUMENTS_OPTION, NULL);
	if(!TerminalProgramOptions)
		TerminalProgramOptions = "-x";
	
	DisplayUsernameInMainWindow = gconf_client_get_int(gconf_client, GCONF_RCM_DISPLAY_USERNAMES, NULL);
	
	ConnectionsSList = NULL;
	ConnectionTypesSList = NULL;
	rcm_load_types_from_disk ();
	rcm_load_connections_from_disk ();

	create_MainWindow (uic->MainWindow, uic);

	rcm_update_main_window (uic);

	gtk_widget_show (uic->MainWindow);
	
	PropertiesDialog = create_PropertiesWindow(uic);
	
	ConnectionTypesWindow = CreateConnectionTypesWindow (uic);
	rcm_update_connectiontypes_window_list (uic);

	ConnectionsWindow = CreateConnectionsWindow (uic);
	rcm_update_connections_window_list (uic);

	g_object_unref (gconf_client);

	gtk_main ();
	return 0;
}

void
rcm_quit ()
{
	GConfClient *gconf_client = NULL;

	gconf_client = gconf_client_get_default ();

	gconf_client_set_string (gconf_client, GCONF_RCM_VERSION, VERSION,
				 NULL);
	gconf_client_set_string (gconf_client, GCONF_RCM_TERMINAL_OPTION, TerminalProgram,
				 NULL);
	gconf_client_set_string (gconf_client, GCONF_RCM_TERMINAL_ARGUMENTS_OPTION, TerminalProgramOptions,
				 NULL);
	gconf_client_set_int (gconf_client, GCONF_RCM_SORTING_OPTION, SortOption,
			      NULL);
	gconf_client_set_int (gconf_client, GCONF_RCM_DISPLAY_USERNAMES, DisplayUsernameInMainWindow,
			      NULL);
	gconf_client_suggest_sync (gconf_client, NULL);
	g_object_unref (gconf_client);
	gtk_exit (0);
}

GtkWidget *
CreateConnectionTypesWindow (UIComponents *uic)
{
	GtkTreeSelection *select;
	GtkWidget *pConnectionTypesWindow = create_ConnectionTypesWindow (uic);
	GtkListStore *TypesStore;
	GtkCellRenderer *renderer1;
	GtkTreeViewColumn *column1;
	GtkCellRenderer *renderer2;
	GtkTreeViewColumn *column2;
	GtkCellRenderer *renderer3;
	GtkTreeViewColumn *column3;
	GtkCellRenderer *renderer4;
	GtkTreeViewColumn *column4;
	GtkCellRenderer *renderer5;
	GtkTreeViewColumn *column5;

	gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(uic->fileChooserDialog), getGrcmImageDIr());
	gtk_window_set_transient_for (GTK_WINDOW (pConnectionTypesWindow),
				      GTK_WINDOW (MainWindow));

	TypesStore =
		gtk_list_store_new (CONNECTION_TYPE_N_COLUMNS,
				    G_TYPE_STRING,
				    G_TYPE_STRING,
				    G_TYPE_STRING,
				    G_TYPE_BOOLEAN,
				    G_TYPE_STRING);
	gtk_tree_view_set_model (GTK_TREE_VIEW (uic->ConnectionTypesList),
				 GTK_TREE_MODEL (TypesStore));
	gtk_tree_view_set_headers_visible (GTK_TREE_VIEW
					   (uic->ConnectionTypesList), TRUE);
	g_object_unref (G_OBJECT (TypesStore));


	renderer1 = gtk_cell_renderer_text_new ();
	column1 =
		gtk_tree_view_column_new_with_attributes (_("Name"),
							  renderer1, "text",
							  CONNECTION_TYPE_NAME_COLUMN,
							  NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (uic->ConnectionTypesList),
				     column1);


	renderer2 = gtk_cell_renderer_text_new ();
	column2 =
		gtk_tree_view_column_new_with_attributes (_("Command"),
							  renderer2, "text",
							  CONNECTION_TYPE_COMMAND_COLUMN,
							  NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (uic->ConnectionTypesList),
				     column2);

	renderer3 = gtk_cell_renderer_text_new ();
	column3 =
		gtk_tree_view_column_new_with_attributes (_("Arguments"),
							  renderer3, "text",
							  CONNECTION_TYPE_ARGS_COLUMN,
							  NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (uic->ConnectionTypesList),
				     column3);

	renderer4 = gtk_cell_renderer_toggle_new ();
	column4 =
		gtk_tree_view_column_new_with_attributes (_("Terminal"),
							  renderer4, "radio",
							  CONNECTION_TYPE_TERMINAL_COLUMN,
							  NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (uic->ConnectionTypesList),
				     column4);

	renderer5 = gtk_cell_renderer_text_new ();
	column5 =
		gtk_tree_view_column_new_with_attributes (_("Icon"),
							  renderer5, "text",
							  CONNECTION_TYPE_ICON_COLUMN,
							  NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (uic->ConnectionTypesList),
				     column5);

	select = gtk_tree_view_get_selection (GTK_TREE_VIEW
					      (uic->ConnectionTypesList));
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	g_signal_connect (G_OBJECT (select), "changed",
			  G_CALLBACK
			  (on_ConnectionTypesList_selection_changed_cb),
			  (gpointer) uic);
	return pConnectionTypesWindow;
}

GtkWidget *
CreateConnectionsWindow (UIComponents *uic)
{
	GtkTreeSelection *select;
	GtkWidget *pConnectionsWindow = create_ConnectionsWindow (uic);
	GtkListStore *ConnStore;
	GtkCellRenderer *renderer1;
	GtkTreeViewColumn *column1;
	GtkCellRenderer *renderer2;
	GtkTreeViewColumn *column2;
	GtkCellRenderer *renderer3;
	GtkTreeViewColumn *column3;
	
	gtk_window_set_transient_for (GTK_WINDOW (pConnectionsWindow),
				      GTK_WINDOW (MainWindow));

	ConnStore =
		gtk_list_store_new (CONNECTION_TYPE_N_COLUMNS,
				    G_TYPE_STRING,
				    G_TYPE_STRING,
				    G_TYPE_STRING,
				    G_TYPE_BOOLEAN,
				    G_TYPE_STRING);
	gtk_tree_view_set_model (GTK_TREE_VIEW (uic->ConnectionsList),
				 GTK_TREE_MODEL (ConnStore));
	gtk_tree_view_set_headers_visible (GTK_TREE_VIEW
					   (uic->ConnectionsList), TRUE);
	g_object_unref (G_OBJECT (ConnStore));


	renderer1 = gtk_cell_renderer_text_new ();
	column1 =
		gtk_tree_view_column_new_with_attributes (_("Name"),
							  renderer1, "text",
							  CONNECTION_NAME_COLUMN,
							  NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (uic->ConnectionsList), column1);

	renderer2 = gtk_cell_renderer_text_new ();
	column2 =
		gtk_tree_view_column_new_with_attributes (_("Hostname"),
							  renderer2, "text",
							  CONNECTION_HOSTNAME_COLUMN,
							  NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (uic->ConnectionsList), column2);

	renderer3 = gtk_cell_renderer_text_new ();
	column3 =
		gtk_tree_view_column_new_with_attributes (_("Type"),
							  renderer3, "text",
							  CONNECTION_TYPE_COLUMN,
							  NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (uic->ConnectionsList), column3);
	select = gtk_tree_view_get_selection (GTK_TREE_VIEW (uic->ConnectionsList));
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	g_signal_connect (G_OBJECT (select), "changed",
			  G_CALLBACK
			  (on_ConnectionsList_selection_changed_cb), (gpointer) uic);

	gtk_editable_set_editable (GTK_EDITABLE (GTK_COMBO (uic->ConnectionTypeCombo)->entry),
				   FALSE);
	return pConnectionsWindow;
}

void
rcm_warn (const gchar * msg, GtkWidget * parent)
{
	GtkWidget *dialog = gtk_message_dialog_new  (GTK_WINDOW(parent), GTK_DIALOG_MODAL,
						   GTK_MESSAGE_WARNING,
						   GTK_BUTTONS_OK,
						   msg);
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
}

void
rcm_error (const gchar * msg, GtkWidget * parent)
{
	GtkWidget *dialog = gtk_message_dialog_new  (GTK_WINDOW(parent), GTK_DIALOG_MODAL,
						   GTK_MESSAGE_ERROR,
						   GTK_BUTTONS_OK,
						   msg);
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
}


void
rcm_update_main_window (UIComponents *uic)
{
	gint i, len;
	GList *l = NULL;
	Connection *connection;
	ConnectionType *type;
	gchar icon_text[MAX_BUFFER_LENGTH];
	GtkTreePath *path = NULL;
	GtkListStore *store;
	GtkTreeIter iter;
	GdkPixbuf *pixbuf;

	g_return_if_fail (uic->MainList != NULL);

	store = GTK_LIST_STORE(gtk_icon_view_get_model(GTK_ICON_VIEW (uic->MainList)));

	l = gtk_icon_view_get_selected_items (GTK_ICON_VIEW (uic->MainList));
	if (l)
	{
		path = (GtkTreePath *) (l->data);
	}

	gtk_list_store_clear(store);

	len = g_slist_length (ConnectionsSList);
	for (i = 0; i < len; i++)
	{
		connection = g_slist_nth_data (ConnectionsSList, i);
		type = g_slist_nth_data (ConnectionTypesSList,
					 connection->Type);
		if(DisplayUsernameInMainWindow) {
			snprintf(icon_text,MAX_BUFFER_LENGTH,"%s@%s",connection->Username,connection->Name);
		} else {
			snprintf(icon_text,MAX_BUFFER_LENGTH,"%s",connection->Name);
		}
		gtk_list_store_append(store, &iter);
		pixbuf = create_pixbuf( type->Icon);
		gtk_list_store_set(store, &iter, ICON_COLUMN, pixbuf, LABEL_COLUMN, icon_text, CONNECTION_COLUMN, connection, -1);
	}

	if (path) {
		gtk_icon_view_select_path (GTK_ICON_VIEW (uic->MainList), path);
	}
}

gint rcm_compare_Ascending(gconstpointer a, gconstpointer b)
{
	return strcmp(((Connection*)a)->Name,((Connection*)b)->Name);
}

gint rcm_compare_Descending(gconstpointer a, gconstpointer b)
{
	return strcmp(((Connection*)b)->Name,((Connection*)a)->Name);
}

gint rcm_compare_Types(gconstpointer a, gconstpointer b)
{
	ConnectionType* aa = g_slist_nth_data(ConnectionTypesSList,((Connection*)a)->Type);
	ConnectionType* bb = g_slist_nth_data(ConnectionTypesSList,((Connection*)b)->Type);;
	return strcmp(((ConnectionType*)aa)->Name,((ConnectionType*)bb)->Name);
}

void rcm_ascending_sort(UIComponents *uic)
{
	ConnectionsSList = g_slist_sort(ConnectionsSList,rcm_compare_Ascending);
	ConnectionsSListIsDirty = TRUE;
	rcm_save_connections_to_disk();
	rcm_update_main_window(uic);
}


void rcm_descending_sort(UIComponents *uic)
{
	ConnectionsSList = g_slist_sort(ConnectionsSList,rcm_compare_Descending);
	ConnectionsSListIsDirty = TRUE;
	rcm_save_connections_to_disk();
	rcm_update_main_window(uic);
}


void rcm_type_sort(UIComponents *uic)
{
	ConnectionsSList = g_slist_sort(ConnectionsSList,rcm_compare_Types);
	ConnectionsSListIsDirty = TRUE;
	rcm_save_connections_to_disk();
	rcm_update_main_window(uic);
}

void rcm_translate_arg(gchar* args, const gchar* arg, const gchar* fspec, guint length)
{
	GString* str = NULL;
	gchar* tmp = NULL;
	guint index = 0;
	
	str = g_string_new(args);
	tmp = strstr(args,fspec);
	if(tmp == NULL)
	{
		return;
	}
	index = (tmp - args); 
	g_string_erase(str,index,2);
	g_string_insert(str,index,arg);
	memset(args,0,length);
	strncat(args,str->str,length);
	g_string_free(str,TRUE);
}

void
rcm_first_run (UIComponents *uic)
{
	ConnectionType type;
	Connection connection;
	GtkWidget *dialog = NULL;
	
	memset(&type,0,sizeof(struct ConnectionType));
	memset(&connection,0,sizeof(struct Connection));
	
	strncpy(type.Command,"ftp",MAX_BUFFER_LENGTH);
	strncpy(type.Name,"FTP",MAX_BUFFER_LENGTH);
	strncpy(type.Icon, getIconFullPath("ftp.xpm"),MAX_BUFFER_LENGTH);
	type.Terminal = TRUE;
	
	strncpy(connection.Arguments,"%h",MAX_BUFFER_LENGTH);
	strncpy(connection.Hostname,"ftp.gnome.org",MAX_BUFFER_LENGTH);
	strncpy(connection.Name,"Gnome FTP Site",MAX_BUFFER_LENGTH);
	
	rcm_save_type(type);
	rcm_save_types_to_disk();
	rcm_save_connection(connection, uic);
	rcm_save_connections_to_disk();
	
	dialog = gtk_message_dialog_new  (GTK_WINDOW(uic->MainWindow), GTK_DIALOG_MODAL,
						   GTK_MESSAGE_INFO,
						   GTK_BUTTONS_OK,
						   _("It appears you have never run grcm before,\nso I have added a few entries to get you started."));
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
}

void rcm_show_ConnectionTypesWindow(UIComponents *uic)
{
	g_return_if_fail (ConnectionTypesWindow != NULL);
	rcm_update_connectiontypes_window_list (uic);
	rcm_clear_types_window(uic);
	gtk_widget_show (ConnectionTypesWindow);
}

void rcm_show_ConnectionsWindow(UIComponents *uic)
{
	g_return_if_fail (ConnectionsWindow != NULL);
	rcm_update_connections_window_list (uic);
	rcm_clear_connections_window(uic);
	gtk_widget_show (ConnectionsWindow);
}

void
rcm_upgrade (gchar * version)
{
}
