/*
 * Copyright (C) 2008 Till Harbaum <till@harbaum.org>.
 *
 * This file is part of GPXView.
 *
 * GPXView is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GPXView is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GPXView.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef ICONS_H
#define ICONS_H

/* icon families */
enum { 
  ICON_CACHE_TYPE = 0,
  ICON_CACHE_TYPE_SEMI,
  ICON_CACHE_SIZE,
  ICON_STARS,
  ICON_LOG,
  ICON_HEADING,
  ICON_WPT,
  ICON_TB,
  ICON_MISC,
  ICON_FILE
};

void icons_init(void);
void icons_free(void);

GdkPixbuf *icon_bearing(pos_t from, pos_t to);
GdkPixbuf *icon_get(int type, int num);
GtkWidget *icon_get_widget(int type, int num);

#endif // ICONS_H
