/*
 * Copyright (C) 2008 Till Harbaum <till@harbaum.org>.
 *
 * This file is part of GPXView.
 *
 * GPXView is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GPXView is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GPXView.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef GPXVIEW_H
#define GPXVIEW_H

#include "config.h"

#include <string.h>
#include <stdlib.h>

#include <locale.h>
#include <libintl.h>

#define _(String) gettext(String)
#define N_(String) (String)

#ifdef USE_MAEMO
#include <hildon/hildon-program.h>
#include <hildon/hildon-file-chooser-dialog.h>
#include <hildon/hildon-file-system-model.h>
#include <hildon/hildon-bread-crumb-trail.h>
#include <hildon/hildon-number-editor.h>
#include <libosso.h>      /* required for screen saver timeout */
#ifdef HILDON_HELP
#include <hildon/hildon-help.h>
#endif
#if MAEMO_VERSION_MAJOR >= 5
#define USE_PANNABLE_AREA
#include <hildon/hildon-pannable-area.h>
#endif
#endif

#include <gtk/gtk.h>
#include <gtkhtml/gtkhtml.h>

/* list of current gpx files is being kept in gconf */
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>

#include <libgnomevfs/gnome-vfs.h>
#include <libgnomevfs/gnome-vfs-inet-connection.h>

/* all include appdata_t relies on go here ... */
#include "gpx.h"
#include "settings.h"

#define GPXLIST_ITEM_VALID    (1<<0)
#define GPXLIST_ITEM_DATE     (1<<1)
#define GPXLIST_ITEM_CNUM     (1<<2)
#define GPXLIST_ITEM_FILENAME (1<<3)
#define GPXLIST_ITEM_DEFAULT  (GPXLIST_ITEM_VALID | GPXLIST_ITEM_CNUM)

#define CACHELIST_ITEM_VALID  (1<<0)
#define CACHELIST_ITEM_ID     (1<<1)
#define CACHELIST_ITEM_SIZE   (1<<2)
#define CACHELIST_ITEM_RATING (1<<3)
#define CACHELIST_ITEM_DEFAULT  (CACHELIST_ITEM_VALID | CACHELIST_ITEM_ID)

typedef struct {
  pos_t home;                 /* current home geo position */
  gboolean use_gps;           /* use GPS if avbailable */
  char *path;                 /* current path to select GPX from */

  location_t *location;       /* extra home locations */
  int active_location;        /* index of active (extra) home location */

  gboolean imperial;          /* display imperial units */

  pos_t gps;                  /* saved last gps position */

  char *image_path;           /* path to cache images in */
  gboolean load_images;       /* load images and cache them */

  int search;                 /* "search in" items */
  char *search_str; 
  int search_days;

  int gpxlist_items;
  int cachelist_items;
  guint cachelist_handler_id; /* update timer */
  gboolean cachelist_hide_found;

  /* geotext related */
  char *geotext_text;
  int  geotext_shift;

  gpx_t *gpx;
  GtkListStore *gpxstore;
  GtkWidget    *gpxview;
  GConfClient *gconf_client;

  pos_t manual_goto;
  gboolean compass_locked;
  int compass_damping;

  struct gps_state *gps_state;

  /* keep track of all html views so zoom events can be delivered */
  struct html_view *html_view;

#ifndef REQUIRES_CLOSE_BUTTON
  /* this is being activated and de-activated on selection/deselection */
  GtkWidget *menu_remove, *menu_close;
#endif

  /* do enable/disable the edit entries */
  GtkWidget *menu_cut, *menu_copy, *menu_paste;
  GtkClipboard *clipboard;     /* clipboard for copy/paste */
  GtkTextBuffer *active_buffer;

  /* save result here to be able to "goto" it */
  pos_t geomath;

  int cur_items;
  GtkWidget *cur_view;

  char *mmpoi_path;           /* path to save poi to */
  float mmpoi_radius;
  gboolean mmpoi_use_radius;
  gboolean mmpoi_dont_export_found;
  gboolean mmpoi_dont_export_disabled;

  char *fieldnotes_path;       /* path to save field notes to */

  char *garmin_path;           /* path to save garmin data to */
  gboolean garmin_ign_found;

#ifdef USE_MAEMO
  pos_t mmpos;                /* position received from Maemo Mapper */
  gboolean mmpos_valid;

  gboolean mmpoi_dontlaunch;

  gboolean cachelist_disable_screensaver;
  gboolean goto_disable_screensaver;
  gboolean cachelist_update;

  HildonProgram *program;
  HildonWindow *window;
  osso_context_t *osso_context;
  GtkWidget *bct;
  gpx_t *search_results;

  /* reference to enable/disable these while walking the crumb trail */
  GtkWidget *menu_import, *menu_export;
  GtkWidget *menu_search;

  /* reference to change this to reflect fullscreen by hard button */
  /* and the ability to zoom */
#if MAEMO_VERSION_MAJOR < 5
  GtkWidget *fullscreen_menu_item;
#endif
  GtkWidget *zoomin_menu_item, *zoomout_menu_item;

  /* keep track of current "path" in the bread crumb trail */
  gpx_t *cur_gpx;
  cache_t *cur_cache;

#else
  GtkWidget *window;
#endif
  GtkWidget *vbox;    
} appdata_t;

/* all includes that rely on appdata_t go here ... */
#include "gps.h"
#include "goto.h"
#include "gconf.h"
#include "html.h"
#include "icons.h"
#include "cache.h"
#include "geomath.h"
#include "geotext.h"
#include "notes.h"
#include "help.h"
#include "mm_poi.h"
#include "precpos.h"
#include "garmin_export.h"

#ifdef USE_MAEMO
#include "dbus.h"
#endif

#define SEARCH_ID    (1<<0)
#define SEARCH_NAME  (1<<1)
#define SEARCH_DESC  (1<<2)
#define SEARCH_OWNER (1<<3)
#define SEARCH_FINDS (1<<4)

#ifdef USE_MAEMO
#define DIALOG_WIDTH  800
#define DIALOG_HEIGHT 480
#define GTK_FM_OK  GTK_RESPONSE_OK
#else
#define DIALOG_WIDTH  560
#define DIALOG_HEIGHT 340
#define GTK_FM_OK  GTK_RESPONSE_ACCEPT
#endif

#include "misc.h"

#define CHANGE_FLAG_POS   (1<<0)
#define CHANGE_FLAG_MASK  (1<<1)

extern void main_after_settings_redraw(appdata_t *appdata, int flags);

#include <stdarg.h>
extern void errorf(const char *fmt, ...);
extern gboolean on_window_key_press(GtkWidget *widget, 
				    GdkEventKey *event, gpointer data);

#endif // GPXVIEW_H
