/*
 * gps-camera.c
 * Copyright (C) 2007 Sanna Salmijärvi (ssalmija@gmail.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */


#include "gps-camera-controller.h"

#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gst/gst.h>
#include <gst/interfaces/xoverlay.h>
//#include <hildon-1/hildon/hildon-banner.h>
#include <hildon-1/hildon/hildon-program.h>
#include <jpeglib.h>
#include <libgnomevfs/gnome-vfs.h>
#include <libosso.h>
#include <errno.h>
//#include <osso-uri.h>
#include <gconf/gconf-client.h>
#include <osso-log.h>
#include <sys/syslog.h>
#include <log-functions.h>


#define PACKAGE "Gpscamera"
#define VERSION "0.4"
#define SERVICE_URI "com.example.gpscamera"
#define OBJECT_PATH "/com/example/gpscamera"

gint dbus_req_handler(const gchar * interface, const gchar * method, 
		GArray * arguments, gpointer data, osso_rpc_t * retval) {
	return OSSO_OK;
}

int main(int argc, char **argv)
{
	
	osso_context_t* context = NULL;
	int ret;

	context = osso_initialize(PACKAGE, VERSION, TRUE, NULL);
	if (context == NULL) {
		osso_log(LOG_ERR, "Osso context not initialized \n");
		return -1;
	}

	if ((ret = osso_rpc_set_cb_f(context, SERVICE_URI, OBJECT_PATH,
		SERVICE_URI, dbus_req_handler, context)) != OSSO_OK) {
		fprintf(stderr, "ERROR: D-BUS callback setting failed (%d)\n", ret);
		return 1;
	}

	gtk_init(&argc, &argv);
	gst_init(&argc, &argv);
		
	if(gnome_vfs_init() == FALSE) {
		osso_log(LOG_ERR, "gnome vfs init failed \n");
		return -1;
	}

	if(gpscamera_launch(context) == FALSE) {
		osso_log(LOG_ERR, " Gpscamera application launch error \n");
		return -1;
	}
	
	gtk_main();
	
	return 0;
}

