
/**
 * gps-camera-widget.h
* Copyright (C) 2007 Sanna Salmijarvi (ssalmija@gmail.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */ 


#ifndef GPSCAMERA_WIDGET_H
#define GPSCAMERA_WIDGET_H

/* Includes */
#include <gtk/gtkvbox.h>

G_BEGIN_DECLS

#define MY_TYPE_GPSCAMERA_WIDGET (gpscamera_widget_get_type ())
#define GPSCAMERA_WIDGET(o) (G_TYPE_CHECK_INSTANCE_CAST ((o),\
        MY_TYPE_GPSCAMERA_WIDGET, GpscameraWidget))
#define IS_GPSCAMERA_WIDGET(o) (G_TYPE_CHECK_INSTANCE_TYPE ((o),\
        MY_TYPE_GPSCAMERA_WIDGET))


typedef struct _GpscameraWidgetPriv GpscameraWidgetPriv;

/**
 * CameraWidget
 **/
typedef struct {
	/*! parent of camerawidget */
    GtkVBox parent;
    /*! private widget */
    GpscameraWidgetPriv *priv;
} GpscameraWidget;

/**
 * CameraWidgetClass
 **/
typedef struct {
	/*! parent class of camera widget class */
    GtkVBoxClass parent_class;
    
} GpscameraWidgetClass;

/* Construction */
GtkWidget *gpscamera_widget_new (void);

guint32 gpscamera_widget_get_xid(GpscameraWidget *gpscamerawidget);

G_END_DECLS

#endif
