/**
 * gps-camera-widget.c
 * Copyright (C) 2007 Sanna Salmijarvi (ssalmija@gmail.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */ 

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <hildon-1/hildon/hildon-defines.h>
#include <osso-log.h>

#include "gps-camera-widget.h"

#define BG_COLOR_BLACK "ImageBackgrdColor"


struct _GpscameraWidgetPriv {
	GtkWidget *bg_image;
	GtkWidget *event_box;
};

/* GType boilerplate */
G_DEFINE_TYPE(GpscameraWidget, gpscamera_widget, GTK_TYPE_VBOX)

/* Object construction and destruction */
static void gpscamera_widget_class_init(GpscameraWidgetClass * klass);
static void gpscamera_widget_init(GpscameraWidget * gpscamerawidget);
static void gpscamera_widget_finalize(GObject * object);

static void gpscamera_widget_class_init(GpscameraWidgetClass * klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS(klass);

	object_class->finalize = gpscamera_widget_finalize;

}

static void gpscamera_widget_init(GpscameraWidget * gpscamerawidget)
{
	GpscameraWidgetPriv *priv = NULL;

	g_return_if_fail(IS_GPSCAMERA_WIDGET(gpscamerawidget));

	if (gpscamerawidget->priv != NULL) {
		return;
	}

	priv = gpscamerawidget->priv = g_new0(GpscameraWidgetPriv, 1);
	priv->event_box = gtk_event_box_new();
	priv->bg_image = gtk_image_new();

	gtk_container_add(GTK_CONTAINER(gpscamerawidget), priv->event_box);
	gtk_container_add(GTK_CONTAINER(priv->event_box), priv->bg_image);

	gtk_widget_add_events(priv->event_box, GDK_VISIBILITY_NOTIFY_MASK);

	GTK_WIDGET_UNSET_FLAGS(priv->event_box, GTK_DOUBLE_BUFFERED);
	GTK_WIDGET_SET_FLAGS(priv->event_box, GTK_APP_PAINTABLE);
}

/* Finalize destruction */
static void gpscamera_widget_finalize(GObject * object)
{
	GpscameraWidget *gpscamerawidget = GPSCAMERA_WIDGET(object);
	GpscameraWidgetPriv *priv = gpscamerawidget->priv;

	g_free(priv);
	gpscamerawidget->priv = NULL;

	G_OBJECT_CLASS(gpscamera_widget_parent_class)->finalize(object);
}


/**
 * The default constructor.
 * 
 * @return pointer to a newly created #GpscameraWidget, cast
 * to #GtkWidget.
 **/
GtkWidget *gpscamera_widget_new(void)
{
	return gtk_widget_new(MY_TYPE_GPSCAMERA_WIDGET, NULL);
}

/**
 * Returns the XID of the widget window.
 * @param vw pointer to a #GpscameraWidget
 * @return a #guint32
 **/
guint32 gpscamera_widget_get_xid(GpscameraWidget * gpscamerawidget)
{
	g_return_val_if_fail(IS_GPSCAMERA_WIDGET(gpscamerawidget), 0);

	gdk_window_set_events(gpscamerawidget->priv->event_box->window,
			      gdk_window_get_events(gpscamerawidget->priv->event_box->window) |
			      GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK);

	return GDK_WINDOW_XID(gpscamerawidget->priv->event_box->window);
}

