/**
 * gps-camera-ui.h
 * Copyright (C) 2007 Sanna Salmijarvi (ssalmija@gmail.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */ 

#ifndef GPS_CAMERA_UI_H
#define GPS_CAMERA_UI_H


#include <glib.h>
#include <gtk/gtk.h>
#include <gst/gst.h>
#include <gnome-vfs-2.0/libgnomevfs/gnome-vfs-mime.h>
#include <hildon-1/hildon/hildon-program.h>
#include <libgnomevfs/gnome-vfs-volume-monitor.h>
#include <libosso.h>
#include <hildon-1/hildon/hildon-caption.h>
#include <libintl.h>

#include "gps-camera-controller.h"
#include "gps-camera-common.h"
     
#ifdef HAVE_CONFIG_H
#endif

#define DISPLAY_WIDTH 432
#define DISPLAY_HEIGHT 324
#define DIALOG_WIDTH   360
#define DIALOG_HEIGHT  220
#define DIALOG_HEIGHT2  180

#define MODE_BUTTON_WIDTH 152
#define MODE_BUTTON_HEIGHT 60
#define RADIAL_BUTTON_WIDTH 152
#define RADIAL_BUTTON_HEIGHT 152
#define STATUSBOX_WIDTH 152
#define STATUSBOX_HEIGHT 152
#define INFOBOX_HEIGHT 25
#define BROWSE_MODE_BUTTON_WIDTH 81
#define BROWSE_MODE_BUTTON_HEIGHT 70


/**
 This function creates uiview.
 @param camerawindow is the pointer to the CameraView structure.
*/
GtkWidget *gpscamera_views_create(CameraView * camerawindow);

/**
 This is the callback function for uploading the image.
 @param camerawindow is the pointer to the CameraView structure.
 @param image_path is the gchar pointer to the image path to be uploaded.
*/
void gpscamera_initiate_upload(CameraView * camerawindow, const gchar * image_path);

/**
 This is the function that create login dialog.
 @param settings is the pointer to the CameraLoginSettings structure.
 @param mainwindow is window where dialog shows.
*/
void gpscamera_login_dialog_create(CameraLoginSettings * settings, GtkWidget * mainwindow);

/**
 This is the function that create delete dialog.
 @param mainwindow is window where dialog shows.
*/
GtkWidget* gpscamera_delete_dialog_create(GtkWidget * mainwindow);

#endif

