/**
 * gps-camera-ui.c
 * Copyright (C) 2007 Sanna Salmijarvi (ssalmija@gmail.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA. 
**/


/*User defined header files */
#include "gps-camera-ui.h"
#include "gps-camera-common.h"
#include "gps-camera-controller.h"
#include "gps-camera-widget.h"
#include "gps-camera-states.h"
#include "gps-camera-flickr.h"
#include "gps-camera-define.h"

#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gst/gst.h>
#include <gst/interfaces/xoverlay.h>
#include <hildon-1/hildon/hildon-banner.h>
#include <hildon-1/hildon/hildon-program.h>
#include <jpeglib.h>
#include <libosso.h>
#include <errno.h>
#include <hildon-uri.h>
#include <gconf/gconf-client.h>
#include <osso-log.h>
#include <sys/syslog.h>
#include <log-functions.h>

static GtkWidget *gpscamera_widget_create()
{
	GtkWidget *gpscamera_widget = NULL;

	osso_log(LOG_DEBUG, "Start Function %s \n", __FUNCTION__);

	gpscamera_widget = (GtkWidget *) gpscamera_widget_new();
	if (!gpscamera_widget) {
		osso_log(LOG_WARNING, "Unable to create gpscamera widget\n");
		return NULL;
	}

	osso_log(LOG_DEBUG, "End Function %s \n", __FUNCTION__);

	return gpscamera_widget;
}


GtkWidget *gpscamera_views_create(CameraView * camerawindow)
{
	/*creating the ui widgets and showing/hiding them
	   when required */

	GtkWidget *mainview = NULL;
	GtkWidget *main_image = NULL;
	GtkWidget *radial_button_image = NULL;
	GtkWidget *radial_button_image2 = NULL;
	GtkWidget *radial_button_image3 = NULL;
	GtkWidget *snapshot_mode_image = NULL;
	GtkWidget *browse_mode_image = NULL;
	GtkWidget *delete_button_image = NULL;
	GtkWidget *delete_button_image2 = NULL;
	GtkWidget *upload_button_image = NULL;
	GtkWidget *upload_button_image2 = NULL;
	GtkWidget *statusbox_background = NULL;
	GtkWidget *radial_button_left_image = NULL;
	GtkWidget *radial_button_right_image = NULL;
	GtkWidget *image_event_box_image = NULL;
	
	osso_log(LOG_DEBUG, "Start Function %s \n", __FUNCTION__);

	g_return_val_if_fail(camerawindow != NULL, NULL);

	mainview = gtk_fixed_new();
	main_image = gtk_image_new_from_file
		("/usr/share/gpscamera/pictures/gpscam_main_background.png");
	gtk_container_add (GTK_CONTAINER (mainview), main_image);
	
	camerawindow->camera_mode_eventbox = gtk_event_box_new();
	gtk_widget_set_size_request(camerawindow->camera_mode_eventbox, 
					MODE_BUTTON_WIDTH, MODE_BUTTON_HEIGHT);
	snapshot_mode_image = gtk_image_new_from_file
		("/usr/share/gpscamera/pictures/gpscam_mode_snapshot.png");
	gtk_container_add (GTK_CONTAINER (camerawindow->camera_mode_eventbox), 
				snapshot_mode_image);
	 g_signal_connect (G_OBJECT (camerawindow->camera_mode_eventbox),  
				"button_press_event",
	                      	G_CALLBACK (gpscamera_change_browse_mode),
	                      	camerawindow);
	gtk_fixed_put(GTK_FIXED(mainview), camerawindow->camera_mode_eventbox,
				 494, 36);

	camerawindow->browse_mode_eventbox = gtk_event_box_new();
	gtk_widget_set_size_request(camerawindow->browse_mode_eventbox, 
				MODE_BUTTON_WIDTH, MODE_BUTTON_HEIGHT);
	browse_mode_image = gtk_image_new_from_file
			("/usr/share/gpscamera/pictures/gpscam_mode_browse.png");
	gtk_container_add (GTK_CONTAINER (camerawindow->browse_mode_eventbox), 
				browse_mode_image);
	g_signal_connect (G_OBJECT (camerawindow->browse_mode_eventbox),  
				"button_press_event",
	                      	G_CALLBACK (gpscamera_change_snapshot_mode),
	                      	camerawindow);
	gtk_fixed_put(GTK_FIXED(mainview), camerawindow->browse_mode_eventbox, 
				494, 36);
		
	camerawindow->radial_snapshot_eventbox2 = gtk_event_box_new();
	gtk_widget_set_size_request(camerawindow->radial_snapshot_eventbox2, 
				RADIAL_BUTTON_WIDTH, RADIAL_BUTTON_HEIGHT);
	radial_button_image3 = gtk_image_new_from_file
	("/usr/share/gpscamera/pictures/gpscam_radial_pressed_snapshot.png");
	gtk_container_add (GTK_CONTAINER (camerawindow->radial_snapshot_eventbox2), 
				radial_button_image3);
	gtk_fixed_put(GTK_FIXED(mainview), camerawindow->radial_snapshot_eventbox2, 
				494, 117);

	camerawindow->radial_browse_eventbox = gtk_event_box_new();
	gtk_widget_set_size_request(camerawindow->radial_browse_eventbox, 
				RADIAL_BUTTON_WIDTH, RADIAL_BUTTON_HEIGHT);
	radial_button_image2 = gtk_image_new_from_file
	("/usr/share/gpscamera/pictures/gpscam_radial_unpressed_browse.png");
	gtk_container_add (GTK_CONTAINER (camerawindow->radial_browse_eventbox),
				 radial_button_image2);
	g_signal_connect (G_OBJECT (camerawindow->radial_browse_eventbox),  
				"button_press_event",
	                      	G_CALLBACK (gpscamera_activate_state_browse),
	                      	camerawindow);
	gtk_fixed_put(GTK_FIXED(mainview), camerawindow->radial_browse_eventbox, 
				494, 117);

	camerawindow->radial_browse_left_eventbox = gtk_event_box_new();
	gtk_widget_set_size_request(camerawindow->radial_browse_left_eventbox, 
				RADIAL_BUTTON_WIDTH, RADIAL_BUTTON_HEIGHT);
	radial_button_left_image = gtk_image_new_from_file
		("/usr/share/gpscamera/pictures/gpscam_radial_pressed_left.png");
	gtk_container_add (GTK_CONTAINER (camerawindow->radial_browse_left_eventbox), 
				radial_button_left_image);
	gtk_fixed_put(GTK_FIXED(mainview), camerawindow->radial_browse_left_eventbox, 
				494, 117);

	camerawindow->radial_browse_right_eventbox = gtk_event_box_new();
	gtk_widget_set_size_request(camerawindow->radial_browse_right_eventbox, 
				RADIAL_BUTTON_WIDTH, RADIAL_BUTTON_HEIGHT);
	radial_button_right_image = gtk_image_new_from_file
		("/usr/share/gpscamera/pictures/gpscam_radial_pressed_right.png");
	gtk_container_add (GTK_CONTAINER (camerawindow->radial_browse_right_eventbox), 
				radial_button_right_image);
	gtk_fixed_put(GTK_FIXED(mainview), 
			camerawindow->radial_browse_right_eventbox, 494, 117);

	camerawindow->radial_snapshot_eventbox = gtk_event_box_new();
	gtk_widget_set_size_request(camerawindow->radial_snapshot_eventbox, 
				RADIAL_BUTTON_WIDTH, RADIAL_BUTTON_HEIGHT);
	radial_button_image = gtk_image_new_from_file
	("/usr/share/gpscamera/pictures/gpscam_radial_unpressed_snapshot.png");
	gtk_container_add (GTK_CONTAINER (camerawindow->radial_snapshot_eventbox), 
				radial_button_image);
	g_signal_connect (G_OBJECT (camerawindow->radial_snapshot_eventbox),  
				"button_press_event",
	                      	G_CALLBACK (gpscamera_activate_state_snapshot),
	                      	camerawindow);
	gtk_fixed_put(GTK_FIXED(mainview), camerawindow->radial_snapshot_eventbox, 
				494, 117);

	camerawindow->statusbox = gtk_fixed_new();
	gtk_widget_set_size_request(camerawindow->statusbox, 
				STATUSBOX_WIDTH, STATUSBOX_WIDTH);
	statusbox_background = gtk_image_new_from_file
		("/usr/share/gpscamera/pictures/gpscam_status_background.png");
	gtk_container_add(GTK_CONTAINER(camerawindow->statusbox), 
				statusbox_background);
	gtk_fixed_put(GTK_FIXED(mainview), camerawindow->statusbox, 494, 290);

	camerawindow->gps_icon_off = gtk_image_new_from_file
			("/usr/share/gpscamera/pictures/icon_GPS_off.png");
	gtk_fixed_put(GTK_FIXED(mainview), camerawindow->gps_icon_off, 500, 290);
	camerawindow->gps_icon_on = gtk_image_new_from_file
			("/usr/share/gpscamera/pictures/icon_GPS_on.png");
	gtk_fixed_put(GTK_FIXED(mainview), camerawindow->gps_icon_on, 500, 290);

	camerawindow->label_gps_on = gtk_label_new(_("GPS ON"));
	gtk_fixed_put(GTK_FIXED(mainview), camerawindow->label_gps_on, 530, 290);
	camerawindow->label_gps_off = gtk_label_new(_("GPS OFF"));
	gtk_fixed_put(GTK_FIXED(mainview), camerawindow->label_gps_off, 530, 290);
	camerawindow->label_photo_number = gtk_label_new(_(""));
	gtk_fixed_put(GTK_FIXED(mainview), camerawindow->label_photo_number, 
						530, 290);
	
	camerawindow->hbox_delete = gtk_event_box_new();
	gtk_widget_set_size_request(camerawindow->hbox_delete, 
			BROWSE_MODE_BUTTON_WIDTH, BROWSE_MODE_BUTTON_HEIGHT);
	delete_button_image = gtk_image_new_from_file
		("/usr/share/gpscamera/pictures/gpscam_trash_unpressed.png");
	gtk_container_add(GTK_CONTAINER(camerawindow->hbox_delete), 
							delete_button_image);
	g_signal_connect (G_OBJECT (camerawindow->hbox_delete),  
				"button_press_event",
	                      	G_CALLBACK (gpscamera_activate_action_delete),
	                      	camerawindow);
	gtk_fixed_put(GTK_FIXED(mainview), camerawindow->hbox_delete, 491, 326);

	camerawindow->hbox_delete2 = gtk_event_box_new();
	gtk_widget_set_size_request(camerawindow->hbox_delete2, 
			BROWSE_MODE_BUTTON_WIDTH, BROWSE_MODE_BUTTON_HEIGHT);
	delete_button_image2 = gtk_image_new_from_file
			("/usr/share/gpscamera/pictures/gpscam_trash_pressed.png");
	gtk_container_add(GTK_CONTAINER(camerawindow->hbox_delete2), 
						delete_button_image2);
	gtk_fixed_put(GTK_FIXED(mainview), camerawindow->hbox_delete2, 491, 326);

	camerawindow->hbox_upload = gtk_event_box_new();
	gtk_widget_set_size_request(camerawindow->hbox_upload, 
			BROWSE_MODE_BUTTON_WIDTH, BROWSE_MODE_BUTTON_HEIGHT);
	upload_button_image = gtk_image_new_from_file
		("/usr/share/gpscamera/pictures/gpscam_upload_unpressed.png");
	gtk_container_add(GTK_CONTAINER(camerawindow->hbox_upload), 
						upload_button_image);
	g_signal_connect (G_OBJECT (camerawindow->hbox_upload),  
				"button_press_event",
	         	        G_CALLBACK (gpscamera_activate_action_upload),
	                      	camerawindow);
	gtk_fixed_put(GTK_FIXED(mainview), camerawindow->hbox_upload, 572, 326);

	camerawindow->hbox_upload2= gtk_event_box_new();
	gtk_widget_set_size_request(camerawindow->hbox_upload2, 
			BROWSE_MODE_BUTTON_WIDTH, BROWSE_MODE_BUTTON_HEIGHT);
	upload_button_image2 = gtk_image_new_from_file
		("/usr/share/gpscamera/pictures/gpscam_upload_pressed.png");
	gtk_container_add(GTK_CONTAINER(camerawindow->hbox_upload2), 
						upload_button_image2);
	gtk_fixed_put(GTK_FIXED(mainview), camerawindow->hbox_upload2, 572, 326);

	camerawindow->idlebox = gtk_vbox_new(FALSE,0);	
	camerawindow->cameradisplay = gpscamera_widget_create();
	
	gtk_widget_set_size_request(camerawindow->cameradisplay, 
					DISPLAY_WIDTH, DISPLAY_HEIGHT);
	camerawindow->camerabox = gtk_alignment_new(0,0,1,1);
	gtk_alignment_set_padding(GTK_ALIGNMENT(camerawindow->camerabox),
			                                13,13,0,7);
	gtk_container_add(GTK_CONTAINER(camerawindow->camerabox), 
					camerawindow->cameradisplay);	
	gtk_box_pack_start(GTK_BOX(camerawindow->idlebox), camerawindow->camerabox, 
						TRUE, TRUE, 0);
	gtk_fixed_put(GTK_FIXED(mainview), camerawindow->idlebox, 21, 23);	

	gtk_widget_show(camerawindow->idlebox);

	camerawindow->image_event_box = gtk_event_box_new();
	gtk_widget_set_size_request(camerawindow->image_event_box, 
					DISPLAY_WIDTH, DISPLAY_HEIGHT);
	gtk_widget_add_events(camerawindow->image_event_box, GDK_KEY_PRESS_MASK |
				   GDK_KEY_RELEASE_MASK | GDK_ENTER_NOTIFY_MASK | 
				   GDK_LEAVE_NOTIFY_MASK);
	g_object_set(camerawindow->image_event_box, "can-focus", TRUE, NULL);
	

	camerawindow->imagedisplay = gtk_image_new_from_file
		("/usr/share/gpscamera/pictures/gpscam_display_background.png");
	gtk_container_add(GTK_CONTAINER(camerawindow->image_event_box), 
						camerawindow->imagedisplay);
	gtk_fixed_put(GTK_FIXED(mainview), camerawindow->image_event_box, 21, 36);
					
	osso_log(LOG_DEBUG, "End Function %s \n", __FUNCTION__);
	return mainview;

}



/**
 This function launches the dialog to specify the file name & description 
 to be uploaded.
 @param details is the pointer to the setData structure.
 @param camerawindow is the pointer to the CameraView structure.
 @param image_uri is the gchar pointer to the image path to be uploaded.
 @return the created dialog a GtkWidget.
*/
static GtkWidget *launch_upload_details_dialog(CameraView * camerawindow,
					       const gchar * image_path)
{
	GtkWidget *dialog = NULL;
	GtkWidget *vbox = NULL;
	GtkWidget *dialog_background = NULL;
	GtkWidget *dialog_image = NULL;
	GtkWidget *label_desc = NULL;
	GtkWidget *label_title = NULL;
	GtkWidget *scrolledwindow = NULL;
	GtkWidget *ok_button = NULL;
	GtkWidget *cancel_button = NULL;
	
	dialog = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(dialog), (_("Image details")));
	gtk_widget_set_size_request(GTK_WIDGET(dialog),
				    DIALOG_WIDTH, DIALOG_HEIGHT);
	
	vbox = GTK_DIALOG(dialog)->vbox;
	gtk_box_set_spacing(GTK_BOX(vbox), 24);

	dialog_background = gtk_fixed_new();
	dialog_image = gtk_image_new_from_file
		("/usr/share/gpscamera/pictures/gpscam_dialog_background.png");
	gtk_container_add(GTK_CONTAINER (dialog_background), dialog_image);
	gtk_container_add(GTK_CONTAINER (vbox), dialog_background);

	/*title */
	label_title = gtk_label_new(_("title"));
	gtk_misc_set_alignment(GTK_MISC(label_title), 0, 0);
	gtk_fixed_put(GTK_FIXED(dialog_background), label_title, 30, 10);
	camerawindow->title =gtk_entry_new();
	gtk_widget_set_size_request(GTK_WIDGET(camerawindow->title),250, 30);
	gtk_fixed_put(GTK_FIXED(dialog_background), camerawindow->title, 80, 10);
	
	/*description */
	label_desc = gtk_label_new(_("description"));
	gtk_misc_set_alignment(GTK_MISC(label_desc), 0, 0);
	gtk_fixed_put(GTK_FIXED(dialog_background), label_desc, 30, 40);

	/* description text view */
	scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_set_size_request(GTK_WIDGET(scrolledwindow),300, 70);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow),
				       GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_scrolled_window_set_shadow_type((GtkScrolledWindow *)
					    scrolledwindow, GTK_SHADOW_ETCHED_IN);
	
	camerawindow->desc =gtk_text_view_new();
	gtk_container_add(GTK_CONTAINER(scrolledwindow), camerawindow->desc);
	gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(camerawindow->desc), 
							GTK_WRAP_WORD);
	gtk_fixed_put(GTK_FIXED(dialog_background), scrolledwindow, 30, 70);

	/*ok/cancel buttons */
	ok_button = gtk_button_new_with_label("ok");
	gtk_widget_set_size_request(GTK_WIDGET(ok_button),100, 50);
	gtk_fixed_put(GTK_FIXED(dialog_background), ok_button, 70, 140);
	g_signal_connect (G_OBJECT (ok_button),  "button_press_event",
	                      G_CALLBACK (ok_selected),
	                      dialog);

	cancel_button = gtk_button_new_with_label("cancel");
	gtk_widget_set_size_request(GTK_WIDGET(cancel_button),100, 50);
	gtk_fixed_put(GTK_FIXED(dialog_background), cancel_button, 180, 140);
	g_signal_connect (G_OBJECT (cancel_button),  "button_press_event",
	                      G_CALLBACK (cancel_selected),
	                      dialog);

	gtk_widget_show_all(dialog);

	/*ref the widgets */
	g_object_set_data_full(G_OBJECT(dialog), "image_details", 
				gtk_widget_ref(dialog),
			       (GDestroyNotify) gtk_widget_unref);
	g_object_set_data(G_OBJECT(dialog), "image_title", 
					gtk_widget_ref(camerawindow->title));
	g_object_set_data(G_OBJECT(dialog), "image_desc", 
					gtk_widget_ref(camerawindow->desc));
	return (dialog);
}

/**
 This function check set photos title and description when ok is clicked.
 @param dialog is the upload dialog GtkWidget .
 @param title is a OUT param consisting the gchar pointer to the title. 
 @param desc is a OUT param consisting the gchar pointer to the desc. 
*/
static void set_title_and_desc(GtkWidget *dialog, gchar **title, gchar **desc)
{
	GtkWidget *entry_title = NULL;
        GtkWidget *textview = NULL;
	GtkTextBuffer *buffer = NULL;
	GtkTextIter start, end;
	
	entry_title = g_object_get_data(G_OBJECT(dialog), "image_title");
	textview = g_object_get_data(G_OBJECT(dialog), "image_desc");
	buffer = gtk_text_view_get_buffer((GtkTextView *) textview);
	gtk_text_buffer_get_bounds(buffer, &start, &end);
	*desc = gtk_text_buffer_get_text(buffer, &start, &end, FALSE);
	*title = g_strdup(gtk_entry_get_text(GTK_ENTRY(entry_title)));
}

/**
 This is the callback function when ok is clicked on the image details dilaog
 @param upload_dialog is upload dialog GtkWidget .
 @param camerawindow is the pointer to the CameraView structure.
 @param image_path is the gchar pointer to the image path to be uploaded.
*/
static void
upload_details_ok(GtkWidget * upload_dialog, CameraView * camerawindow,
		 const gchar * image_path)
{
	char *title = NULL;
	char *desc = NULL;
	
	set_title_and_desc(upload_dialog, &title,&desc);
	
	gtk_widget_destroy(upload_dialog);
	
	while (gtk_events_pending())
		gtk_main_iteration();
	
	/*upload the image to flickr*/
	gpscamera_upload(camerawindow, image_path, title, desc);
	
	return;
}

/**
 This is the callback function for uploading the image.
 @param camerawindow is the pointer to the CameraView structure.
 @param image_path is the gchar pointer to the image path to be uploaded.
*/
void gpscamera_initiate_upload(CameraView * camerawindow, 
						const gchar * image_path)
{
	GtkWidget *upload_dialog = NULL;
	gint response = 0;

	if (camerawindow->gpscamera_flickr == NULL){
		return;
	}

	/*launch the image details dialog */
	upload_dialog = launch_upload_details_dialog(camerawindow, image_path);
	response = gtk_dialog_run(GTK_DIALOG(upload_dialog));
	if (response == GTK_RESPONSE_OK) {
		/*after validation uploading is initiated */
		upload_details_ok(upload_dialog, camerawindow, image_path);
	} else {
		gtk_widget_destroy(upload_dialog);
	}
	return;
}

/**
 This function launches the www page of the flickr.

*/
static void on_link_button_released()
{
	osso_log(LOG_DEBUG, "Start Function-- %s --\n", __FUNCTION__);

	hildon_uri_open ("http://www.flickr.com/auth-72157601428906274 Write", 
								NULL, NULL);
	osso_log(LOG_DEBUG, "End Function-- %s --\n", __FUNCTION__);
	return;
}
/**
 This is the function that create login dialog.
 @param settings is the pointer to the CameraLoginSettings structure.
 @param mainwindow is window where dialog shows.
*/
void gpscamera_login_dialog_create(CameraLoginSettings * settings, 
						GtkWidget * mainwindow)
{
	GtkWidget *dialog_vbox = NULL;
	GtkWidget *dialog_background = NULL;
	GtkWidget *dialog_image = NULL;
	GtkWidget *label = NULL;
	GtkWidget *url_box = NULL;
	GtkWidget *url_label = NULL;
	GtkWidget *ok_button = NULL;
	GtkWidget *cancel_button = NULL;
	
	osso_log(LOG_DEBUG, "Start Function %s \n", __FUNCTION__);
	g_return_if_fail(settings != NULL);

	
	settings->login_dialog = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(settings->login_dialog), 
						(_("Login to Flickr")));
	gtk_widget_set_size_request(GTK_WIDGET(settings->login_dialog),
				    DIALOG_WIDTH, DIALOG_HEIGHT);
	gtk_dialog_set_has_separator(GTK_DIALOG(settings->login_dialog), TRUE);
	gtk_window_set_transient_for(GTK_WINDOW(settings->login_dialog), 
							GTK_WINDOW(mainwindow));


	dialog_vbox = GTK_DIALOG(settings->login_dialog)->vbox;
	dialog_background = gtk_fixed_new();
	dialog_image = gtk_image_new_from_file
		("/usr/share/gpscamera/pictures/gpscam_dialog_background.png");
	gtk_container_add(GTK_CONTAINER (dialog_background), dialog_image);
	gtk_container_add(GTK_CONTAINER (dialog_vbox), dialog_background);
		
	label = gtk_label_new ("Login to Flickr before uploading!");
	gtk_fixed_put(GTK_FIXED(dialog_background), label, 30, 10);
	label = gtk_label_new ("You need mini-token for login!" );		
	gtk_fixed_put(GTK_FIXED(dialog_background), label, 30, 40);
		
	/* The url label */
	url_box = gtk_event_box_new ();
        g_signal_connect (G_OBJECT (url_box), "button-release-event", 
				(gpointer) on_link_button_released, NULL);
	gtk_fixed_put(GTK_FIXED(dialog_background), url_box, 30, 80);
	url_label = gtk_label_new (NULL);
	gtk_misc_set_alignment (GTK_MISC (url_label), 0.5, 0.1);
	gtk_label_set_markup (GTK_LABEL(url_label),
	 "<span underline=\"single\" foreground=\"blue\">Get mini-token</span>");
	gtk_container_add (GTK_CONTAINER (url_box), url_label);	

	settings->minitoken = gtk_entry_new ();
	gtk_entry_set_max_length(settings->minitoken, 9);
	gtk_fixed_put(GTK_FIXED(dialog_background), settings->minitoken, 180, 80);
	

	/*ok/cancel buttons */
	ok_button = gtk_button_new_with_label("ok");
	gtk_widget_set_size_request(GTK_WIDGET(ok_button),100, 50);
	gtk_fixed_put(GTK_FIXED(dialog_background), ok_button, 70, 140);
	g_signal_connect (G_OBJECT (ok_button),  "button_press_event",
	                      G_CALLBACK (ok_selected),
	                      settings->login_dialog);

	cancel_button = gtk_button_new_with_label("cancel");
	gtk_widget_set_size_request(GTK_WIDGET(cancel_button),100, 50);
	gtk_fixed_put(GTK_FIXED(dialog_background), cancel_button, 180, 140);
	g_signal_connect (G_OBJECT (cancel_button),  "button_press_event",
	                      G_CALLBACK (cancel_selected),
	                      settings->login_dialog);
	
	gtk_widget_show_all(settings->login_dialog);
	
	osso_log(LOG_DEBUG, "End Function %s \n", __FUNCTION__);
	return;
}


/**
 This is the function that create delete dialog.
 @param mainwindow is window where dialog shows.
*/
GtkWidget* gpscamera_delete_dialog_create(GtkWidget * mainwindow)
{
	GtkWidget *dialog = NULL;	
	GtkWidget *dialog_vbox = NULL;
	GtkWidget *dialog_background = NULL;
	GtkWidget *dialog_image = NULL;
	GtkWidget *label = NULL;
	GtkWidget *ok_button = NULL;
	GtkWidget *cancel_button = NULL;
	
	osso_log(LOG_DEBUG, "Start Function %s \n", __FUNCTION__);
	
	dialog = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(dialog), (_("Delete file")));
	gtk_widget_set_size_request(GTK_WIDGET(dialog),
				    DIALOG_WIDTH, DIALOG_HEIGHT2);
	
	dialog_vbox = GTK_DIALOG(dialog)->vbox;
	dialog_background = gtk_fixed_new();
	dialog_image = gtk_image_new_from_file
		("/usr/share/gpscamera/pictures/gpscam_dialog_background.png");
	gtk_container_add(GTK_CONTAINER (dialog_background), dialog_image);
	gtk_container_add(GTK_CONTAINER (dialog_vbox), dialog_background);
		
	label = gtk_label_new ("Do you really want detete");
	gtk_fixed_put(GTK_FIXED(dialog_background), label, 30, 10);
	label = gtk_label_new("this file?");		
	gtk_fixed_put(GTK_FIXED(dialog_background), label, 30, 40);
		
	/*ok/cancel buttons */
	ok_button = gtk_button_new_with_label("ok");
	gtk_widget_set_size_request(GTK_WIDGET(ok_button),100, 50);
	gtk_fixed_put(GTK_FIXED(dialog_background), ok_button, 70, 100);
	g_signal_connect (G_OBJECT (ok_button),  "button_press_event",
	                      G_CALLBACK (ok_selected),
	                      dialog);

	cancel_button = gtk_button_new_with_label("cancel");
	gtk_widget_set_size_request(GTK_WIDGET(cancel_button),100, 50);
	gtk_fixed_put(GTK_FIXED(dialog_background), cancel_button, 180, 100);
	g_signal_connect (G_OBJECT (cancel_button),  "button_press_event",
	                      G_CALLBACK (cancel_selected),
	                      dialog);

	
	gtk_widget_show_all(dialog);
	
	osso_log(LOG_DEBUG, "End Function %s \n", __FUNCTION__);
	return (dialog);
}
/**
 This function launches the www page of the flickr.

*/
static void on_link_button_released2()
{	
	osso_log(LOG_DEBUG, "Start Function-- %s --\n", __FUNCTION__);

	hildon_uri_open ("http://www.flickr.com/account/uploadbyemail/", 
								NULL, NULL);
	osso_log(LOG_DEBUG, "End Function-- %s --\n", __FUNCTION__);
	return;
}

/**
 This is the function that create uploading way dialog.
 @param mainwindow is window where dialog shows.
*/
GtkWidget * gpscamera_select_uploading_way_dialog(CameraView *camerawindow)
{
	GtkWidget* dialog = NULL;
	GtkWidget *dialog_vbox = NULL;
	GtkWidget *dialog_background = NULL;
	GtkWidget *dialog_image = NULL;
	GtkWidget *label = NULL;
	GtkWidget *url_box = NULL;
	GtkWidget *url_label = NULL;
	GtkWidget* ok_button = NULL;
	GtkWidget* cancel_button = NULL;

	osso_log(LOG_DEBUG, "Start Function %s \n", __FUNCTION__);

	dialog = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(dialog), (_("Upload")));
	gtk_widget_set_size_request(GTK_WIDGET(dialog),
				    DIALOG_WIDTH, DIALOG_HEIGHT);

	dialog_vbox = GTK_DIALOG(dialog)->vbox;
	dialog_background = gtk_fixed_new();
	dialog_image = gtk_image_new_from_file
		("/usr/share/gpscamera/pictures/gpscam_dialog_background.png");
	gtk_container_add(GTK_CONTAINER (dialog_background), dialog_image);
	gtk_container_add(GTK_CONTAINER (dialog_vbox), dialog_background);

	/*Create new label*/
	label =gtk_label_new("How do you want upload photo:");
	gtk_fixed_put(GTK_FIXED(dialog_background), label, 30, 10);

	/*Create radio buttons*/
	camerawindow->radio[0] = gtk_radio_button_new_with_label
					(NULL, "Mini-token (for GPS photos)");
	gtk_fixed_put(GTK_FIXED(dialog_background), camerawindow->radio[0], 30, 40);
	camerawindow->radio[1] = gtk_radio_button_new_with_label
		(gtk_radio_button_get_group(GTK_RADIO_BUTTON
					(camerawindow->radio[0])), "Email");
	gtk_fixed_put(GTK_FIXED(dialog_background), camerawindow->radio[1], 30, 80);
		
	/* The url label */
	url_box = gtk_event_box_new ();
        g_signal_connect (G_OBJECT (url_box), "button-release-event", 
				(gpointer) on_link_button_released2, NULL);
	gtk_fixed_put(GTK_FIXED(dialog_background), url_box, 130, 80);
	url_label = gtk_label_new (NULL);
	gtk_misc_set_alignment (GTK_MISC (url_label), 0.5, 0.1);	
	gtk_label_set_markup (GTK_LABEL(url_label), 
	"<span underline=\"single\" foreground=\"blue\">Get your Flickr email</span>");
	gtk_container_add (GTK_CONTAINER (url_box), url_label);	
	
	//label = gtk_label_new ("if you don't know it." );		
	//gtk_fixed_put(GTK_FIXED(dialog_background), label, 130, 110);


	/*ok/cancel buttons */
	ok_button = gtk_button_new_with_label("ok");
	gtk_widget_set_size_request(GTK_WIDGET(ok_button),100, 50);
	gtk_fixed_put(GTK_FIXED(dialog_background), ok_button, 70, 140);
	g_signal_connect (G_OBJECT (ok_button),  "button_press_event",
	                      G_CALLBACK (ok_selected),
	                      dialog);

	cancel_button = gtk_button_new_with_label("cancel");
	gtk_widget_set_size_request(GTK_WIDGET(cancel_button),100, 50);
	gtk_fixed_put(GTK_FIXED(dialog_background), cancel_button, 180, 140);
	g_signal_connect (G_OBJECT (cancel_button),  "button_press_event",
	                      G_CALLBACK (cancel_selected),
	                      dialog);

	gtk_widget_show_all(dialog);

	osso_log(LOG_DEBUG, "End Function %s \n", __FUNCTION__);
	return (dialog);
}
/**
 This function launches the www page of GPS Camera's home page.

*/
static void link_help()
{
	
	osso_log(LOG_DEBUG, "Start Function-- %s --\n", __FUNCTION__);

	hildon_uri_open ("http://gps-camera.garage.maemo.org", NULL, NULL);
	
	osso_log(LOG_DEBUG, "End Function-- %s --\n", __FUNCTION__);
	return;
}

GtkWidget *camera_ui_create_menu(CameraMenu * menu)
{

	osso_log(LOG_DEBUG, "Start Function %s \n", __FUNCTION__);

	g_return_val_if_fail(menu != NULL, NULL);

	menu->self = gtk_menu_new();
	gtk_widget_set_size_request(GTK_WIDGET(menu->self), 150, -1);

	menu->mhelp = gtk_menu_item_new_with_label(_("Help"));
	gtk_menu_append(GTK_MENU(menu->self), menu->mhelp);
	 g_signal_connect (G_OBJECT (menu->mhelp), "button-release-event", 
					(gpointer) link_help, NULL);

	menu->mexit = gtk_menu_item_new_with_label(_("Close"));
	gtk_menu_append(GTK_MENU(menu->self), menu->mexit);
	g_signal_connect(G_OBJECT(menu->mexit), "activate",
                    G_CALLBACK(gtk_main_quit), NULL);
	
	osso_log(LOG_DEBUG, "End Function %s \n", __FUNCTION__);
	return menu->self;
}




