/**
 * gps-camera-states.h
 * Copyright (C) 2007 Sanna Salmijarvi (ssalmija@gmail.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */ 

#ifndef GPS_CAMERA_STATES_H
#define GPS_CAMERA_STATES_H

#include <gtk/gtk.h>
#include <glib.h>

#include "gps-camera-controller.h" 

/**
  This enumeration is used for referring
  to the camera states .
*/
                                                                                                                            
enum
{
        GPSCAMERA_STATE_GALLERY,
	GPSCAMERA_STATE_SNAPSHOT_TAKEN,
	GPSCAMERA_STATE_BROWSE_LEFT,
	GPSCAMERA_STATE_BROWSE_RIGHT,
	GPSCAMERA_STATE_CAMERA,
	GPSCAMERA_STATE_DELETE,
	GPSCAMERA_STATE_UPLOAD,
	GPSCAMERA_STATE_GPS_ON,
	GPSCAMERA_STATE_GPS_OFF
}GpsCameraState;


/**
  This is a  function called for changing
  ui state depending on camera states.	
                                                                                                                             
  @param CameraView struct pointer.
  @return  none
 */
gboolean gpscamera_states_check(CameraView *camerawindow);

#endif
