/**
 * gps-camera-states.c
 * Copyright (C) 2007 Sanna Salmijarvi (ssalmija@gmail.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */ 

#include "gps-camera-states.h"
#include "gps-camera-controller.h"
#include "gps-camera-gps.h"


/**
  This is a  function called to set the 
  ui in recording state.
                                                                                                                             
  @param CameraView struct pointer.
  @return  TRUE on success FALSE on 
  any error
 */

static gboolean helper_function_ui(CameraView * camerawindow);


/**
  This is a  function called to set the 
  ui in recording state.
                                                                                                                             
  @param CameraView struct pointer.
  @return  TRUE on success FALSE on 
  any error
 */
static gboolean gpscamera_state_gallery_set(CameraView * camerawindow);


/**
  This is a  function called for uploading
  images/video .	
                                                                                                                             
  @param CameraView struct pointer.
  @return  TRUE on success FALSE on 
  any error
 */
static gboolean gpscamera_action_delete(CameraView * camerawindow);

/**
  Function to flush all gtk pending events before proceeding

  @param none
  @return none
*/
static void gpscamera_flush_gtk_events(void);
	

static void gpscamera_flush_gtk_events(void)
{
	osso_log(LOG_DEBUG, "Start Function-- %s --\n", __FUNCTION__);

	while (gtk_events_pending()) {
		gtk_main_iteration();
	}

	osso_log(LOG_DEBUG, "End Function-- %s --\n", __FUNCTION__);
	return;
}

static gboolean gpscamera_state_camera_set(CameraView * camerawindow)
{
	gboolean ret_val = TRUE;
	gchar *photo_path = NULL;

	osso_log(LOG_DEBUG, "Start Function-- %s --\n", __FUNCTION__);

	g_return_val_if_fail(camerawindow != NULL, FALSE);

	if(helper_function_ui(camerawindow) == FALSE) {
		return FALSE;
	}

		if (FALSE == gpscamera_handler_check(camerawindow)) {
			return FALSE;
		}
			
		gtk_widget_show(camerawindow->camerabox);
		gtk_widget_show(camerawindow->cameradisplay);
		gtk_widget_show(camerawindow->camera_mode_eventbox);
		gtk_widget_show(camerawindow->radial_snapshot_eventbox);
	
	if(camerawindow->gps == FALSE){
		gtk_widget_show(camerawindow->gps_icon_off);
		gtk_widget_show(camerawindow->label_gps_off);
	}

	if(camerawindow->gps == TRUE){
		gtk_widget_show(camerawindow->gps_icon_on);
		gtk_widget_show(camerawindow->label_gps_on);		
	}
	
	if(camerawindow->photos!=NULL){
		do{
			photo_path = g_list_nth_data(camerawindow->photos, 
						camerawindow->photo_amount);
			camerawindow->photos = g_list_remove(camerawindow->photos,
                                                         photo_path);
			camerawindow->photo_amount=camerawindow->photo_amount-1;
		}while(camerawindow->photo_amount>=0);
	}
	camerawindow->counter = 0;
	
	osso_log(LOG_DEBUG, "End Function-- %s --\n", __FUNCTION__);

	return ret_val;

}

static gboolean helper_function_ui(CameraView * camerawindow)	
{
	gboolean ret_val = TRUE;

	osso_log(LOG_DEBUG, "Start Function-- %s --\n", __FUNCTION__);

	g_return_val_if_fail(camerawindow != NULL,FALSE);
	
	gtk_widget_hide(camerawindow->imagedisplay);
	gtk_widget_hide(camerawindow->image_event_box);
	gtk_widget_hide(camerawindow->browse_mode_eventbox);
	gtk_widget_hide(camerawindow->radial_snapshot_eventbox2);
	gtk_widget_hide(camerawindow->radial_browse_eventbox);
	gtk_widget_hide(camerawindow->radial_browse_left_eventbox);
	gtk_widget_hide(camerawindow->radial_browse_right_eventbox);
	gtk_widget_hide(camerawindow->hbox_delete);
	gtk_widget_hide(camerawindow->hbox_upload);
	gtk_widget_hide(camerawindow->hbox_delete2);
	gtk_widget_hide(camerawindow->hbox_upload2);
	gtk_widget_hide(camerawindow->gps_icon_on);
	gtk_widget_hide(camerawindow->gps_icon_off);
	gtk_widget_hide(camerawindow->label_gps_off);
	gtk_widget_hide(camerawindow->label_gps_on);
	gtk_widget_hide(camerawindow->label_photo_number);
	
	gpscamera_flush_gtk_events();

	osso_log(LOG_DEBUG, "End Function-- %s --\n", __FUNCTION__);

	return ret_val;
}


static gboolean gpscamera_state_gallery_set(CameraView * camerawindow)
{
	gboolean ret_val = TRUE;
	GtkWidget *camera_view = NULL;

	osso_log(LOG_DEBUG, "Start Function-- %s --\n", __FUNCTION__);
	g_return_val_if_fail(camerawindow != NULL,FALSE);

	camerawindow->model_append = FALSE;
	
	gtk_widget_hide(camerawindow->camera_mode_eventbox);	
	gtk_widget_hide(camerawindow->label_gps_off);
	gtk_widget_hide(camerawindow->label_gps_on);
	gtk_widget_hide(camerawindow->gps_icon_off);
	gtk_widget_hide(camerawindow->gps_icon_on);		
	gtk_widget_hide(camerawindow->camerabox);
	gtk_widget_hide(camerawindow->cameradisplay);
		
	gtk_widget_show(camerawindow->image_event_box);
	gtk_widget_show(camerawindow->imagedisplay);
	gtk_widget_show(camerawindow->browse_mode_eventbox);
	gtk_widget_show(camerawindow->radial_browse_eventbox);
	gtk_widget_show(camerawindow->hbox_delete);
	gtk_widget_show(camerawindow->hbox_upload);

	gpscamera_flush_gtk_events();

	gpscamera_gallery_view_launch(camerawindow);
	
	osso_log(LOG_DEBUG, "End Function-- %s --\n", __FUNCTION__);

	return ret_val;
}

static gboolean gpscamera_action_delete(CameraView * camerawindow)
{
	gboolean ret_val = TRUE;
	
	osso_log(LOG_DEBUG, "Start Function-- %s --\n", __FUNCTION__);
	
	g_return_val_if_fail(camerawindow != NULL,FALSE);
	
	gtk_widget_show(camerawindow->hbox_delete2);
	
	gpscamera_gallery_view_delete_file(camerawindow);

	gtk_widget_hide(camerawindow->hbox_delete2);
	
	osso_log(LOG_DEBUG, "End Function-- %s --\n", __FUNCTION__);

	return ret_val;
}

static gboolean gpscamera_gps_status_set(CameraView * camerawindow)
{
	gboolean ret_val = TRUE;
	GtkWidget *camera_view = NULL;

	osso_log(LOG_DEBUG, "Start Function-- %s --\n", __FUNCTION__);
	g_return_val_if_fail(camerawindow != NULL,FALSE);
		gtk_widget_hide(camerawindow->gps_icon_off);
		gtk_widget_show(camerawindow->gps_icon_on);	
		gtk_widget_hide(camerawindow->label_gps_off);
		gtk_widget_show(camerawindow->label_gps_on);		
	
	camerawindow->current_state=GPSCAMERA_STATE_CAMERA;
	osso_log(LOG_DEBUG, "End Function-- %s --\n", __FUNCTION__);

	return ret_val;
}

static gboolean gpscamera_gps_status_off_set(CameraView * camerawindow)
{
	gboolean ret_val = TRUE;
	GtkWidget *camera_view = NULL;

	osso_log(LOG_DEBUG, "Start Function-- %s --\n", __FUNCTION__);
	g_return_val_if_fail(camerawindow != NULL,FALSE);
	
		gtk_widget_hide(camerawindow->gps_icon_on);
		gtk_widget_show(camerawindow->gps_icon_off);	
		gtk_widget_hide(camerawindow->label_gps_on);
		gtk_widget_show(camerawindow->label_gps_off);		

	camerawindow->current_state=GPSCAMERA_STATE_CAMERA;
	osso_log(LOG_DEBUG, "End Function-- %s --\n", __FUNCTION__);

	return ret_val;
}


gboolean gpscamera_states_check(CameraView * camerawindow)
{
	gboolean ret_val = TRUE;

	osso_log(LOG_DEBUG, "Start Function-- %s --\n", __FUNCTION__);

	g_return_val_if_fail(camerawindow != NULL,FALSE);
	
	switch (camerawindow->current_state) {

	
	case GPSCAMERA_STATE_GALLERY:	
		ret_val = gpscamera_state_gallery_set(camerawindow);
		break;		
	
	case GPSCAMERA_STATE_CAMERA:
		ret_val = gpscamera_state_camera_set(camerawindow);
		break;
	
	case GPSCAMERA_STATE_DELETE:
		ret_val = gpscamera_action_delete(camerawindow);
		break;

	case GPSCAMERA_STATE_UPLOAD:
		ret_val = gpscamera_action_upload(camerawindow);
		break;

	case GPSCAMERA_STATE_GPS_ON:
		ret_val = gpscamera_gps_status_set(camerawindow);
		break;
	case GPSCAMERA_STATE_GPS_OFF:
		ret_val = gpscamera_gps_status_off_set(camerawindow);
		break;

	default:
		osso_log(LOG_WARNING, "No value set for camera state \n");
		break;
	}

	osso_log(LOG_DEBUG, "End Function-- %s --\n", __FUNCTION__);
	return ret_val;
}
