/**
 * gps-camera-controller.c
 * Copyright (C) 2007 Sanna Salmijarvi (ssalmija@gmail.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */

#include <glib.h>

#include <location/location-gps-device.h>
#include <location/location-gpsd-control.h>
#include "gps-camera-gps.h"
#include "gps-camera-states.h"

static GpsCameraCoordinates coords;

/*void
location_changed (LocationGPSDevice *device,
		  gpointer           userdata)
{
	
	g_print ("Latitude: %.2f\nLongitude: %.2f\nAltitude: %.2f\n Mode: %d\n",
		 device->fix->latitude, device->fix->longitude,
		 device->fix->altitude, device->fix->mode);
}*/

gboolean set_update_location(CameraView  * camerawindow)
{

	
	osso_log(LOG_DEBUG, "Start Function-- %s --\n", __FUNCTION__);
	g_return_val_if_fail(camerawindow != NULL,FALSE);
	
	if(camerawindow->device->fix->mode == 3){
		g_print ("Lat: %.2f, Long: %.2f, Alt: %.2f\n, mode:%d\n",
		 camerawindow->device->fix->latitude, camerawindow->device->fix->longitude,
		 camerawindow->device->fix->altitude, camerawindow->device->fix->mode);
		camerawindow->gps=TRUE;
		coords.lat = camerawindow->device->fix->latitude;
		coords.lng = camerawindow->device->fix->longitude;
		if(camerawindow->current_state==GPSCAMERA_STATE_CAMERA){
			camerawindow->current_state = GPSCAMERA_STATE_GPS_ON;
			gpscamera_states_check(camerawindow);
		}
	}else{
		camerawindow->gps=FALSE;
		if(camerawindow->current_state==GPSCAMERA_STATE_CAMERA){
			camerawindow->current_state = GPSCAMERA_STATE_GPS_OFF;
			gpscamera_states_check(camerawindow);
		}
	
	}

	camerawindow->device->fix->mode=0;

	return TRUE;
}


/*Ask gps-coordinates*/
GpsCameraCoordinates gpscamera_ask_position(CameraView *camerawindow){

	osso_log(LOG_DEBUG, "Start Function %s \n", __FUNCTION__);
        g_return_if_fail(camerawindow != NULL);
	if(camerawindow->device->fix->mode == 3){
		printf("lat %f, lng %f\n", coords.lat, coords.lng);
		
	} else {
		coords.lat =0.0;
		coords.lng =0.0;
	}
	osso_log(LOG_DEBUG, "End Function %s \n", __FUNCTION__);

	return coords;
	
}
