/**
 * gps-camera-gallery-view.h
 * Copyright (C) 2007 Sanna Salmijärvi (ssalmija@gmail.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */ 

#ifndef GPS_CAMERA_GALLERY_VIEW_H
#define GPS_CAMERA_GALLERY_VIEW_H

#include <gtk/gtk.h>

#include "gps-camera-controller.h"

/**
  Function to append model.
  @param camerawindow is the pointer to the CameraView structure.
  @param photo_path is the pointer to the image files dir.
  @return none.
 */
void
gpscamera_view_append_model(CameraView *camerawindow,
                                    gchar *photo_path);


/**
  Function called to append the gallery view .
  @param camerawindow is the pointer to the CameraView structure.
  @return none.
 */
gboolean gpscamera_gallery_view_launch(CameraView * camerawindow);

/**
  Function called to select next image for list .
  @param camerawindow is the pointer to the CameraView structure.
  @return none.
 */
void gpscamera_gallery_view_image_next(CameraView * camerawindow);
/**
  Function called to select previous image for list .
  @param camerawindow is the pointer to the CameraView structure.
  @return none.
 */
void gpscamera_gallery_view_image_prev(CameraView * camerawindow);

/**
  Function called to deleting image.
  @param camerawindow is the pointer to the CameraView structure.
  @return none.
 */
void gpscamera_gallery_view_delete_file(CameraView * camerawindow);

/**
  Function to send an image as attachment.
  @param camerawindow is the pointer to the CameraView structure.
  @return none.
 */
void
gpscamera_send_mail(CameraView * camerawindow);



#endif
