/* 
 *
 * gps-camera-flickr_internal.h - Flickr internal API calls
 * Copyright (C) 2007 Sanna Salmijarvi (ssalmija@gmail.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */

#include <libxml/tree.h>
#include <libxml/xpath.h>

#include <curl/curl.h>
#include <curl/types.h>
#include <curl/easy.h>


#if defined (OFFLINE) && defined (CAPTURE)
#error "Cannot define both OFFLINE and CAPTURE"
#endif

/* flickcurl.c */
/* Prepare Flickr API request - GET or POST with URI parameters */
int flickcurl_prepare(flickcurl *fc, const char* method, 
					const char* parameters[][2], int count);
/* Prepare Flickr API request - POST with form-data parameters */
int flickcurl_prepare_upload(flickcurl *fc, const char* url, 
						const char* upload_field, 
						const char* upload_value, 
						const char* parameters[][2], 
						int count);

/* Invoke Flickr API at URi prepared above and get back an XML document */
xmlDocPtr flickcurl_invoke(flickcurl *fc);

/* common.c */
/* invoke an error */
void flickcurl_error(flickcurl* fc, const char *message, ...);

/* Convert a unix timestamp into an ISO string */
char* gpscamera_flickr_unixtime_to_isotime(time_t unix_time);

/* Convert a unix timestamp into an SQL timestamp string */
char* flickcurl_unixtime_to_sqltimestamp(time_t unix_time);

/* Evaluate an XPath to get the string value */
char* gpscamera_flickr_xpath_eval(flickcurl *fc, xmlXPathContextPtr xpathCtx, 
							const xmlChar* xpathExpr);

char* flickcurl_call_get_one_string_field(flickcurl* fc, const char* key, 
							const char* value, 
							const char* method, 
							const xmlChar* xpathExpr);
/* location.c */
gpscamera_flickr_location* flickcurl_build_location(flickcurl* fc, 
							xmlXPathContextPtr xpathCtx, 
							const xmlChar* xpathExpr);

/* md5.c - MD5 as hex string */
extern char* MD5_string(char *string);

/* vsnprintf.c */
extern char* my_vsnprintf(const char *message, va_list arguments);


struct flickcurl_s {
  int total_bytes;

  /* Something failed */
  int failed;

  /* Flickr API error code */
  int error_code;

  /* Flickr API error message */
  char* error_msg;
  
  int status_code;

  char** param_fields;
  char** param_values;
  int parameter_count;
  char* upload_field;
  char* upload_value;
  
  char uri[2048];

  CURL* curl_handle;
  char error_buffer[CURL_ERROR_SIZE];
  int curl_init_here;

  char* user_agent;

  /* proxy URL string or NULL for none */
  char* proxy;
  
  void* error_data;
  flickcurl_message_handler error_handler;

  char *http_accept;

  /* XML parser */
  xmlParserCtxtPtr xc;

  /* The next three fields need to be set before authenticated
   * operations can be done (in most cases).
   */ 
  char* secret; 
  char* api_key; 
  char* auth_token;

  /* API call must be signed even if 'auth_token' is NULL - flickcurl_set_sign()
   */
  int sign;

  /* Flickr API method to invoke - set by flickcurl_prepare */
  char* method;

  /* Time the last request was made */
  struct timeval last_request_time;
  
  /* Delay between HTTP requests in microseconds - default is none (0) */
  long request_delay;

  /* write = POST, else read = GET */
  int is_write;
  
  /* data to send in a request */
  void* data;
  size_t data_length;
  int data_is_xml; /* if non-0, us xmlFree(fc->data) else free(fc->data) */
  
#ifdef CAPTURE
  FILE* fh;
#endif
};
