/**
 * gps-camera-controller.h
 * Copyright (C) 2007 Sanna Salmijarvi (ssalmija@gmail.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */ 

#ifndef GPS_CAMERA_CONTROLLER_H
#define GPS_CAMERA_CONTROLLER_H

#include <glib.h>
#include <gtk/gtk.h>
#include <gnome-vfs-2.0/libgnomevfs/gnome-vfs-mime.h>
#include <hildon/hildon-program.h>
#include <libgnomevfs/gnome-vfs-volume-monitor.h>
#include <libosso.h>
#include <hildon/hildon-caption.h>
#include <libintl.h>
#include <location/location-gps-device.h>

#include "gps-camera-engine.h"
#include "gps-camera-flickr.h"
     
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#define _(String) dgettext(PACKAGE,String)
#define HILDON_LIBS "hildon-libs"
#define HILDON_COMMON_STR "hildon-common-strings"
#define HILDON_FM "hildon-fm"
#define KE_RECV "ke-recv"
#define DGETTEXT_HLIBS(String) dgettext(HILDON_LIBS, String)
#define DGETTEXT_HCS(String) dgettext(HILDON_COMMON_STR, String)
#define DGETTEXT_FM(String) dgettext(HILDON_FM, String)
#define DGETTEXT_KE(String) dgettext(KE_RECV, String)


/**
  This structure has information about the fields that are
  needed for login .
*/

typedef struct 
{
	GtkWidget *login_dialog;
	GtkWidget *minitoken;
}CameraLoginSettings;

/**
  This structure has information about all the menu items
  in the application.
*/

typedef struct 
{
	GtkWidget     *self;
	GtkWidget     *mexit ;
	GtkWidget     *mhelp ;
}CameraMenu;

/**
  This structure has information about all the ui widgets 
  in the application.
*/

typedef struct
{
	CameraMenu     *menuitem;
	HildonWindow   *uiwindow;
	HildonProgram  *program;
	GtkWidget      *camerabox;
	GtkWidget      *idlebox;
	GtkWidget      *cameradisplay ;
	GtkWidget      *imagedisplay;
	GtkWidget      *image_event_box;
	GpsCameraEngine   *engine;
	osso_context_t *context;
	gboolean 	model_append;
	gint 		current_state ;//move to
	gint 		last_state;//move to*/
	GError 		*engine_error;
	gint 		counter;
	gint		photo_amount;
	flickcurl	* gpscamera_flickr;
	CameraLoginSettings *settings; 
	GtkWidget 	*title;
	GtkWidget 	*desc;
	int 		delete_file;
	gboolean 	gps;
	GtkWidget	*main_eventbox;
	GtkWidget	*camera_mode_eventbox;
	GtkWidget	*browse_mode_eventbox;
	GtkWidget	*radial_snapshot_eventbox;
	GtkWidget	*radial_snapshot_eventbox2;
	GtkWidget	*radial_browse_eventbox;
	GtkWidget	*radial_browse_left_eventbox;
	GtkWidget	*radial_browse_right_eventbox;
	GtkWidget 	*hbox_upload;
	GtkWidget 	*hbox_upload2;
	GtkWidget 	*hbox_delete;
	GtkWidget 	*hbox_delete2;
	GtkWidget	*statusbox;
	GtkWidget 	*gps_icon;
	GtkWidget 	*gps_icon_off;
	GtkWidget 	*gps_icon_on;
	GtkWidget 	*label_gps_off;
	GtkWidget 	*label_gps_on;
	GtkWidget	*label_photo_number;
	GList		*photos;
	GtkWidget	*radio[2];
	LocationGPSDevice *device;
}CameraView;


/**
  This is a helper function which is called 
  during launch of application.
  @param context is the osso context returned while
  initializing the dbus service.
  @return none
 */
gboolean gpscamera_launch(osso_context_t* context);

/**
  Function called when capture button is pressed. 
  @param widget is the pointer to the 
  object which emitted the signal.
  @param event is the pointer to the GdkEvent structure.
  @param data is the pointer to the CameraView structure.
  @return FALSE to propogate event else TRUE.
 */
gboolean gpscamera_activate_state_snapshot(GtkWidget * widget, 
		GdkEvent * event, gpointer data);

/**
  Function called when upload button is pressed. 
  @param widget is the pointer to the 
  object which emitted the signal.
  @param event is the pointer to the GdkEvent structure.
  @param data is the pointer to the CameraView structure.
  @return FALSE to propogate event else TRUE.
 */
gboolean gpscamera_activate_action_upload(GtkWidget * widget, 
		GdkEvent * event, gpointer data);

/**
  Function called when delete button is pressed. 
  @param widget is the pointer to the 
  object which emitted the signal.
  @param event is the pointer to the GdkEvent structure.
  @param data is the pointer to the CameraView structure.
  @return FALSE to propogate event else TRUE.
 */
gboolean gpscamera_activate_action_delete(GtkWidget * widget, 
		GdkEvent * event, gpointer data);


/**
  Function called to show a infonote. 
  
  @param window is the pointer to the app window
  @param text is the pointer to the info text.
  @return none.
 */
void gpscamera_show_info_note(GtkWindow *window, const gchar *text);

/**
  Function called to check if camera is available.
  @param camerawindow is the pointer to the CameraView structure.
  @return TRUE on success else FALSE.
 */
gboolean gpscamera_handler_check(CameraView * camerawindow);


/**
  Function called to get camera handle  .
  @param camerawindow is the pointer to the CameraView structure.
  @return TRUE on success else FALSE. 
 */
gboolean gpscamera_handle_accquired(CameraView *camerawindow);

/**
  Function called to free the pipeline 
  @param engine is the pointer to the GpsCameraEngine structure.
  @return none.
 */
void gpscamera_engine_clear_engine(GpsCameraEngine *engine);
/**
  Function called when camera mode button is pressed. 
  @param widget is the pointer to the 
  object which emitted the signal.
  @param event is the pointer to the GdkEvent structure.
  @param data is the pointer to the CameraView structure.
  @return FALSE to propogate event else TRUE.
 */

gboolean gpscamera_change_snapshot_mode(GtkWidget *event_box, 
                         GdkEventButton *event, gpointer data);
/**
  Function called when browse mode button is pressed. 
  @param widget is the pointer to the 
  object which emitted the signal.
  @param event is the pointer to the GdkEvent structure.
  @param data is the pointer to the CameraView structure.
  @return FALSE to propogate event else TRUE.
 */
gboolean gpscamera_change_browse_mode(GtkWidget *event_box, 
                         GdkEventButton *event, gpointer data);
/**
  Function called when browse button is pressed. 
  @param widget is the pointer to the 
  object which emitted the signal.
  @param event is the pointer to the GdkEvent structure.
  @param data is the pointer to the CameraView structure.
  @return FALSE to propogate event else TRUE.
 */
gboolean gpscamera_activate_state_browse(GtkWidget *event_box, 
                         GdkEventButton *event, gpointer data);

/**
  Function called when cancel button of dialog is pressed. 
  @param widget is the pointer to the 
  object which emitted the signal.
  @param event is the pointer to the GdkEvent structure.
  @param dialog is the pointer to the dialog.
  */
void cancel_selected(GtkWidget * widget, 
		GdkEvent * event, gpointer dialog);
/**
  Function called when ok button of dialog is pressed. 
  @param widget is the pointer to the 
  object which emitted the signal.
  @param event is the pointer to the GdkEvent structure.
  @param dialog is the pointer to the dialog.
  */

void ok_selected(GtkWidget * widget, 
		GdkEvent * event, gpointer dialog);

gpscamera_action_upload(CameraView * camerawindow);

#endif
