/**
 *gps-camera-common.h
 * Copyright (C) 2007 Sanna Salmijarvi (ssalmija@gmail.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 ***/

#ifndef GPS_CAMERA_COMMON_H
#define GPS_CAMERA_COMMON_H

#include <libgnomevfs/gnome-vfs-utils.h>
#include <libgnomevfs/gnome-vfs-volume-monitor.h>
#include <libgnomevfs/gnome-vfs-xfer.h>
#include <libgnomevfs/gnome-vfs-file-info.h>
#include <libgnomevfs/gnome-vfs-ops.h>
#include <libgnomevfs/gnome-vfs.h>
#include <time.h>
#include <string.h>
  
#include "gps-camera-flickr.h"

#define SLASH 	 "/"
#define CAMERA	 "camera"
#define I_EXTN   ".jpg"
#define ERROR 	 5
#define BUFFSIZE 1024


typedef enum {
GPSCAMERA_DELETE_SUCCESS,
GPSCAMERA_DELETE_NO_PERM,
GPSCAMERA_FILE_NA
} DelFile;


/**
  Function gets an images file path.
  @param none.
  @return file path.
 */
gchar *gpscamera_get_file_path();;

/**
  Function to get the dir path from file path.
  @param file is the pointer to the file path. 
  @return dir name  if file is present else
  NULL.
 */
gchar* gpscamera_get_dir_from_file(const gchar* file);

/**
  Function to delete a file.
  @param path is the pointer to the file path. 
  @return gint value depending on success,failure
  and error.
 */
gint gpscamera_delete_file(const gchar* path);

gboolean gpscamera_write_gpslocation_file(gchar *file_path, gdouble lat, 
							gdouble lng);

gchar *gpscamera_get_unique_name();




#endif
