#!/usr/bin/env python2.5

import unittest

from evolution import ebook

class TestEVCardAttribute(unittest.TestCase):

    def testConstructorSucces(self):
        a = ebook.EVCardAttribute("foo", "bar")
        self.assert_(a)
        del a

    def testConstructorFails(self):
        self.assertRaises(TypeError, ebook.EVCardAttribute, "group", 4)
        self.assertRaises(TypeError, ebook.EVCardAttribute, 4, "group")

        self.assertRaises(TypeError, ebook.EVCardAttribute, "group")

    def testGroupAndName(self):
        a = ebook.EVCardAttribute("group", "name")
        self.assertEqual(a.get_group().lower(), "group")
        self.assertEqual(a.get_name().lower(), "name")

        del a

    def testSingleValued(self):
        a = ebook.EVCardAttribute("group", "name")
        a.add_value("test value")

        self.assert_(a.is_single_valued())

        val = a.get_value()
        self.assertEqual(val.lower(), "test value")

        a.remove_value("test value")

        val = a.get_value()
        self.assertEqual(val, None)

        del a

    def testMultiValues(self):
        a = ebook.EVCardAttribute("group", "name")
        a.add_value("first")
        a.add_value("second")
        a.add_value("third")
        a.add_value("fourth")

        vals = a.get_values()
        self.assertEqual(vals, ["first", "second", "third", "fourth"])

        a.remove_value("third")
        vals = a.get_values()
        self.assertEqual(vals, ["first", "second", "fourth"])

        a.remove_values()
        vals = a.get_values()
        self.assertEqual([], vals)

        del a

class TestEVCard(unittest.TestCase):

    def testCreationFromString(self):
        original_string = """BEGIN:vCard
VERSION:3.0
FN:Frank Dawson
ORG:Lotus Development Corporation
ADR;TYPE=WORK,POSTAL,PARCEL:;;6544 Battleford Drive
 ;Raleigh;NC;27613-3502;U.S.A.
TEL;TYPE=VOICE,MSG,WORK:+1-919-676-9515
TEL;TYPE=FAX,WORK:+1-919-676-9564
EMAIL;TYPE=INTERNET,PREF:Frank_Dawson@Lotus.com
EMAIL;TYPE=INTERNET:fdawson@earthlink.net
URL:http://home.earthlink.net/~fdawson
END:vCard"""

        a = ebook.EVCard(original_string)

        print a.to_string()#ebook.EVC_FORMAT_VCARD_30)

if __name__ == "__main__":
    unittest.main()
