#!/bin/sh
# Script to generate all required files for `configure' when
# starting from a fresh repository checkout.

ACLOCAL="aclocal -I m4"
AUTOCONF="autoconf"
AUTOHEADER="autoheader"
LIBTOOLIZE="libtoolize --automake"
AUTOMAKE="automake -a -c --foreign"

build () {
    echo -n "Building '$1'... "
    eval $`echo $2`
    if [ ! $? -eq 0 ]
    then
        echo "Failed!"
        exit 1
    fi
    echo "Done!"
}

# Clean up old files which could hurt otherwise.
rm -f config.cache config.log config.status

# Generate `aclocal.m4'.
rm -f aclocal.m4
build "aclocal.m4" "ACLOCAL"

# Generate `config.h.in'.
build "config.h.in" "AUTOHEADER"

# Generate `configure' from `configure.ac'.
build "configure" "AUTOCONF"

# Generate `ltmain.sh'.
#build "ltmain.sh" "LIBTOOLIZE"

# Generate `stamp-h1' and all `Makefile.in' files.
rm -f stamp-h1
build "Makefile templates" "AUTOMAKE"

echo
echo "Run './configure ; make'"
echo
