# To use the device you need to use a control-point (gupnp-universal-cp)
class UPnPCalculator:

    from easy.upnp_utils import *
    
    device_name = "Calculator"
    service_name = "Operations"

#    manufacturer = "a"
#    model_description = "b"
#    model_name =  "c"
#    model_number =  "d"
#    serial_number =  "e"
    
    @action("addition")
    @input("a:int", "b:int:")
    @output("out:int")
    def addition(self, *args, **kwargs):
        a = int(args[0])
        b = int(args[1])
        sum = a+b
        print "%i+%i=%i"%(a,b,sum)
        return {'additionResponse': {"out":sum}}
    
    @action("subtraction")
    @input("a:int", "b:int:")
    @output("out:int")
    def subtraction(self, *args, **kwargs):
        a = int(args[0])
        b = int(args[1])
        sub = a-b
        print "%i-%i=%i"%(a,b,sub)
        return {'subtractionResponse': {"out":sub}}
    
    @action("multiplication")
    @input("a:int", "b:int:")
    @output("out:int")
    def multiplication(self, *args, **kwargs):
        a = int(args[0])
        b = int(args[1])
        mult = a*b
        print "%i*%i=%i"%(a,b,mult)
        return {'multiplicationResponse': {"out":mult}}
    
    @action("divison")
    @input("a:int", "b:int:")
    @output("out:int")
    def divison(self, *args, **kwargs):
        a = int(args[0])
        b = int(args[1])
        div = a/b
        print "%i/%i=%i"%(a,b,div)
        return {'divisonResponse': {"out":div}}

from easy import upnp

calc = UPnPCalculator()
upnp.start(calc)