import time

from easy import gps_bt
from easy import ui

def update_infos(app):
    global minute_flag
    gpsdevice.get_fix()

    app['altitude']    = gpsdevice.fix.altitude
    app['latitude']    = gpsdevice.fix.latitude
    app['longitude']   = gpsdevice.fix.longitude
    app['speed']       = gpsdevice.fix.speed

    if minute_flag % 60 == 0:
        update_satellites(app)
    minute_flag += 1

    return True

def update_satellites(app):
    app['satellites'].clear()    
    for satellite in gpsdevice.satellites:
        app['satellites'].append(satellite)

def exit_callback(app):
    gpsbt.stop(context)
    ui.quit()    

app = ui.App(title='Easy Player',
                top=(ui.Entry(id='altitude',     label='Altitude(m)'),
                     ui.Entry(id='latitude',     label='Latitude(degree)'),
                     ui.Entry(id='longitude',    label='Longitude(degree)'),
                     ui.Entry(id='speed',        label='Speed(km/h)')),
             center=(ui.Table(id='satellites',   label='Satellites',
                                show_headers=False, types=(str,))))

context = gps_bt.start()
time.sleep(2)
gpsdevice = gps_bt.gps()
app.timeout_add(interval=1000, callback=update_infos)
minute_flag = 0

ui.run()