from easy import camera
from easy import ui

def start(app):
    camera.display()
    return False
    
def record(app, button):
    camera.record(app['file_name'])

def stop(app, button):
    camera.stop()

def play(app, button):
    try:
        camera.play(filename=app['file_name'])
    except:
        pass

def pause(app, button):
    camera.pause()

app = ui.App(title='Easy Camera Recorder',
                top=(ui.Entry(id='file_name', value='/home/user/rec.avi'),
                     ui.Button(id='record', label='Record', callback=record),
                     ui.Button(id='stop', label='Stop', callback=stop),
                     ui.Button(id='play', label='Play', callback=play),
                     ui.Button(id='pause', label='Pause', callback=pause)),
              center=ui.XWindow(id='xwindow'))

app.idle_add(callback=start)

camera.set_window_id(app['xwindow'].get_window_id())
ui.run()