from easy import camera
from easy import ui

def play(app, button):
    try:
        camera.play(filename=app['file_name'])
    except:
        pass
    camera.set_volume(10)

def pause(app, button):
    if not camera.is_stopped():
        camera.pause()

        if app['pause'].label == 'Pause':
            app['pause'].label = 'Resume'
        else:
            app['pause'].label = 'Pause'

def stop(app, button):
    camera.stop()

def select_file(app, button, value):
    app['file_name'] = value

app = ui.App(title='Easy Camera Player',

                top=(ui.Entry(id='file_name', value=''),
                     ui.OpenFileButton(id='select_file', callback=select_file),
                     ui.Button(id='play', label='Play',  callback=play),
                     ui.Button(id='pause', label='Pause', callback=pause),
                     ui.Button(id='stop', label='Stop', callback=stop)),

                center=ui.XWindow(id='xwindow'))

camera.set_window_id(app['xwindow'].get_window_id())
ui.run()