import time

from easy import audio
from easy import ui

timeout_id = None

def play(app, button):
    global timeout_id

    if not audio.is_stopped():
        stop(app, button)

    rows = app['playlist'].selected()
    if rows:
        idx, row = rows[0]
        file_name = row[0]
        audio.play(file_name)

    timeout_id = app.timeout_add(100, update_time_label)

def pause(app, button):
    if not audio.is_stopped():
        audio.pause()

        if app['pause'].label == 'Pause':
            app['pause'].label = 'Resume'
        else:
            app['pause'].label = 'Pause'

def stop(app, button):
    if not audio.is_stopped():
        time.sleep(0.1)
        app.remove_event_source(timeout_id)

        audio.stop()
        app['time_label'] = ' ' * 20

def forward(app, button):    
    new_position = audio.get_current_position()
    if new_position:
        new_position += 5 * 10**9          
        
        if new_position < audio.get_length():
            audio.seek(new_position)

def backward(app, button):
    new_position = audio.get_current_position()
    if new_position:
        new_position -= 5 * 10**9 
        
        if new_position > 0:
            audio.seek(new_position)
 
def volume_minus(app, button):
    try:
        audio.set_volume(audio.get_volume() - 1.0)
    except: pass
    
def volume_plus(app, button):
    try:
        audio.set_volume(audio.get_volume() + 1.0)
    except: pass
    
def add_file(app, button, value):
    app['playlist'].append(value)

def update_time_label(app):
    # Due to an incorrect return of query_position gstreamer's method when 
    # the pipeline state is PAUSED, the time label is showing 00:00 when the
    # user click in the pause, >> or << buttons.
    if not audio.is_stopped():
        try:        
            position = audio.get_current_position()
            total = audio.get_length()
    
            if position < total and position >= 0:            
                app['time_label'] = str(convert_time(position)) + ' / ' +  str(convert_time(total))
            else:
                app['time_label'] = ' ' * 20
        except: pass

        return True
    
    app['time_label'] = ' ' * 20
    return True

def convert_time(time_int):
    tmin, tsec = divmod(time_int / 1000000000.0, 60)

    return '%02d:%02d' % (tmin, tsec)

app = ui.App(title='Easy Audio Player',
                top=ui.OpenFileButton(id='add_file', callback=add_file),

                center=ui.Table(id='playlist', label=None,
                                   show_headers=False, types=(str,)),

                bottom=(ui.Button(id='play', label='Play',  callback=play),
                        ui.Button(id='pause', label='Pause', callback=pause),
                        ui.Button(id='stop', label='Stop', callback=stop),
                        ui.Label(id='time_label', label=' ' * 20),
                        ui.Button(id='backward', label='<<', callback=backward),
                        ui.Button(id='forward', label='>>', callback=forward),
                        ui.Button(id='vol_minus', label='vol-', callback=volume_minus),
                        ui.Button(id='vol_plus', label='vol+', callback=volume_plus)))

ui.run()