import os
from easy import eagle
from easy import camera

class EasySlideShow(object):
    
    def __init__(self, folder=None): 
        self.DEFAULT_FOLDER = '/home/user/MyDocs/.images/'
    
        # Application exec. modes 
        self.CAM_MODE = 0
        self.SNAPSHOT_MODE = 1
        
        # Slide move direction
        self.FORWARD = 0
        self.BACKWARD = 1
        
        # Absolute path to maemo picture folder
        self.set_folder(self.DEFAULT_FOLDER)
        
        # Incremental index for new snapshots filename
        self.picture_number = 0
        
        # List holding .jpg filenames
        self.file_list = []
        
        # Index of actual displayed image
        self.image_index = 0
        
        self.image_obj = ''
        
        self.zoomed = False
        
    def add_reference(self, app):
        self.app = app
          
    def set_folder(self, folder):
        if folder:
            self.folder = folder
            
    def list_files(self, app): 
        if self.folder:
            self.file_list = [filename for filename in os.listdir(self.get_folder()) if '.jpg' in filename]
            if not self.file_list:
                app.status_message("This folder has no pictures.")
            else:
                app.status_message("Folder: " + str(len(self.file_list)) + " pictures")
        else:
            app.status_message("Folder not set. Please set a folder by pressing the button 'Open'.")
                
    def start(self, app, button):
        self.set_mode(app, self.CAM_MODE)
        camera.start()
    
    def click(self, app, button):
        if not camera.is_started():
            return
        camera.click(self.get_folder() + app['file_name'])
        app['file_name'] = 'Image' + str(self.get_next_pic_num()) + '.jpg'
    
    def get_next_pic_num(self):
        self.picture_number += 1
        return self.picture_number
    
    def get_folder(self):
        return self.folder
    
    def exit(self, app, button):
        if camera.is_started():
            camera.stop_displaying()
    
    def skip(self, direction):

        if self.get_mode() == self.CAM_MODE:
            self.set_mode(app, self.SNAPSHOT_MODE)    
                
        if not self.file_list or not len(self.file_list):
            app.status_message("This folder has no pictures.")
            return
        
        if direction == self.BACKWARD:
            if self.image_index == 0:
                self.image_index = len(self.file_list) - 1
            else:
                self.image_index -= 1
            
        elif direction == self.FORWARD:
            if self.image_index == len(self.file_list) - 1:
                self.image_index = 0
            else:
                self.image_index += 1
                
        self.image_refresh(app) 
            
    def next(self, app, button):
        self.skip(self.FORWARD)
        
    def last(self, app, button):
        self.skip(self.BACKWARD)
        
    def set_mode(self, app, new_mode):
        self.mode = new_mode
        if self.mode == self.CAM_MODE:
            app['canvas'].set_visible(False)
            app['xwindow'].set_visible(True)
        elif self.mode == self.SNAPSHOT_MODE:
            self.list_files(app)
            camera.stop_displaying()
            app['canvas'].set_visible(True)
            app['xwindow'].set_visible(False)
            
    def get_mode(self):
        return self.mode
    
    def image_refresh(self, app):
        if self.file_list and self.image_index:
            try: 
                self.image_object = eagle.Image(filename=self.get_folder()+self.file_list[self.image_index])
            except:
                app.status_message('Error: ' + self.file_list[self.image_index] + ' is too big.')
        app['canvas'].clear()
        if self.image_object:
            app['canvas'].draw_image(self.image_object)
            app.status_message('File: ' + self.file_list[self.image_index] + '(' + str(self.image_index+1) + ' of ' + str(len(self.file_list)) + ')')
        else:
            app.status_message('File ' + self.file_list[self.image_index] + ' could not be open.')
           
    def select_folder(self, app, button, name):
        if name:
            self.set_folder(name)
        else:
            app.status_message("Default folder: Images")        
        self.list_files(app)
    
ess = EasySlideShow()

app = eagle.App(title='Easy SlideShow',
                top=(eagle.SelectFolderButton(id='select_folder', callback=ess.select_folder),
                     eagle.QuitButton()),
                center=(eagle.XWindow(id='xwindow'),
                        eagle.Canvas(id='canvas', width=640, height=480, bgcolor=0xffffff, scrollbars=True, callback=None, resize_callback=None, expand_policy=None, )),
                bottom=(eagle.Button(id='last', label='Last', callback=ess.last),
                        eagle.Button(id='next', label='Next', callback=ess.next)),
                right=(eagle.Label(id='cameralabel', label='Camera'),
                       eagle.Entry(id='file_name', label='File name:', value='Image0.jpg'),
                       eagle.Button(id='start', label='Start', callback=ess.start),
                     eagle.Button(id='click', label='Click', callback=ess.click),
                     eagle.Button(id='exit', label='Stop', callback=ess.exit),
                     ),
                statusbar=True)


ess.add_reference(app)
ess.list_files(app)
ess.set_mode(app, ess.SNAPSHOT_MODE)
app.status_message("Easy Slide Show")
camera.set_window_id(app['xwindow'].get_window_id())
eagle.run()