from easy import radio
from easy import eagle

def tune_minus(app, button):
    app['frequency'] -=  0.2

def tune_plus(app, button):
    app['frequency'] +=  0.2

def next_station(app, button):
    app['frequency'] = radio.next_station() / 1000.0

def previous_station(app, button):
    app['frequency'] = radio.previous_station() / 1000.0

def set_volume(app, slider, value):
    radio.set_volume(value)

def tune(app, slider, value):
    radio.tune(int(value * 1000))

def exit_callback(app):
    radio.stop()
    eagle.quit()

app = eagle.App(title='Easy Radio', quit_callback=exit_callback,
                top=(eagle.Button(id='previous_station', label='<<', callback=previous_station),
                     eagle.Button(id='next', label='  -  ', callback=tune_minus),
                     eagle.Slider(id='frequency', label='Frequency(MHz)', min=87.5,
                                  max=106.9, value=93.1, digits=1, callback=tune),
                     eagle.Button (id='previous', label='  +  ', callback=tune_plus),
                     eagle.Button(id='next_station', label='>>', callback=next_station)),
                bottom=eagle.Slider(id='volume', label='Volume', min=0.0, max=10.0,
                                    value=5, digits=1, callback=set_volume))

radio.start()
eagle.run()