from easy import contact
from easy import eagle

def update_contact_list():
    contacts = book.cache()
    app.contacts = contacts
    global lock_table
    lock_table = True

    contact_list = []
    
    for contact in contacts:
        name = "no name"
        family_name = "no fname"
        email = "no email"
        gtalk = "no gtalk"
        if contact.name: name = contact.name
        if contact.family_name: family_name = contact.family_name
        if contact.email: email = contact.email
        if contact.gtalk: gtalk = contact.gtalk
        contact_list.append((name, family_name, email, gtalk))

    t = app['contact_table']
    t.clear()
    t[:] = contact_list
    lock_table = False

def data_changed(app, table, data):
    contacts = app.contacts
    index = data[0]
    value = data[1]
    
    if not lock_table:
        if value is not None:
            if len(contacts) <= index:
                c = contact.create_contact()
                app.contacts.append(c)
            else:
                c = contacts[index]
            if value[0] != "no name": c.name = value[0]
            if value[1] != "no fname": c.family_name = value[1]
            if value[2] != "no email": c.email = value[2]
            if value[3] != "no gtalk": c.gtalk = value[3]
        else:
            c = contacts[index]
            book.remove(c)
        
def data_changed_cb(contacts):
    update_contact_list()
        
app = eagle.App(title='Contact Manager', 
    center=eagle.Table(id='contact_table', editable=True, data_changed_callback=data_changed, 
                       label=None, headers=("Name", "Family Name", "E-mail", "GTalk"), 
                       types=(str, str, str, str)))

lock_table = True

book = contact.ContactBook.get_instance()

book.set_contacts_added_cb(data_changed_cb)
book.set_contacts_changed_cb(data_changed_cb)
book.set_contacts_removed_cb(data_changed_cb)

update_contact_list()

eagle.run()