from easy import camera
from easy import eagle

def start(app):
    camera.start()
    return False
    
def record(app, button):
    camera.record(app['file_name'])

def stop_recording(app, button):
    camera.stop_recording()

def play(app, button):
    camera.stop_displaying()
    camera.play(filename=app['file_name'])

def pause(app, button):
    camera.pause()

app = eagle.App(title='Easy Player',
                #Now in Chinook, one must put the complete path. Do not uset ./
                top=(eagle.Entry(id='file_name', value='/home/user/rec.avi'),
                    eagle.Button(id='record', label='Record', callback=record),
                    eagle.Button(id='stop_recording', label='Stop Rec', callback=stop_recording),
                    eagle.Button(id='play', label='Play', callback=play),
                    eagle.Button(id='pause', label='Pause', callback=pause)),
                center=eagle.XWindow(id='xwindow'))

app.idle_add(callback=start)

camera.set_window_id(app['xwindow'].get_window_id())
eagle.run()