// Written by Klaus Rotter, kr@rotters.de
// based BombermanRobertAI.java written by Robert Hockauf
//
// HISTORY:
// 2003-08-30 	Initial work to convert Roberts Java programm to C

//public class BombermanRobertAI extends Thread implements BombermanAI {

#include <stdbool.h>
#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <SDL/SDL.h>

#define DONT_WALK_HERE 	-100000
#define WALK_HERE 			100000
#define WALL_SCORE		1000
#define FLAME_SCORE 		-250
#define BONUS_FACTOR		100			// 0.1
#define SKULL_FACTOR		1000		// 1.0
#define ROUTING_STEPS		16
#define ROUTING_FACTOR	800
#define MIN_OFFENSIVE		20
#define RND_OFFENSIVE		5
#define NEARBY_SCORE		-4000
#define THREAD_SLEEP		25

#define NEUTRAL	0
#define DEFENSIVE	1
#define OFFENSIVE	2

#define ARENA_NULL		0
#define ARENA_BONUS	3
#define ARENA_SKULL	4
#define ARENA_DEBRIS	12
#define ARENA_FLAME	13
#define ARENA_WALL	14
#define ARENA_STEEL	15
#define ARENA_BOMB	16

#define DIRECTION_DOWN	0
#define DIRECTION_RIGHT	1
#define DIRECTION_UP		2
#define DIRECTION_LEFT		3
#define DIRECTION_IDLE		4
#define DIRECTION_DIE		5
#define DIRECTION_WIN		6

#define ACTION_KEYUP		1
#define ACTION_KEYDOWN	2
#define ACTION_KEYLEFT	3
#define ACTION_KEYRIGHT	4

 // BombermanController controller = null

typedef signed char byte;

//static byte player_id = 0; // We have a global player_id in bombermanclient.c
extern byte player_id;

extern bool terminate;
extern bool keyUp;
extern bool keyDown;
extern bool keyLeft;
extern bool keyRight;
extern bool keyFire;
extern bool keyExit;

 static byte arena[15][13][2];
static byte info_x, info_y;

static int 		playerX[5];
static int		playerY[] = {17, 17, 17, 17, 17};
static byte	playerD[5];
static int		player_x, player_y;
static int 		startX[] = {1, 13, 13, 1, 7};
static int 		startY[] = {1, 11, 1, 11, 6};

static int 	tactics = NEUTRAL;
static int 	action = -1;
static int 	offensive_counter = 0;

static int score[15][13];

static int route_list[15*13*4];
static int route_first = 0, route_last = 0;
static bool not_routed[15][13];

static int flame_list[15*13*3*2];
static int flame_first = 0, flame_last = 0;

struct Point {
	int x, y;
};

#define MAXBOMBLIST 100

static struct Point bomb_list[49][MAXBOMBLIST];	// FIXME: Should make this dynamic, static about 20k
static int	bomb_pos[49];				//  actual position

void addElement(int k, int x, int y)
{
	int p;

	p = bomb_pos[k];

	if (p > MAXBOMBLIST) {
		printf("Error: addElement() bomb_list[] full!\n");
		keyExit = true;
		return;
	}
	bomb_list[k][p].x = x;
	bomb_list[k][p].y = y;
	bomb_pos[k]++;
}

bool isEmpty(int k)
{
	if  (bomb_pos[k] == 0)
		return true;
	else
		return false;
}

struct Point firstElement(int k)
{
	struct Point p;

	p.x = bomb_list[k][0].x;
	p.y = bomb_list[k][0].y;

	return p;
}

void removeElementAt(int k, int p)
{
	int i, mp;

	mp = bomb_pos[k];

	if (p < mp)
	{
		for (i = p; i<mp; i++)
		{
			bomb_list[k][i].x = bomb_list[k][i+1].x;
			bomb_list[k][i].y = bomb_list[k][i+1].y;
			i++;
		}
		bomb_pos[k]--;
	}
}

// static Random random = new Random();

void ai_arena(byte x, byte y, byte arena_type)
{
		if (arena_type <= 2) arena[x][y][0] = ARENA_STEEL;					// steel 15
		else if(arena_type <= 3) arena[x][y][0] = ARENA_WALL;				// wall 14
		else if(arena_type <= 8) arena[x][y][0] = ARENA_DEBRIS;				// destroyed wall 12
		else if(arena_type <= 11)											// bomb 16-64
			if(arena[x][y][0] < ARENA_BOMB) arena[x][y][0] = ARENA_BOMB;
			else arena[x][y][0]++;
		else if(arena_type == 12) arena[x][y][0] = ARENA_NULL;				// nothing 0
		else if(arena_type <= 15) arena[x][y][0] = (byte)(16 - arena_type);		// bonus 1-3
		else if(arena_type == 16) arena[x][y][0] = ARENA_SKULL;				// skull 4
		else if(arena_type <= 52) arena[x][y][0] = ARENA_FLAME;				// explosion 13
		else arena[x][y][0] = ARENA_NULL;									// smoke 0

		info_x = x;
		info_y = y;
}

void ai_player(byte i, int x, int y, byte direction)
{
		playerX[i] = (x + 8) / 16;
		playerY[i] = (y + 22) / 16;

		if (direction < 7) playerD[i] = DIRECTION_DOWN;
		else if (direction < 14) playerD[i] = DIRECTION_RIGHT;
		else if (direction < 21) playerD[i] = DIRECTION_UP;
		else if (direction < 28) playerD[i] = DIRECTION_LEFT;
		else if (direction < 31) playerD[i] = DIRECTION_IDLE;
		else if (direction < 35) playerD[i] = DIRECTION_DIE;
		else playerD[i] = DIRECTION_WIN;

		if(i == player_id && playerY[i] <= 11)
		{
			player_x = playerX[i];
			player_y = playerY[i];
		}
}

void ai_info(byte bomb_flamelength)
{
	arena[info_x][info_y][1] = bomb_flamelength;
}

static bool alive()
{
	return (playerD[player_id] <= DIRECTION_IDLE);
}

int score_static(int i, int j)
{
	int sc = 0;
	int k;

	switch(arena[i][j][0])
	{
		case ARENA_NULL:
			switch(tactics)
			{
				case NEUTRAL:
					/**
					 *  avoid dead ends if another player nearby
					 */
					/*if(player_nearby(player_x, player_y, 2) && dead_end(i, j))
						return 0;*/
					/**
					 *  the more walls the better (even skulls)
					 */
					if (arena[i-1][j][0] == ARENA_WALL) sc = WALL_SCORE;
					if (arena[i-1][j][0] == ARENA_SKULL) sc += WALL_SCORE / 4;
					if (arena[i+1][j][0] == ARENA_WALL) sc += WALL_SCORE;
					if (arena[i+1][j][0] == ARENA_SKULL) sc += WALL_SCORE / 4;
					if (arena[i][j-1][0] == ARENA_WALL) sc += WALL_SCORE;
					if (arena[i][j-1][0] == ARENA_SKULL) sc += WALL_SCORE / 4;
					if (arena[i][j+1][0] == ARENA_WALL) sc += WALL_SCORE;
					if (arena[i][j+1][0] == ARENA_SKULL) sc += WALL_SCORE / 4;
					break;
				case DEFENSIVE:
					/**
					 *  the more ways the better (even flames)
					 */
					if(arena[i-1][j][0] <= ARENA_BONUS) sc = WALL_SCORE;
					if(arena[i-1][j][0] == ARENA_FLAME) sc += WALL_SCORE / 4;
					if(arena[i+1][j][0] <= ARENA_BONUS) sc += WALL_SCORE;
					if(arena[i+1][j][0] == ARENA_FLAME) sc += WALL_SCORE / 4;
					if(arena[i][j-1][0] <= ARENA_BONUS) sc += WALL_SCORE;
					if(arena[i][j-1][0] == ARENA_FLAME) sc += WALL_SCORE / 4;
					if(arena[i][j+1][0] <= ARENA_BONUS) sc += WALL_SCORE;
					if(arena[i][j+1][0] == ARENA_FLAME) sc += WALL_SCORE / 4;
					break;
				case OFFENSIVE:
					/**
					 *  the more other player the better
					 */
					for(k = 0; k < 5; k++)
						if(k != player_id && i == playerX[k] && j == playerY[k])
							sc += WALL_SCORE;
					break;
				//default:
					//
			}
			break;
		case 1:
		case 2:
		case ARENA_BONUS:
			sc = (WALK_HERE * BONUS_FACTOR) / 1000;
			break;
		case ARENA_SKULL:
			sc = (DONT_WALK_HERE * SKULL_FACTOR) / 1000;
			break;
		default:
			sc = DONT_WALK_HERE;
	}
	return sc;
}

static void clear_route()
{
	int i, j;

	for(i = 0; i < 15; i++)
		for(j = 0; j < 13; j++)
			not_routed[i][j] = true;
}

static void do_route(int i, int j, int steps, int sc)
{
	if ((--steps) == 0) return;
	sc = (sc * ROUTING_FACTOR) / 1000;

	if (not_routed[i-1][j] && arena[i-1][j][0] <= ARENA_BONUS)
	{
		not_routed[i-1][j] = false;
		if(sc > score[i-1][j]) score[i-1][j] = sc;
		route_list[route_last++] = i-1;
		route_list[route_last++] = j;
		route_list[route_last++] = steps;
		route_list[route_last++] = sc;
	}
	if (not_routed[i+1][j] && arena[i+1][j][0] <= ARENA_BONUS)
	{
		not_routed[i+1][j] = false;
		if(sc > score[i+1][j]) score[i+1][j] = sc;
		route_list[route_last++] = i+1;
		route_list[route_last++] = j;
		route_list[route_last++] = steps;
		route_list[route_last++] = sc;
	}
	if (not_routed[i][j-1] && arena[i][j-1][0] <= ARENA_BONUS)
	{
		not_routed[i][j-1] = false;
		if(sc > score[i][j-1]) score[i][j-1] = sc;
		route_list[route_last++] = i;
		route_list[route_last++] = j-1;
		route_list[route_last++] = steps;
		route_list[route_last++] = sc;
	}
	if (not_routed[i][j+1] && arena[i][j+1][0] <= ARENA_BONUS)
	{
		not_routed[i][j+1] = false;
		if(sc > score[i][j+1]) score[i][j+1] = sc;
		route_list[route_last++] = i;
		route_list[route_last++] = j+1;
		route_list[route_last++] = steps;
		route_list[route_last++] = sc;
	}
}

static void score_route()
{
	int i, j, k;

	/**
	 *  reset score and fill bomb lists
	 */
	for (i = 0; i < 15; i++)
		for (j = 0; j < 13; j++)
		{
			score[i][j] = DONT_WALK_HERE;
			k = arena[i][j][0]-ARENA_BOMB;
			if (k > 48) k = 48;
			if (arena[i][j][0] >= ARENA_BOMB)
				addElement(k, i, j);
		}

	for(i = 1; i <= 13; i++)
	{
		for(j = 1; j <= 11; j++)
		{
			int sc = score_static(i, j);
			if(sc < 0 || sc > score[i][j]) score[i][j] = sc;
			if(arena[i][j][0] <= ARENA_BONUS)
			{
				clear_route();
				not_routed[i][j] = false;
				route_first = 0;
				route_last = 0;
				route_list[route_last++] = i;
				route_list[route_last++] = j;
				route_list[route_last++] = ROUTING_STEPS;
				route_list[route_last++] = sc;
				
				while(route_first < route_last) 
				{
					do_route(route_list[route_first++], route_list[route_first++], route_list[route_first++], route_list[route_first++]);
				}	
			}
		}
	}	
}

static void do_bombs()
{
	int i, j;
	//struct Point p;

	clear_route();

	for(i = 48; i >= 0; i--)
		while(!isEmpty(i))
		{
			//Point p = (Point)bomb_list[i].firstElement();

			struct Point p;
			//p = firstElement(i);

			p.x = bomb_list[i][0].x;
			p.y = bomb_list[i][0].y;

			if(not_routed[p.x][p.y])
			{
				not_routed[p.x][p.y] = false;
				flame_list[flame_last++] = p.x;
				flame_list[flame_last++] = p.y;
				flame_list[flame_last++] = -1;

				for (j = 1; j <= arena[p.x][p.y][1]; j++)
					if (arena[p.x-j][p.y][0] >= ARENA_BOMB)
					{
						if (not_routed[p.x-j][p.y])
						{
							if((arena[p.x][p.y][0] - arena[p.x-j][p.y][0]) > 1)
								addElement(i-1, p.x-j, p.y); // bomb_list[i-1].addElement(new Point(p.x-j, p.y));
							break;
						}
						flame_list[flame_last++] = p.x-j;
						flame_list[flame_last++] = p.y;
						flame_list[flame_last++] = i;
					} else
					if(arena[p.x-j][p.y][0] <= ARENA_BONUS || arena[p.x-j][p.y][0] == ARENA_FLAME)
					{
						flame_list[flame_last++] = p.x-j;
						flame_list[flame_last++] = p.y;
						flame_list[flame_last++] = i;
					} else break;

					for(j = 1; j <= arena[p.x][p.y][1]; j++)
						if(arena[p.x+j][p.y][0] >= ARENA_BOMB)
						{
							if(not_routed[p.x+j][p.y])
							{
								if((arena[p.x][p.y][0] - arena[p.x+j][p.y][0]) > 1)
								{
									addElement(i-1, p.x+j, p.y); // bomb_list[i-1].addElement(new Point(p.x+j, p.y));
								}
								break;
							}
							flame_list[flame_last++] = p.x+j;
							flame_list[flame_last++] = p.y;
							flame_list[flame_last++] = i;
						}
						else if(arena[p.x+j][p.y][0] <= ARENA_BONUS || arena[p.x+j][p.y][0] == ARENA_FLAME)
						{
							flame_list[flame_last++] = p.x+j;
							flame_list[flame_last++] = p.y;
							flame_list[flame_last++] = i;
						} else break;

					for(j = 1; j <= arena[p.x][p.y][1]; j++)
						if(arena[p.x][p.y-j][0] >= ARENA_BOMB)
						{
							if(not_routed[p.x][p.y-j])
							{
								if((arena[p.x][p.y][0] - arena[p.x][p.y-j][0]) > 1)
									addElement(i-1, p.x+j, p.y); // bomb_list[i-1].addElement(new Point(p.x, p.y-j));
								break;
							}
							flame_list[flame_last++] = p.x;
							flame_list[flame_last++] = p.y-j;
							flame_list[flame_last++] = i;
						}
						else if (arena[p.x][p.y-j][0] <= ARENA_BONUS || arena[p.x][p.y-j][0] == ARENA_FLAME) {
							flame_list[flame_last++] = p.x;
							flame_list[flame_last++] = p.y-j;
							flame_list[flame_last++] = i;
						}
						else break;

					for(j = 1; j <= arena[p.x][p.y][1]; j++)
						if(arena[p.x][p.y+j][0] >= ARENA_BOMB)
						{
							if(not_routed[p.x][p.y+j])
							{
								if((arena[p.x][p.y][0] - arena[p.x][p.y+j][0]) > 1)
									addElement(i-1, p.x+j, p.y); // bomb_list[i-1].addElement(new Point(p.x, p.y+j));
								break;
							}
							flame_list[flame_last++] = p.x;
							flame_list[flame_last++] = p.y+j;
							flame_list[flame_last++] = i;
						}
						else	if(arena[p.x][p.y+j][0] <= ARENA_BONUS || arena[p.x][p.y+j][0] == ARENA_FLAME)
						{
							flame_list[flame_last++] = p.x;
							flame_list[flame_last++] = p.y+j;
							flame_list[flame_last++] = i;
						} else break;
				}
				removeElementAt(i,0); // bomb_list[i].removeElementAt(0);
			}
	}

static void score_flames()
{
	bool run_away;

		/**
		 *  get list of (future) flames ordered by time
		 */
		flame_first = 0;
		flame_last = 0;
		do_bombs();
		clear_route();

		run_away = false;

		while(flame_first < flame_last)
		{
			int x, y, sc;

			x = flame_list[flame_first++];
			y = flame_list[flame_first++];
			sc = flame_list[flame_first++];

			/**
			 *  become defensive when going to be flamed
			 */
			if (x == player_x && y == player_y)
				run_away = true;

			if (not_routed[x][y])
				score[x][y] += (sc + 1) * FLAME_SCORE;

			not_routed[x][y] = false;
		}
		if (run_away) tactics = DEFENSIVE; else tactics = NEUTRAL;
	}


static bool drop_bomb()
{
	int w, e;

		switch(tactics)
		{
			case NEUTRAL:
				if(action >= 0) break;

				/**
				 *  only drop bomb if at least one wall (or skull) will be destroyed and there is a way to escape
				 */
				w = 0, e = 0;
 				if(arena[player_x-1][player_y][0] == ARENA_WALL || arena[player_x-1][player_y][0] == ARENA_SKULL) w++;
				else if(score[player_x-1][player_y] >= 0) e++;
				if(arena[player_x+1][player_y][0] == ARENA_WALL || arena[player_x+1][player_y][0] == ARENA_SKULL) w++;
				else if(score[player_x+1][player_y] >= 0) e++;
				if(arena[player_x][player_y-1][0] == ARENA_WALL || arena[player_x][player_y-1][0] == ARENA_SKULL) w++;
				else if(score[player_x][player_y-1] >= 0) e++;
				if(arena[player_x][player_y+1][0] == ARENA_WALL || arena[player_x][player_y+1][0] == ARENA_SKULL) w++;
				else if(score[player_x][player_y+1] >= 0) e++;

				if(w > 0 && e > 0) return true;
				break;
			case OFFENSIVE:
				if((rand() % RND_OFFENSIVE) == 0) return true;
				break;
			case DEFENSIVE:
				;
				/**
				 *  don't drop a bomb if in defensive mode
				 */
			default: 
				; //gcc 3.4.x will break here without ';'
 		}
		return false;
	}


int ai_run(void *id)
{
	int i, j;

	//this.controller = controller;
	//player_id = (byte *) *id;
	//printf("Player id=%d\n", (int) player_id);

	printf("AI thread started...\n");

	for (i = 0; i < 15; i++)
		for (j = 0; j < 13; j++)
			arena[i][j][0] = ARENA_STEEL;

	for (i = 0; i < 49; i++)
		bomb_pos[i] = 0;	// Init position, empty list

	player_x = startX[(int) id];
	player_y = startY[(int) id];

	SDL_Delay(3000);

	//new Thread(this).start();
	//System.out.println("BombermanRobertAI version 26.jul.2002 by robert hockauf.");
	// Mainloop of AI Thread
	while(!terminate)
	{
		SDL_Delay(100);

		printf("AI thread working...\n");

		keyUp 		= false;
		keyDown	= false;
		keyLeft		= false;
		keyRight 	= false;
		keyFire 		= false;
		// keyExit 		= false;

		// printf("ai Thread running...\n");

		if (alive())
		{
			int max;

			score_route();
			score_flames();
			//log();
			action = -1;
			max = score[player_x][player_y];

			if (score[player_x][player_y-1] > max)
			{
				max = score[player_x][player_y-1];
				action = ACTION_KEYUP; // action = BombermanController.KEY_UP;
			}

			if (score[player_x][player_y+1] > max)
			{
				max = score[player_x][player_y+1];
				action = ACTION_KEYDOWN; //action = BombermanController.KEY_DOWN;
			}

			if (score[player_x-1][player_y] > max)
			{
				max = score[player_x-1][player_y];
				action = ACTION_KEYLEFT; //action = BombermanController.KEY_LEFT;
			}

			if (score[player_x+1][player_y] > max)
			{
				max = score[player_x+1][player_y];
				action = ACTION_KEYRIGHT; //action = BombermanController.KEY_RIGHT;
			}

			/**
			*  become offensive if nothing else to do
			*/
			if (action < 0 && max == 0 && tactics != OFFENSIVE) offensive_counter++;
			if (offensive_counter > MIN_OFFENSIVE)
			{
				offensive_counter = MIN_OFFENSIVE;
				tactics = OFFENSIVE;
			}
			// controller.key(action, true);
			switch (action)
			{
				case ACTION_KEYUP:
					keyUp = true;
					break;
				case ACTION_KEYDOWN:
					keyDown = true;
					break;
				case ACTION_KEYLEFT:
					keyLeft = true;
					break;
				case ACTION_KEYRIGHT:
					keyRight = true;
					break;
			}
			keyFire = drop_bomb(); // controller.key(BombermanController.KEY_FIRE, drop_bomb());
		}
		else
		{
			/**
			*  move player to start position if died or won
			*/
			player_x = startX[player_id];
			player_y = startY[player_id];
			tactics = NEUTRAL;
		}
	}
	return 0;
}
