#!/usr/bin/env python

# This file is part of Atabake
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Authors: Artur Duque de Souza <artur.souza@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Additional permission under GNU GPL version 3 section 7
#
# The copyright holders grant you an additional permission under Section 7
# of the GNU General Public License, version 3, exempting you from the
# requirement in Section 6 of the GNU General Public License, version 3, to
# accompany Corresponding Source with Installation Information for the
# Program or any work based on the Program. You are still required to comply
# with all other Section 6 requirements to provide Corresponding Source.

__author__ = "Artur Duque de Souza / Leonardo Sobral Cunha"
__author_email__ = "artur.souza@openbossa.org / leonardo.cunha@openbossa.org"

import dbus
import time

# for tests
import sys
from atabake.lib.media_engine  import MediaEngine
from atabake.lib.player_session import PlayerSession

if len(sys.argv) == 2:

    bus = dbus.SessionBus()
    media_engine_obj = bus.get_object(MediaEngine.DBUS_SERVICE_NAME,
                                      MediaEngine.DBUS_OBJ_PATH,
                                      introspect=False)
    media_engine_iface = dbus.Interface(media_engine_obj,
                                        MediaEngine.DBUS_IFACE)

    session_obj_path = media_engine_iface.create_session(sys.argv[1])

    # instanciate player
    session_obj = bus.get_object(PlayerSession.DBUS_SERVICE_NAME,
                                 session_obj_path, introspect=False)
    session_iface = dbus.Interface(session_obj, PlayerSession.DBUS_IFACE)

    print "trying to play"
    session_iface.play()
    print "playing"

    #time.sleep(1)
    #print "getting media details ..."
    #details = session_iface.get_media_details()
    #print "details = " + str(details)

    time.sleep(10)
    print "stopped after 10s"

    print "trying to stop"
    session_iface.stop()
    print "stopped"

else:
    print "Usage: %s [filepath]" % sys.argv[0]
    sys.exit(2)
