#!/bin/sh
# use gainroot to become root and relaunch itself
if [ `id -u` != 0 ] ; then
	#if not already root, call itself as root
	sudo gainroot <<EOF
exec $0
EOF
	exit
fi
# real script follows
#!/bin/sh

sudocheck=`grep "/usr/sbin/chroot /mnt/initfs/ dsmetest -l" /etc/sudoers`
if [ "$sudocheck" != "" ]
then
	echo "Sudoers is setup, good to go..."
else
	echo "Setting up sudoers file..."
	echo 'user ALL = NOPASSWD: /usr/sbin/chroot /mnt/initfs/ dsmetest -l *' >> /etc/sudoers
fi

if [ -e "/usr/lib/hildon-desktop/advanced-backlight.so" ]
then
	echo "Removing old files..."
	rm -f /usr/share/applications/hildon-status-bar/advanced-backlight.desktop
	rm -f /usr/lib/hildon-desktop/advanced-backlight.so
fi

echo "Putting files in their place..."
cp advanced-backlight.so /usr/lib/hildon-desktop/
cp advanced-backlight.desktop /usr/share/applications/hildon-status-bar/

echo "Changing necessary permissions..."
chown root.root /usr/lib/hildon-desktop/advanced-backlight.so
chown root.root /usr/share/applications/hildon-status-bar/advanced-backlight.desktop

echo "Done!"
