import commands
import os.path
import fnmatch
import gtk
import random
import fnmatch
import gtk.gdk
from mutagen.id3 import ID3, ID3NoHeaderError

VERSION = "0.5.5"
IS_MAEMO = commands.getoutput("uname -m")[0:3] == "arm" # if cpu type is ARM, we are on maemo

# general settings
known_exts = ("mp3", "ogg", "mp4", "wma")

# device specific settings
if IS_MAEMO:
    MAX_VOL = 10.0
    img_path = "/usr/share/youamp/%s"
    db_file = os.path.expanduser("~/.musicdb")
else: 
    MAX_VOL = 4.0
    img_path = "data/%s"
    db_file = os.path.expanduser("~/.local/youamp/musicdb")

class Playlist(gtk.ListStore):    
    def __init__(self, playlist=None):
        gtk.ListStore.__init__(self, object)
        
        # shuffled positions
        self._permutation = None
        
        if playlist is not None:
            self.update(playlist)        
        
    def update(self, playlist):
        self.clear()

        for song in playlist:
            self.append((song,))
    
    def shuffle(self, shuffle):
        """shuffle/ unshuffle the playlist"""
        if shuffle:
            # build permutation
            self._permutation = range(0, len(self))
            random.shuffle(self._permutation)
        else:
            # build permutation inverse
            inv_perm = range(0, len(self))
            for i in xrange(0, len(self)):
                inv_perm[self._permutation[i]] = i
            
            self._permutation = inv_perm
            
        self.reorder(self._permutation)
    
    def get_new_pos(self, i):
        return self._permutation.index(i)
    
    def __getitem__(self, k):
        return gtk.ListStore.__getitem__(self, k)[0]
    
    def __setitem__(self, k, v):
        gtk.ListStore.__getitem__(self, k)[0] = v
    
    def index(self, v):
        for i in xrange(len(self)):
            if self[i] is v:
                return i
            
    
class Song(dict):
    def __init__(self, data):
        dict.__init__(self)
                
        if(isinstance(data, tuple)):
            self.data = data
            self.uri = data[0]
            self["title"] = data[1]
            self["artist"] = data[2]
            self["album"] = data[3]
            self["playcount"] = data[4]
        else:
            self.uri = data
    
    def cover_uri(self):
        if not self.uri.startswith("file://"):
            return None
        
        dir = os.path.dirname(self.uri[7:])
        
        try:
            img = fnmatch.filter(os.listdir(dir), "*.jpg")[0]
        except IndexError:
            return None
        
        return os.path.join(dir, img)

    def cover_image(self, size):
        path = self.cover_uri()

        if path is None:
            # no image in song directory
            # try to load from ID3
            try:
                id3 = ID3(self.uri[7:])
                if len(id3.getall('APIC')) > 0:
                    apic = id3.getall('APIC')[0]
                    loader = gtk.gdk.PixbufLoader()
                    loader.set_size(*size)
                    loader.write(apic.data)
                    loader.close()
                    return loader.get_pixbuf()
            except ID3NoHeaderError:
                pass

            return None
        else:
            # use the image in song directory
            return gtk.gdk.pixbuf_new_from_file_at_size(path, *size)

