import gtk
from youamp import IS_MAEMO

class CoverImage(gtk.Image):
    def __init__(self):
        gtk.Image.__init__(self)
        self.album = ""

    def set_generic(self):
        name = "audio-x-generic" if not IS_MAEMO else "gnome-mime-audio-x-mp3"
        pb = gtk.icon_theme_get_default().load_icon(name, self.size_request()[1], 0)
        self.set_from_pixbuf(pb)
        self.album = None

    def set_from_song(self, song, generic_fallback=True):
        pb = song.cover_image(self.size_request())

        if pb is None and generic_fallback:
            self.set_generic()
            return

        self.set_from_pixbuf(pb)
        self.album = song["album"]