import gtk
import gtk.gdk
import pango

from youamp.ui.popupmenu import PopupMenu

from youamp import IS_MAEMO

class PlaylistView(gtk.TreeView):
    def __init__(self, model, config, player):        
        gtk.TreeView.__init__(self, model)
        
        self._config = config
        self._player = player
        
        self.set_rules_hint(True)
        self.set_headers_visible(True)
        self.set_fixed_height_mode(True)
        
        keys = ("title", "artist", "album")
        cols = (_("Title"), _("Artist"), _("Album"))
        
        cell = gtk.CellRendererText()
        cell.set_property("ellipsize", pango.ELLIPSIZE_END)
            
        for i in xrange(len(keys)):
            col = gtk.TreeViewColumn(cols[i], cell)
            col.set_sizing(gtk.TREE_VIEW_COLUMN_FIXED)
            col.set_fixed_width(200)
            col.set_cell_data_func(cell, self._data_func, keys[i])
            self.append_column(col)
        
        if not IS_MAEMO:
            #self.get_selection().set_mode(gtk.SELECTION_MULTIPLE)
            
            # drag and drop
            self.drag_dest_set(gtk.DEST_DEFAULT_DROP, [("text/uri-list", 0, 0)], gtk.gdk.ACTION_LINK)
            self.connect("drag-data-received", self._recieve_drag_data)
            self.enable_model_drag_source(gtk.gdk.BUTTON1_MASK, [("text/uri-list", 0, 0)], gtk.gdk.ACTION_COPY)
            self.connect("drag-data-get", self._get_drag_data)
            
        # menu
        self._menu = PopupMenu(self._config, self._player)
        self.connect("button-press-event", self._popup_menu)
        
        if IS_MAEMO:
            self.tap_and_hold_setup(self._menu)
            self.connect("tap-and-hold", self._set_song)
        
        # Signals
        self._config.notify_add("pos", self._on_pos_changed)
        self.connect("row-activated", self._on_row_activated)
    
    def restore(self):
        self._on_pos_changed()
    
    def _set_song(self, *args):
        ptr = self.get_pointer()
        #coords = self.convert_widget_to_bin_window_coords(*ptr)
        pos = self.get_path_at_pos(ptr[0], ptr[1] - 25)[0]
                
        self._menu.song = self._player.playlist[pos]
        
    def _popup_menu(self, caller, ev):
        if ev.button == 3:
            self._menu.popup(None, None, None, ev.button, ev.time)
            
            # FIXME: very hacky: should use ev.x, ev.y instead
            # but maemo sucks again here
            self._set_song()
    
    def _recieve_drag_data(self, tv, ctxt, x, y, selection, *args):
        print selection.get_uris()
    
    def _get_drag_data(self, tv, ctxt, selection, *args):
        uri = self._player.playlist[self._config["pos"]].uri
        selection.set_uris([uri])

    def _on_pos_changed(self, *args):
        self.set_cursor(self._config["pos"])
 
    def _on_row_activated(self, caller, path, column):
        self._player.goto_pos(path[0])

    def _data_func(self, col, cell, model, itr, key):
        cell.set_property("text", model[itr][key])