import gtk
import pango

class DetailsWindow(gtk.Window):
    __instance = None
    
    def __init__(self):
        if DetailsWindow.__instance is not None:
            raise Exception, "This is a Singleton object"
        
        self._created = False
    
    @staticmethod
    def get_instance():
        if DetailsWindow.__instance is None:
            DetailsWindow.__instance = DetailsWindow()
        
        return DetailsWindow.__instance
    
    def cshow(self):
        if not self._created:
            self._create()
            self._created = True

        self.show()
    
    def _create(self):
        gtk.Window.__init__(self)
    
        self.set_type_hint(gtk.gdk.WINDOW_TYPE_HINT_DIALOG)
        self.set_default_size(600, -1)
    
        self._data = None
        self._transl = (("title", _("Title")), 
                        ("artist", _("Artist")), 
                        ("album", _("Album")), 
                        ("playcount", _("Playcount")))
        
        ebox = gtk.EventBox()
        self.add(ebox)
        
        vbox = gtk.VBox()
        vbox.set_spacing(5)
        ebox.add(vbox)
        
        # content
        hbox = gtk.HBox()
        hbox.set_spacing(5)
        vbox.pack_start(hbox)
        
        self._cover = gtk.Image()
        self._cover.set_size_request(-1, 300)
        hbox.pack_start(self._cover, expand=False)
        
        dbox = gtk.VBox()
        hbox.pack_start(dbox)
        
        self._data = {}
        
        for k, tk in self._transl:
            row, self._data[k] = self._data_row(tk)
            dbox.pack_start(row, expand=False)
            
        row, self._loc = self._data_row(_("Location"))
        dbox.pack_start(row, expand=False)
        
        ebox.connect("button-release-event", self.hide_on_delete)     
        self.connect("delete-event", self.hide_on_delete)
        self.show_all()
    
    def _data_row(self, tk):
        row = gtk.HBox()
        
        kl = gtk.Label()
        kl.set_markup("<b>%s</b>" % tk)
        kl.set_size_request(100, -1)
        kl.set_alignment(0, 0.5)
        row.pack_start(kl, expand=False)
        
        dlabel = gtk.Label()
        dlabel.set_ellipsize(pango.ELLIPSIZE_END)
        dlabel.set_alignment(0, 0.5)
        row.pack_start(dlabel)
        
        return row, dlabel
            
    def set_data(self, song):
        if not self._created:
            self._create()
            self._created = True
      
        self.set_title(_("Details for %s") % song["title"])
        
        cover_file = song.cover_uri()
        
        if cover_file is not None:
            pb = gtk.gdk.pixbuf_new_from_file_at_size(cover_file, 300, 300)
            self._cover.set_from_pixbuf(pb)
        else:
            self._cover.set_from_pixbuf(None)
        
        for k, l in self._data.iteritems():
            l.set_text(str(song[k]))
        
        self._loc.set_text(song.uri[7:])