#!/usr/bin/env python

from distutils.core import setup
import distutils.command.build as dist_build
import os
import glob

class my_build(dist_build.build):
    """
    also builds gettext files
    """
    po_dir = "po"
    domain = "youamp"
 
    # ripped from distutils-extra, so use that if you are not on maemo
    def run(self):
        dist_build.build.run(self)
        
        data_files = self.distribution.data_files
        
        for po_file in glob.glob("%s/*.po" % self.po_dir):
            lang = os.path.basename(po_file[:-3])
            mo_dir =  os.path.join("build", "mo", lang, "LC_MESSAGES")
            mo_file = os.path.join(mo_dir, "%s.mo" % self.domain)
            if not os.path.exists(mo_dir):
                os.makedirs(mo_dir)
            cmd = ["msgfmt", po_file, "-o", mo_file]
            self.spawn(cmd)

            targetpath = os.path.join("share/locale", lang, "LC_MESSAGES")
            data_files.append((targetpath, (mo_file,)))

if __name__ == "__main__":   
    setup(
          cmdclass = {"build": my_build},
          name = "youamp",
          version = "0.5.2",
          description = "a lightweight music player for the Internet Tablet",
          author = "Pavel Rojtberg",
          author_email = "pavel@rojtberg.net",
          url = "http://www.rojtberg.net/workspace/youamp/",
          license = "GNU GPL v3",
          long_description = """\
YouAmp places the focus on playback features instead of fancy graphics. 
It features itelligent replaygain selection, OGG playback and last.fm submission support.""",
          scripts = ["youamp-player"],
          packages = ["youamp", "youamp.ui"],
          data_files = [("share/pixmaps/", ["data/youamp.png"]),
                        ("share/youamp/", glob.glob("data/*.png")),
                        ("share/applications/hildon/", ["youamp.desktop"]),
                        ("share/dbus-1/services/", ["youamp.service"])])
