import commands
import os.path
import gtk
import gobject
import random

VERSION = "0.4.2"
IS_MAEMO = commands.getoutput("uname -m")[0:3] == "arm" # if cpu type is ARM, we are on maemo

# general settings
db_file = os.path.expanduser("~/.musicdb")
known_exts = ("mp3", "ogg", "mp4", "wma")

# device specific settings
if IS_MAEMO:
    MAX_VOL = 10.0
    img_path = "/usr/share/youamp/%s"
else: 
    MAX_VOL = 4.0
    img_path = "data/%s"

class Playlist(gtk.ListStore):    
    def __init__(self, playlist=None):
        gtk.ListStore.__init__(self, object)
        
        # shuffled positions
        self._permutation = None
        
        if playlist is not None:
            self.update(playlist)        
        
    def update(self, playlist):
        self.clear()

        for song in playlist:
            self.append((song,))
    
    def shuffle(self, shuffle):
        """shuffle/ unshuffle the playlist"""
        if shuffle:
            # build permutation
            self._permutation = range(0, len(self))
            random.shuffle(self._permutation)
        else:
            # build permutation inverse
            inv_perm = range(0, len(self))
            for i in xrange(0, len(self)):
                inv_perm[self._permutation[i]] = i
            
            self._permutation = inv_perm
            
        self.reorder(self._permutation)
    
    def get_new_pos(self, i):
        return self._permutation.index(i)
    
    def __getitem__(self, k):
        return gtk.ListStore.__getitem__(self, k)[0]
    
    def __setitem__(self, k, v):
        gtk.ListStore.__getitem__(self, k)[0] = v
    
class Song(dict):
    def __init__(self, data):
        dict.__init__(self)
        
        self.data = None
        
        if(isinstance(data, tuple)):
            self.data = data
            self.uri = self.data[0]
            self["title"] = self.data[1]
            self["artist"] = self.data[2]
            self["album"] = self.data[3]
        else:
            self.uri = data

