/*
  This file is part of "WhoAmI" - A "Guess whats on the photo" riddle game.
  Copyright (C) 2007  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "ImageInfo.h"

#include <Lum/Base/L10N.h>
#include <Lum/Base/String.h>

#include <Lum/Button.h>
#include <Lum/ButtonRow.h>
#include <Lum/Label.h>
#include <Lum/Panel.h>

ImageInfo::ImageInfo(Image* image)
 : image(image)
{
  Observe(GetClosedAction());
}

void ImageInfo::PreInit()
{
  Lum::Panel *panel;

  panel=new Lum::VPanel();
  panel->Add(Lum::Label::Create(true,true)
             ->AddLabel(L"Author:",Lum::Base::StringToWString(image->GetAuthor()))
             ->AddLabel(L"Title:",Lum::Base::StringToWString(image->GetTitle())));
  panel->AddSpace();
  panel->Add(Lum::ButtonRow::CreateClose(GetClosedAction(),true,false));

  SetMain(panel);

  Dialog::PreInit();
}

void ImageInfo::Resync(Lum::Base::Model *model, const Lum::Base::ResyncMsg& msg)
{
  if (model==GetClosedAction() && GetClosedAction()->IsFinished()) {
    Exit();
  }
  Dialog::Resync(model,msg);
}

