#!/usr/bin/env python

import sys
import os
import time
import re
import operator
try:
	import pygtk
	pygtk.require("2.0")
except:
	pass
try:
	import gtk
	import gtk.glade
except:
	sys.exit(1)

class WeightWatchersEurope:
	
	def __init__(self):
		if os.path.isfile("/usr/local/lib/weightwatchers-europe.glade") :
			self.gladefile = "/usr/local/lib/weightwatchers-europe.glade"  
		elif os.path.isfile("./weightwatchers-europe.glade") :
			self.gladefile = "./weightwatchers-europe.glade"  

		self.wTree = gtk.glade.XML(self.gladefile)
		self.window = self.wTree.get_widget("window1")
		if (self.window):
			self.window.connect("destroy", gtk.main_quit)
		
		self.points = self.wTree.get_widget("entry_points")
		self.kj = self.wTree.get_widget("spin_kj")
		self.fat = self.wTree.get_widget("spin_fat")
		
		self.kj.set_property('hildon-input-mode', (1 << 1 | 1 << 2))
		self.fat.set_property('hildon-input-mode', (1 << 1 | 1 << 2))

		self.about_dialog = None  #-- Not sure if I need these two
		self.error_dialog = None  #-- lines...

		dic = {
			# Process signal from button
			"calculate" : self.calculate_points}
		self.wTree.signal_autoconnect(dic)
	
	
	def ErrPopUp(self,msg):
		error_dialog = gtk.MessageDialog(None,0,gtk.MESSAGE_ERROR,gtk.BUTTONS_CLOSE,msg)
		def close(dialog, response, editor):
			editor.about_dialog = None
			dialog.destroy()
		error_dialog.connect("response", close, self)
		# error_dialog.connect("delete-event", delete_event, self)
		self.error_dialog = error_dialog
		error_dialog.run()
	
		
	def calculate_points(self, widget):
		#Note: This is the European version!
		self.points.set_text(str(round((self.kj.get_value()/300.00)+(self.fat.get_value()/4.12),1)))
		
		
	
if __name__ == "__main__":
	title = 'Weight Watches Europe Calculator'
	handle = WeightWatchersEurope()
	gtk.main()
	sys.exit(1)
