/*
* This file is part of TuxPuck based on 2001-2002 Jacob Kroon's version
*
* Copyright (C) 2005 INdT - Instituto Nokia de Tecnologia
* http://www.indt.org/maemo
*
* This software is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public License
* as published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA
*
*/

#include <stdlib.h>
#include <SDL_timer.h>
#include "tuxpuck.h"

/* structs */
struct _Timer {
  Uint32 start, end, elapsed_time;
};

/* functions */
Timer *tuxpuck_timer_create(void)
{
  Timer *timer = NULL;

  timer = malloc(sizeof(Timer));
  timer->start = SDL_GetTicks();
  timer->end = timer->start;
  timer->elapsed_time = 0;
  return timer;
}

void timer_free(Timer * timer)
{
  free(timer);
}

void timer_reset(Timer * timer)
{
  timer->start = SDL_GetTicks();
  timer->end = 0;
}

void timer_update(Timer * timer)
{
  timer->end = SDL_GetTicks();
  timer->elapsed_time = timer->end - timer->start;
}

Uint32 timer_elapsed(Timer * timer)
{
  return timer->elapsed_time;
}
