#include <stdio.h>

#include <glib.h>
#include <gtk/gtk.h>

#include <libhildondesktop/libhildondesktop.h>

#include "bahnhofsuhr.h"
#include <sys/time.h>


HD_DEFINE_PLUGIN (BahnhofsuhrPlugin, bahnhofsuhr_plugin, HILDON_DESKTOP_TYPE_HOME_ITEM);


static gboolean
bahnhofsuhr_update_time (gpointer data)
{
  BahnhofsuhrPlugin *uhr = BAHNHOFSUHR_PLUGIN (data);

  gettimeofday (&uhr->tv, NULL);
  localtime_r (&uhr->tv.tv_sec, &uhr->time_info);

  gtk_widget_queue_draw (GTK_WIDGET (uhr));

  if (uhr->timeout_id)
    g_source_remove (uhr->timeout_id);

  uhr->timeout_id = g_timeout_add ((60 - uhr->time_info.tm_sec) * 1000 + 10,
                                   bahnhofsuhr_update_time,
                                   uhr);
  return FALSE;
}


void
bahnhofsuhr_screen_changed (GtkWidget *widget,
		            GdkScreen *previous_screen,
			    gpointer   user_data)
{
  GdkScreen *screen;
  GdkColormap *cmap;

  screen = gtk_widget_get_screen (widget);
  
  cmap = gdk_screen_get_rgba_colormap (screen);
  
  if (!cmap)
    cmap = gdk_screen_get_rgb_colormap (screen);

  gtk_widget_set_colormap (widget, cmap);
}


static gboolean
bahnhofsuhr_expose_event (GtkWidget      *widget,
                          GdkEventExpose *event,
                          gpointer        data)
{
  BahnhofsuhrPlugin *uhr = BAHNHOFSUHR_PLUGIN (data);
  cairo_t  *cr;
  double h, m;
  int i;
             
  cr = gdk_cairo_create (event->window);
  gdk_cairo_rectangle (cr, &event->area);
  cairo_clip (cr);
  // cairo_translate (cr, widget->allocation.x, widget->allocation.y);

  cairo_set_source_rgba (cr, 1.0, 1.0, 1.0, 0.0);
  cairo_set_operator (cr, CAIRO_OPERATOR_SOURCE);
  cairo_paint (cr);
  cairo_set_operator (cr, CAIRO_OPERATOR_OVER);

  cairo_translate (cr,
                   widget->allocation.width / 2 - 0.5,
                   widget->allocation.height / 2 - 0.5);
  cairo_scale (cr,
               MIN (widget->allocation.width / 2, widget->allocation.height / 2),
               -MIN (widget->allocation.width / 2, widget->allocation.height / 2));

  cairo_scale (cr, 1.0/75, 1.0/75);
  cairo_set_source_rgb (cr, 0.3, 0.3, 0.3);
  cairo_arc (cr, 0, 0, 70, 0, 2 * G_PI);
  cairo_fill (cr);
  cairo_set_source_rgb (cr, 1.0, 1.0, 1.0);
  cairo_arc (cr, 0, 0, 60 + 20./3, 0, 2 * G_PI);
  cairo_fill (cr);
  cairo_set_source_rgb (cr, 0.8, 0.8, 0.8);
  cairo_arc (cr, 0, 0, 60 + 10./3, 0, 2 * G_PI);
  cairo_fill (cr);
  cairo_set_source_rgb (cr, 0.15, 0.15, 0.15);

  for (i = 0; i < 60; i++)
    {
      cairo_save (cr);
      cairo_rotate (cr, i * 6.0 / 180 * G_PI);
      if (i % 15 == 0)
        cairo_rectangle (cr, 60-17.5, -2, 17.5, 4);
      else if (i % 5 == 0)
        cairo_rectangle (cr, 60-15, -2, 15, 4);
      else
        cairo_rectangle (cr, 60-5, -1, 5, 2);
      cairo_fill (cr);

      cairo_restore (cr);
    }

  m = uhr->time_info.tm_min;
  h = (uhr->time_info.tm_hour % 12) + (double) uhr->time_info.tm_min / 60;
  cairo_set_source_rgb (cr, 0.1, 0.1, 0.1);
  cairo_save (cr);
  cairo_rotate (cr, (90 - h * 30) / 180 * G_PI);
  cairo_move_to (cr, -15, 3.5);
  cairo_line_to (cr, 37.5, 3.5);
  cairo_line_to (cr, 41, 0);
  cairo_line_to (cr, 37.5, -3.5);
  cairo_line_to (cr, -15, -3.5);
  cairo_close_path (cr);
  cairo_fill (cr);
  cairo_restore (cr);

  cairo_set_source_rgb (cr, 0.05, 0.05, 0.05);
  cairo_save (cr);
  cairo_rotate (cr, (90 - m * 6.) / 180 * G_PI);
  cairo_move_to (cr, -15, 2);
  cairo_line_to (cr, 55, 2);
  cairo_line_to (cr, 57, 0);
  cairo_line_to (cr, 55, -2);
  cairo_line_to (cr, -15, -2);
  cairo_close_path (cr);
  cairo_fill (cr);
  cairo_restore (cr);

  cairo_save (cr);
  cairo_arc (cr, 0, 0, 65, 0, 2 * G_PI);
  cairo_clip (cr);
  cairo_set_source_rgba (cr, 1.0, 1.0, 1.0, 0.3);
  cairo_arc (cr, 50, -140, 160, 0, 2 * G_PI);
  cairo_fill (cr);
  cairo_restore (cr);

  cairo_destroy (cr);

  return FALSE;
}


static void
bahnhofsuhr_plugin_init (BahnhofsuhrPlugin *uhr)
{
  GtkWidget *widget;

  widget = GTK_WIDGET (uhr);
  gtk_widget_set_size_request (GTK_WIDGET (widget), 40, 40);
  g_signal_connect_after (GTK_WIDGET (widget), "expose_event",
                          G_CALLBACK (bahnhofsuhr_expose_event),
                          uhr);
  g_signal_connect (GTK_WIDGET (widget), "screen-changed",
		    G_CALLBACK (bahnhofsuhr_screen_changed),
		    uhr);
  gtk_widget_add_events (uhr, GDK_EXPOSURE_MASK);

  gtk_widget_show_all (widget);

  hildon_desktop_home_item_set_resize_type (HILDON_DESKTOP_HOME_ITEM (uhr),
                                            HILDON_DESKTOP_HOME_ITEM_RESIZE_BOTH);

  // gtk_container_add (GTK_CONTAINER (uhr), widget);

  bahnhofsuhr_update_time (uhr);
}

static void
bahnhofsuhr_plugin_class_init (BahnhofsuhrPluginClass *class)
{
}

