#import pygtk
#pygtk.require('2.0')

import gtk
import sqlite3

class Report:


    def createModel(self):
        # ID, date, desc, amount1, currency, amount2, payer, split, (subtotals), (totals)
        cmd="gtk.ListStore(int,str,str,str,str,str,str,str"
        for row in self.accountModel.store:
            cmd+=",str"
        cmd+=")"
        self.store=eval(cmd)


    def getAccounts(self):
        self.accountIds=[]
        self.accountName={}
        for row in self.sql.execute('SELECT id, name FROM account ORDER BY id'):
            id=row[0]
            self.accountIds.append(id)
            self.accountName[id]=row[1]



    def populateModel(self):
        accountTotal={}
        for id in self.accountIds:
            accountTotal[id]=0.0
	for row in self.sql.execute('SELECT payment.id,payment.timestamp,payment.description,payment.amount,currency.name,currency.exchange_rate,payment.account_id FROM payment,currency WHERE currency.id=payment.currency_id ORDER BY timestamp'):
            payment_id=row[0]
            timestamp=row[1]
            desc=row[2]
            amount='%4.2f' % row[3]
            currency=row[4]
            rate=row[5]
            amountConv=row[3]*rate
            amountConvFmt='%.2f'% amountConv
            payer_id=row[6]

            accountTrans={}
            for id in self.accountIds:
                accountTrans[id]=0.0

            transSplit={}
            splitTotal=0.0
            for row2 in self.sql.execute('SELECT account_id,split FROM split WHERE payment_id=?', (payment_id,)):
                account_id=row2[0]
                split=row2[1]
                splitTotal+=split
                transSplit[account_id]=split
                
            for id in self.accountIds:
                if id in transSplit:
                    part=amountConv*float(transSplit[id])/splitTotal
                    accountTrans[id]+=part
                    accountTotal[id]+=part
            # Credit the payer
            accountTrans[payer_id]-=amountConv
            accountTotal[payer_id]-=amountConv

            values=[payment_id,timestamp,desc,amount,currency,amountConvFmt,self.accountName[payer_id],'%3.1f'%splitTotal]
            for id in self.accountIds:
                values.append('%.2f'%accountTrans[id])
            #for id in self.accountIds:
            #    values.append('%.2f'%accountTotal[id])

            self.store.append(values)
        values=[-1,'','','','','','', '']
        for id in self.accountIds:
            values.append('%.2f'%accountTotal[id])
        self.store.append(values)
        

    def addColumn(self,title, column, xalign=None):
        # create the TreeViewColumn to display the data
        col = gtk.TreeViewColumn(title)
        col.set_resizable(True)
        self.treeview.append_column(col)
        cell = gtk.CellRendererText()
        if xalign:
            cell.set_property('xalign', xalign)

        col.pack_start(cell, True)
        col.add_attribute(cell, 'text', column)

    def __init__(self, sql, currencyModel, accountModel, paymentModel):
        self.sql=sql
        self.currencyModel=currencyModel
        self.accountModel=accountModel
        self.paymentModel=paymentModel

        self.createModel()
        self.getAccounts()
        self.populateModel()


    def createGui(self, toplevel):

        self.dialog=gtk.Dialog(title='Report',
                               parent=toplevel,
                               flags=gtk.DIALOG_DESTROY_WITH_PARENT,
                               buttons=(gtk.STOCK_CLOSE, gtk.RESPONSE_ACCEPT))
        self.dialog.set_size_request(700, 400)

        # Account list
        vbox=self.dialog.vbox

	scroll=gtk.ScrolledWindow();
        self.treeview = gtk.TreeView(self.store)
	self.treeview.set_rules_hint(True)
	#self.treeview.set_headers_visible(False)
	#self.treeview.connect("cursor-changed", self.selectCb)
        self.treeview.set_grid_lines(gtk.TREE_VIEW_GRID_LINES_BOTH)


        # create the TreeViewColumns to display the data
        self.addColumn('Date', 1)
        self.addColumn('Description', 2)
        self.addColumn('Amount', 3, 1.0)
        self.addColumn('Currency', 4)
        self.addColumn('Converted', 5, 1.0)
        self.addColumn('Payer', 6)
        self.addColumn('Split', 7, 1.0)

        # Add variable number of columns for the accounts
        i=8
        # subtotal 
        for id in self.accountIds:
            self.addColumn(self.accountName[id], i, 1.0)
            i+=1
        # total
#         for id in self.accountIds:
#             self.addColumn(self.accountName[id], i, 1.0)
#             i+=1
        
        # make it searchable
        #treeview.set_search_column(0)

        # Allow sorting on the column
        #self.tvcolumn.set_sort_column_id(0)

        # Allow drag and drop reordering of rows
        #treeview.set_reorderable(True)

        scroll.add(self.treeview)
        #self.window.add(self.scroll)
        vbox.pack_start(scroll, expand=True, fill=True)
        #frame.add(scroll)
        vbox.show_all()
        return self.dialog

