#import pygtk
#pygtk.require('2.0')

import gtk
import sqlite3
import re

class PaymentModel:

    def __init__(self, currencyModel, accountModel):
        self.sql=None
        self.currencyModel=currencyModel
        self.accountModel=accountModel
        self.selectedIter=None
        # ID, date, description, amount, payer_account_id, payees, payer_name, fulldate, splitStr
        self.store = gtk.ListStore(int,str,str,str,str,int,object,str,str,str)

    def initFromDb(self, sql):
        self.sql=sql
	self.store.clear()
        self.selectedIter=None
        prevDate=None
	for row in self.sql.execute('SELECT id,timestamp,description,amount,currency_id,account_id FROM payment ORDER BY timestamp'):
            id=row[0]
            #date=row[1][0:10]
            date=row[1]
            if date==prevDate:
                displayDate=''
            else:
                displayDate=date
            prevDate=date
            description=row[2]
            if row[3]=='':
                amount="0"
            else:
                try:
                    amount='%4.2f' % row[3]
                except TypeError:
                    print "Caught TypeError on ",row[3]
                    amount=row[3]
            #amount='%4.2f' % row[3]
            currency=self.currencyModel.getNameById(row[4])
            payer_id=row[5]
            payer=self.accountModel.getNameById(payer_id)

            # determine the splits: hash indexed by account_id containing
            # the splits
            accounts={}
            for row2 in self.sql.execute('SELECT account_id,split FROM split WHERE payment_id=?', (id,)):
                accounts[row2[0]]=row2[1]

            splitStr=self.formatSplitString(accounts)
	    self.store.append([id,displayDate,description,amount,currency,payer_id,accounts,payer,date,splitStr])



    def formatSplitString(self, accounts):
        # Create a string representation of this payment's split,
        # for example "1/3/1"
        splitList=[]
        for row in self.accountModel.store:
            i=row[0]
            if i in accounts:
                splitList.append(str(accounts[i]))
            else:
                splitList.append('0')
        splitStr="/".join(splitList)
        return splitStr
        

    def setSelection(self, iter):
        self.selectedIter=iter

    def getSelection(self):
        return self.selectedIter

    def getField(self, column):
        return self.store[self.selectedIter][column]

    def getSplitOfAccountId(self, accocunt_id):
        return self.store[self.selectedIter][6][account_id]

    def deleteCurrent(self):
        """Delete the current entry"""
        payment_id=self.store[self.selectedIter][0]
        self.sql.execute('DELETE FROM payment WHERE id=?', (payment_id,))
        self.store.remove(self.selectedIter)
        self.selectedIter=None
        self.sql.commit()


    def updateOrAdd(self, isUpdate, timestamp, description, amount, currency_index, payer_index, accounts):
        currency_id=self.currencyModel.store[currency_index][0]
        payer_id=self.accountModel.store[payer_index][0]
        new_payment_values=[timestamp, description, amount, currency_id, payer_id]

        # Check arguments, and raise a ValueError if needed
        msg=[]
        if not re.match(r"(\d{4})-(\d{2})-(\d{2})[-_ ](\d{2}):(\d{2})",timestamp):
            msg.append("The time and date are malformed")
        if description=='':
            msg.append("The description cannot be empty")
        try:
            dummy=float(amount)
        except ValueError:
            msg.append('The amount is not a valid number')
        for account_id,split in accounts.iteritems():
            try:
                dummy=int(split)
            except ValueError:
                msg.append('The split ',split,' is not a valid number')
        if len(msg)>0:
            raise ValueError("\n".join(msg))
        

        # begin transaction
	c=self.sql.cursor()
        if isUpdate:
            # determine ID of existing record
            payment_id=self.store[self.selectedIter][0]
            c.execute('UPDATE payment SET timestamp=?, description=?, amount=?, currency_id=?, account_id=? WHERE id=?', 
                      new_payment_values+[payment_id])
            # remove existing split entries
            c.execute('DELETE FROM split WHERE payment_id=?', (payment_id,))
        else:
            # create new record
            c.execute('INSERT INTO payment (timestamp, description, amount, currency_id, account_id) VALUES (?,?,?,?,?)',
                      new_payment_values)
            # rectrieve ID
            payment_id=c.lastrowid
        # Enter split data
        for account_id, split in accounts.iteritems():
            self.sql.execute('INSERT INTO split (payment_id, account_id, split) VALUES (?,?,?)', (payment_id, account_id, split))
        self.sql.commit()
        # Adjust the model
        #displayDate=timestamp[0:10]
        displayDate=timestamp
        splitStr=self.formatSplitString(accounts)
        extended_values=[payment_id, displayDate, description, amount, 
                         self.currencyModel.getNameById(currency_id), payer_id, accounts, 
                         self.accountModel.getNameById(payer_id),timestamp,
                         splitStr]
        if isUpdate:
            self.store[self.selectedIter]=extended_values
        else:
            self.store.append(extended_values)

